# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.virtualenclaves.aio import VirtualEnclavesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestVirtualEnclavesMgmtCommunityEndpointsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(VirtualEnclavesMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_community_endpoints_get(self, resource_group):
        response = await self.client.community_endpoints.get(
            resource_group_name=resource_group.name,
            community_name="str",
            community_endpoint_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_community_endpoints_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.community_endpoints.begin_create_or_update(
                resource_group_name=resource_group.name,
                community_name="str",
                community_endpoint_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "ruleCollection": [
                            {
                                "destination": "str",
                                "destinationType": "str",
                                "endpointRuleName": "str",
                                "ports": "str",
                                "protocols": ["str"],
                                "transitHubResourceId": "str",
                            }
                        ],
                        "provisioningState": "str",
                        "resourceCollection": ["str"],
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_community_endpoints_begin_update(self, resource_group):
        response = await (
            await self.client.community_endpoints.begin_update(
                resource_group_name=resource_group.name,
                community_name="str",
                community_endpoint_name="str",
                properties={
                    "properties": {
                        "ruleCollection": [
                            {
                                "destination": "str",
                                "destinationType": "str",
                                "endpointRuleName": "str",
                                "ports": "str",
                                "protocols": ["str"],
                                "transitHubResourceId": "str",
                            }
                        ]
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_community_endpoints_begin_delete(self, resource_group):
        response = await (
            await self.client.community_endpoints.begin_delete(
                resource_group_name=resource_group.name,
                community_name="str",
                community_endpoint_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_community_endpoints_list_by_community_resource(self, resource_group):
        response = self.client.community_endpoints.list_by_community_resource(
            resource_group_name=resource_group.name,
            community_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_community_endpoints_list_by_subscription(self, resource_group):
        response = self.client.community_endpoints.list_by_subscription(
            community_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_community_endpoints_begin_handle_approval_creation(self, resource_group):
        response = await (
            await self.client.community_endpoints.begin_handle_approval_creation(
                resource_group_name=resource_group.name,
                community_name="str",
                community_endpoint_name="str",
                body={
                    "approvalStatus": "Approved",
                    "resourceRequestAction": "Create",
                    "approvalCallbackPayload": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_community_endpoints_begin_handle_approval_deletion(self, resource_group):
        response = await (
            await self.client.community_endpoints.begin_handle_approval_deletion(
                resource_group_name=resource_group.name,
                community_name="str",
                community_endpoint_name="str",
                body={"resourceRequestAction": "Create"},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
