# coding: utf-8
from flex.core import validate
from flex import load as validate_fully


def test_validate_example_specs(test_data):
    """
    This test is generated by conftest.py
    for each app in examples app and `test_data` param is:

    mod, client, specs_data, opts = test_data

    mod: examples.example_name (the test module)
    client: Flask app test client
    specs_data: {'url': {swag_specs}} for every spec in app
    opts: a dictionary of test metadata defined in the example

    :expectedresults: validate specs dictionary using flex
    """
    mod, client, specs_data, opts = test_data
    skip_full_validation = opts.get('skip_full_validation', False)
    for url, spec in specs_data.items():
        if 'openapi' not in spec and not skip_full_validation:
            # Flex can do a sophisticated and thorough validatation of
            # Swagger 2.0 specs, before it was renamed to OpenAPI.
            validate_fully(spec)
        else:
            # OpenAPI specs are not yet supported by flex, so we should fall
            # back to a fairly simple structural validation.
            validate(spec)


def test_required_attributes(test_data):
    """
    This test is generated by conftest.py
    for each app in examples app and `test_data` param is:

    mod, client, specs_data, opts = test_data

    mod: examples.example_name (the test module)
    client: Flask app test client
    specs_data: {'url': {swag_specs}} for every spec in app
    opts: a dictionary of test metadata defined in the example

    :expectedresults: assert required attributes are present
    """
    mod, client, specs_data, opts = test_data
    for url, spec in specs_data.items():
        assert 'paths' in spec, 'paths is required'
        assert 'info' in spec, 'info is required'


def test_example_swag(test_data):
    """
    This test is generated by conftest.py
    for each app in examples app and `test_data` param is:

    mod, client, specs_data, opts = test_data

    mod: examples.example_name (the test module)
    client: Flask app test client
    specs_data: {'url': {swag_specs}} for every spec in app
    opts: a dictionary of test metadata defined in the example

    :expectedresults: run mod.test_swag with no errors
    """
    mod, client, specs_data, opts = test_data
    if getattr(mod, 'test_swag', None) is not None:
        mod.test_swag(client, specs_data)
