/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.policy;

import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.policy.SelectionPolicy;
import amazon.fws.clicommando.security.SecurityKeys;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityKeysSelectionPolicy
implements SelectionPolicy<SecurityKeys> {
    public static final SecurityKeys.KeyType DEF_KEY_TYPE = SecurityKeys.KeyType.AWS_KEYS;

    public SecurityKeys select(SecurityKeys ... options) {
        return this.select((Properties)null, options);
    }

    public SecurityKeys select(Properties properties, SecurityKeys ... options) {
        SecurityKeys retVal = null;
        switch (options.length) {
            case 0: {
                break;
            }
            case 1: {
                retVal = options[0];
                break;
            }
            case 2: {
                retVal = this.chooseBetweenTwo(options);
                break;
            }
            default: {
                throw new InternalErrorException("BUG: Number of possible configured keys cannot exceed 2");
            }
        }
        if (properties != null && retVal != null && "no".equalsIgnoreCase(properties.getProperty("SOAP_SUPPORT")) && retVal.getKeyType() == SecurityKeys.KeyType.CERT_PRIVATE_KEY) {
            throw new BadInputException(ErrorMessages.ErrorCode.UNSUPPORTED_AUTHENTICATION, "X.509/RSA-PrivateKey", "AWS credentials");
        }
        return retVal;
    }

    private SecurityKeys chooseBetweenTwo(SecurityKeys[] options) {
        SecurityKeys retVal = null;
        SecurityKeys securityKeys1 = options[0];
        SecurityKeys securityKeys2 = options[1];
        if (securityKeys1.getKeyType() == securityKeys2.getKeyType()) {
            throw new InternalErrorException("BUG: cannot have both security types have the same type, in this case: " + securityKeys1.getKeyType().name());
        }
        if (securityKeys1.getInputMode() == ParamConfig.InputMode.USER) {
            retVal = securityKeys1;
            if (securityKeys2.getInputMode() == ParamConfig.InputMode.USER) {
                throw new BadInputException(ErrorMessages.ErrorCode.TOO_MANY_SECURITY_KEYS_PROVIDES, new String[0]);
            }
        } else {
            retVal = securityKeys2.getInputMode() == ParamConfig.InputMode.USER ? securityKeys2 : (securityKeys1.getKeyType() == DEF_KEY_TYPE ? securityKeys1 : securityKeys2);
        }
        return retVal;
    }
}

