info = {
    "name": "sr-Latn",
    "date_order": "DMY",
    "january": [
        "jan",
        "januar"
    ],
    "february": [
        "feb",
        "februar"
    ],
    "march": [
        "mar",
        "mart"
    ],
    "april": [
        "apr",
        "april"
    ],
    "may": [
        "maj"
    ],
    "june": [
        "jun"
    ],
    "july": [
        "jul"
    ],
    "august": [
        "avg",
        "avgust"
    ],
    "september": [
        "sep",
        "septembar"
    ],
    "october": [
        "okt",
        "oktobar"
    ],
    "november": [
        "nov",
        "novembar"
    ],
    "december": [
        "dec",
        "decembar"
    ],
    "monday": [
        "pon",
        "ponedeljak"
    ],
    "tuesday": [
        "uto",
        "utorak"
    ],
    "wednesday": [
        "sre",
        "sreda"
    ],
    "thursday": [
        "čet",
        "četvrtak"
    ],
    "friday": [
        "pet",
        "petak"
    ],
    "saturday": [
        "sub",
        "subota"
    ],
    "sunday": [
        "ned",
        "nedelja"
    ],
    "am": [
        "pre podne"
    ],
    "pm": [
        "po podne"
    ],
    "year": [
        "g",
        "god",
        "godina"
    ],
    "month": [
        "m",
        "mes",
        "mesec"
    ],
    "week": [
        "n",
        "ned",
        "nedelja"
    ],
    "day": [
        "d",
        "dan"
    ],
    "hour": [
        "sat",
        "č"
    ],
    "minute": [
        "min",
        "minut"
    ],
    "second": [
        "s",
        "sek",
        "sekund"
    ],
    "relative-type": {
        "0 day ago": [
            "danas"
        ],
        "0 hour ago": [
            "ovog sata"
        ],
        "0 minute ago": [
            "ovog minuta"
        ],
        "0 month ago": [
            "ovog meseca"
        ],
        "0 second ago": [
            "sada"
        ],
        "0 week ago": [
            "ove nedelje"
        ],
        "0 year ago": [
            "ove godine"
        ],
        "1 day ago": [
            "juče"
        ],
        "1 month ago": [
            "prošlog meseca"
        ],
        "1 week ago": [
            "prošle nedelje"
        ],
        "1 year ago": [
            "prošle godine"
        ],
        "in 1 day": [
            "sutra"
        ],
        "in 1 month": [
            "sledećeg meseca"
        ],
        "in 1 week": [
            "sledeće nedelje"
        ],
        "in 1 year": [
            "sledeće godine"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "pre (\\d+) d",
            "pre (\\d+) dana"
        ],
        "\\1 hour ago": [
            "pre (\\d+) sata",
            "pre (\\d+) sati",
            "pre (\\d+) č"
        ],
        "\\1 minute ago": [
            "pre (\\d+) min",
            "pre (\\d+) minuta"
        ],
        "\\1 month ago": [
            "pre (\\d+) m",
            "pre (\\d+) mes",
            "pre (\\d+) meseca",
            "pre (\\d+) meseci"
        ],
        "\\1 second ago": [
            "pre (\\d+) s",
            "pre (\\d+) sek",
            "pre (\\d+) sekunde",
            "pre (\\d+) sekundi"
        ],
        "\\1 week ago": [
            "pre (\\d+) n",
            "pre (\\d+) ned",
            "pre (\\d+) nedelja",
            "pre (\\d+) nedelje"
        ],
        "\\1 year ago": [
            "pre (\\d+) g",
            "pre (\\d+) god",
            "pre (\\d+) godina",
            "pre (\\d+) godine"
        ],
        "in \\1 day": [
            "za (\\d+) d",
            "za (\\d+) dan",
            "za (\\d+) dana"
        ],
        "in \\1 hour": [
            "za (\\d+) sat",
            "za (\\d+) sati",
            "za (\\d+) č"
        ],
        "in \\1 minute": [
            "za (\\d+) min",
            "za (\\d+) minut",
            "za (\\d+) minuta"
        ],
        "in \\1 month": [
            "za (\\d+) m",
            "za (\\d+) mes",
            "za (\\d+) mesec",
            "za (\\d+) meseci"
        ],
        "in \\1 second": [
            "za (\\d+) s",
            "za (\\d+) sek",
            "za (\\d+) sekundi",
            "za (\\d+) sekundu"
        ],
        "in \\1 week": [
            "za (\\d+) n",
            "za (\\d+) ned",
            "za (\\d+) nedelja",
            "za (\\d+) nedelju"
        ],
        "in \\1 year": [
            "za (\\d+) g",
            "za (\\d+) god",
            "za (\\d+) godina",
            "za (\\d+) godinu"
        ]
    },
    "locale_specific": {
        "sr-Latn-BA": {
            "name": "sr-Latn-BA",
            "september": [
                "sept"
            ],
            "tuesday": [
                "ut"
            ],
            "wednesday": [
                "sr",
                "srijeda"
            ],
            "sunday": [
                "nedjelja"
            ],
            "am": [
                "prije podne"
            ]
        },
        "sr-Latn-ME": {
            "name": "sr-Latn-ME",
            "september": [
                "sept"
            ],
            "tuesday": [
                "ut"
            ],
            "wednesday": [
                "sr",
                "srijeda"
            ],
            "sunday": [
                "nedjelja"
            ],
            "am": [
                "prije podne"
            ]
        },
        "sr-Latn-XK": {
            "name": "sr-Latn-XK",
            "september": [
                "sept"
            ],
            "tuesday": [
                "ut"
            ],
            "wednesday": [
                "sr"
            ]
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
