package org.apache.commons.openpgp;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import junit.framework.TestCase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * Test the open pgp signer.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @todo test text input as well as binary - apparently it fails cross platform
 */
public class BouncyCastleOpenPgpSignerTest
    extends TestCase
{
    private OpenPgpSigner signer = new BouncyCastleOpenPgpSigner();

    private OpenPgpSignatureVerifier verifier = new BouncyCastleOpenPgpSignatureVerifier();

    private String keyId = "A7D16BD4";

    private KeyRing keyRing;

    private static final String PASSWORD = "cop";

    protected void setUp()
        throws Exception
    {
        super.setUp();

        keyRing = new BouncyCastleKeyRing( getClass().getResourceAsStream( "/secring.gpg" ),
                                           getClass().getResourceAsStream( "/pubring.gpg" ), PASSWORD.toCharArray() );
    }

    public void testSignDataDetachedBinary()
        throws OpenPgpException, IOException
    {
        ByteArrayOutputStream signature = new ByteArrayOutputStream();
        signer.detachedSign( getClass().getResourceAsStream( "/test-input" ), signature, keyId, keyRing, false );

        // TODO: can we get it to verify an ascii armored one?
        SignatureStatus status = verifier.verifyDetachedSignature( getClass().getResourceAsStream( "/test-input" ),
                                                                   new ByteArrayInputStream( signature.toByteArray() ),
                                                                   keyRing, false );
        assertNotNull( "check we got a status", status );
        assertTrue( "check it was successful", status.isValid() );
    }

    public void testVerifySignatureDetachedBinary()
        throws IOException, OpenPgpException
    {
        // TODO: can we get it to verify an ascii armored one?
        SignatureStatus status = verifier.verifyDetachedSignature( getClass().getResourceAsStream( "/test-input" ),
                                                                   getClass().getResourceAsStream(
                                                                       "/test-signature.bpg" ), keyRing, false );

        assertNotNull( "check we got a status", status );
        assertTrue( "check it was successful", status.isValid() );
    }
}
