/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntBufferImpl;

class HeapIntBuffer
extends IntBufferImpl {
    HeapIntBuffer(int n, int[] nArray, int n2) {
        super(null, n, nArray, n2);
    }

    public boolean isDirect() {
        return false;
    }

    public IntBuffer slice() {
        return new HeapIntBuffer(this.limit - this.position, this.array, this.arrayOffset + this.position);
    }

    public int get(int n) {
        return this.array[this.arrayOffset + this.checkIndex(n)];
    }

    final void copyToArray(int[] nArray, int n, int n2) {
        System.arraycopy(this.array, this.arrayOffset + this.position, nArray, n, n2);
    }

    public IntBuffer put(int n, int n2) {
        this.array[this.arrayOffset + this.checkIndex((int)n)] = n2;
        return this;
    }

    void copyFromArray(int[] nArray, int n, int n2) {
        System.arraycopy(nArray, n, this.array, this.arrayOffset + this.position, n2);
    }

    void copyToIntBuffer(int n, IntBuffer intBuffer) {
        intBuffer.copyFromHeapIntBuffer(this, n);
    }

    void copyFromHeapIntBuffer(IntBuffer intBuffer, int n) {
        System.arraycopy(intBuffer.array, intBuffer.arrayOffset + intBuffer.position, this.array, this.arrayOffset + this.position, n);
    }

    void copyFromByteBufferAsIntBuffer(IntBuffer intBuffer, int n) {
        HeapIntBuffer.vanillaCopy(intBuffer, this, n);
    }

    void copyFromDirectIntBuffer(IntBuffer intBuffer, int n) {
        int n2 = intBuffer.arrayOffset + (intBuffer.position << 2);
        ByteBufferImpl.memoryToIntArray(n2, this.array, this.arrayOffset + this.position, n);
    }
}

