# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AdvertiseToFabric(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of if this advertisement is also made to the network fabric associated with the
    Network Cloud Cluster. This field is ignored if fabricPeeringEnabled is set to False.
    """

    TRUE = "True"
    FALSE = "False"


class AgentPoolDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the agent pool."""

    AVAILABLE = "Available"
    ERROR = "Error"
    PROVISIONING = "Provisioning"


class AgentPoolMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The selection of how this agent pool is utilized, either as a system pool or a user pool.
    System pools run the features and critical services for the Kubernetes Cluster, while user
    pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one
    system node pool with at least one node.
    """

    SYSTEM = "System"
    USER = "User"
    NOT_APPLICABLE = "NotApplicable"


class AgentPoolProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the agent pool."""

    ACCEPTED = "Accepted"
    CANCELED = "Canceled"
    DELETING = "Deleting"
    FAILED = "Failed"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"


class AvailabilityLifecycle(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The version lifecycle indicator."""

    PREVIEW = "Preview"
    GENERALLY_AVAILABLE = "GenerallyAvailable"


class BareMetalMachineCordonStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The cordon status of the bare metal machine."""

    CORDONED = "Cordoned"
    UNCORDONED = "Uncordoned"


class BareMetalMachineDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the bare metal machine."""

    PREPARING = "Preparing"
    ERROR = "Error"
    AVAILABLE = "Available"
    PROVISIONING = "Provisioning"
    PROVISIONED = "Provisioned"
    DEPROVISIONING = "Deprovisioning"


class BareMetalMachineEvacuate(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether to evacuate the node workload when the bare metal machine is cordoned."""

    TRUE = "True"
    FALSE = "False"


class BareMetalMachineHardwareValidationResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The outcome of the hardware validation."""

    PASS = "Pass"
    FAIL = "Fail"
    PASS_ENUM = "Pass"


class BareMetalMachineKeySetDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the key set."""

    ALL_ACTIVE = "AllActive"
    SOME_INVALID = "SomeInvalid"
    ALL_INVALID = "AllInvalid"
    VALIDATING = "Validating"


class BareMetalMachineKeySetPrivilegeLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The access level allowed for the users in this key set."""

    STANDARD = "Standard"
    SUPERUSER = "Superuser"


class BareMetalMachineKeySetProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the bare metal machine key set."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    ACCEPTED = "Accepted"
    PROVISIONING = "Provisioning"


class BareMetalMachineKeySetUserSetupStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether the user is currently deployed for access."""

    ACTIVE = "Active"
    INVALID = "Invalid"


class BareMetalMachinePowerState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The power state derived from the baseboard management controller."""

    ON = "On"
    OFF = "Off"


class BareMetalMachineProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the bare metal machine."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class BareMetalMachineReadyState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether the bare metal machine is ready to receive workloads."""

    TRUE = "True"
    FALSE = "False"


class BareMetalMachineSkipShutdown(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether to skip the graceful OS shutdown and power off the bare metal machine
    immediately.
    """

    TRUE = "True"
    FALSE = "False"


class BfdEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator to determine if automatic allocation from the pool should occur."""

    TRUE = "True"
    FALSE = "False"


class BgpMultiHop(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator to enable multi-hop peering support."""

    TRUE = "True"
    FALSE = "False"


class BmcKeySetDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the key set."""

    ALL_ACTIVE = "AllActive"
    SOME_INVALID = "SomeInvalid"
    ALL_INVALID = "AllInvalid"
    VALIDATING = "Validating"


class BmcKeySetPrivilegeLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The access level allowed for the users in this key set."""

    READ_ONLY = "ReadOnly"
    ADMINISTRATOR = "Administrator"


class BmcKeySetProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the baseboard management controller key set."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    ACCEPTED = "Accepted"
    PROVISIONING = "Provisioning"


class BootstrapProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of bootstrap protocol used."""

    PXE = "PXE"


class CloudServicesNetworkDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the cloud services network."""

    ERROR = "Error"
    AVAILABLE = "Available"
    PROVISIONING = "Provisioning"


class CloudServicesNetworkEnableDefaultEgressEndpoints(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether the platform default endpoints are allowed for the egress traffic."""

    TRUE = "True"
    FALSE = "False"


class CloudServicesNetworkProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the cloud services network."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class ClusterConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The latest heartbeat status between the cluster manager and the cluster."""

    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"
    UNDEFINED = "Undefined"


class ClusterContinueUpdateVersionMachineGroupTargetingMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode by which the cluster will target the next grouping of servers to continue the update."""

    ALPHA_BY_RACK = "AlphaByRack"


class ClusterDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current detailed status of the cluster."""

    PENDING_DEPLOYMENT = "PendingDeployment"
    DEPLOYING = "Deploying"
    RUNNING = "Running"
    UPDATING = "Updating"
    UPDATE_PAUSED = "UpdatePaused"
    DEGRADED = "Degraded"
    DELETING = "Deleting"
    DISCONNECTED = "Disconnected"
    FAILED = "Failed"


class ClusterManagerConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The latest connectivity status between cluster manager and the cluster."""

    CONNECTED = "Connected"
    UNREACHABLE = "Unreachable"


class ClusterManagerDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The detailed status that provides additional information about the cluster manager."""

    ERROR = "Error"
    AVAILABLE = "Available"
    PROVISIONING = "Provisioning"
    PROVISIONING_FAILED = "ProvisioningFailed"
    UPDATING = "Updating"
    UPDATE_FAILED = "UpdateFailed"


class ClusterManagerProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the cluster manager."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"
    UPDATING = "Updating"


class ClusterMetricsConfigurationDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the metrics configuration."""

    PROCESSING = "Processing"
    APPLIED = "Applied"
    ERROR = "Error"


class ClusterMetricsConfigurationProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the metrics configuration."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    ACCEPTED = "Accepted"
    PROVISIONING = "Provisioning"


class ClusterProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the cluster."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    ACCEPTED = "Accepted"
    VALIDATING = "Validating"
    UPDATING = "Updating"


class ClusterScanRuntimeParametersScanActivity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The choice of if the scan operation should run the scan."""

    SCAN = "Scan"
    SKIP = "Skip"


class ClusterSecretArchiveEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator if the specified key vault should be used to archive the secrets of the cluster."""

    TRUE = "True"
    FALSE = "False"


class ClusterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of rack configuration for the cluster."""

    SINGLE_RACK = "SingleRack"
    MULTI_RACK = "MultiRack"


class ClusterUpdateStrategyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode of operation for runtime protection."""

    RACK = "Rack"
    PAUSE_AFTER_RACK = "PauseAfterRack"


class ConsoleDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the console."""

    READY = "Ready"
    ERROR = "Error"


class ConsoleEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether the console access is enabled."""

    TRUE = "True"
    FALSE = "False"


class ConsoleProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the virtual machine console."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class ControlImpact(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether the control plane will be impacted during the upgrade."""

    TRUE = "True"
    FALSE = "False"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DefaultGateway(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether this is the default gateway.
    Only one of the attached networks (including the CloudServicesNetwork attachment) for a single
    machine may be specified as True.
    """

    TRUE = "True"
    FALSE = "False"


class DeviceConnectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The connection type of the device."""

    PCI = "PCI"


class DiskType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The disk type of rack SKU resource."""

    HDD = "HDD"
    SSD = "SSD"


class FabricPeeringEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator to specify if the load balancer peers with the network fabric."""

    TRUE = "True"
    FALSE = "False"


class FeatureDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status representing the state of this feature."""

    RUNNING = "Running"
    FAILED = "Failed"
    UNKNOWN = "Unknown"


class HugepagesSize(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The size of the hugepages to allocate."""

    TWO_M = "2M"
    ONE_G = "1G"


class HybridAksIpamEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Field Deprecated. The field was previously optional, now it will have no defined behavior and
    will be ignored. The indicator of whether or not to disable IPAM allocation on the network
    attachment definition injected into the Hybrid AKS Cluster.
    """

    TRUE = "True"
    FALSE = "False"


class HybridAksPluginType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Field Deprecated. The field was previously optional, now it will have no defined behavior and
    will be ignored. The network plugin type for Hybrid AKS.
    """

    DPDK = "DPDK"
    SRIOV = "SRIOV"
    OS_DEVICE = "OSDevice"


class IpAllocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the IP address allocation, defaulted to "DualStack"."""

    IPV4 = "IPV4"
    IPV6 = "IPV6"
    DUAL_STACK = "DualStack"


class KubernetesClusterDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the Kubernetes cluster."""

    AVAILABLE = "Available"
    ERROR = "Error"
    PROVISIONING = "Provisioning"


class KubernetesClusterFeatureAvailabilityLifecycle(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The lifecycle indicator of the feature."""

    PREVIEW = "Preview"
    GENERALLY_AVAILABLE = "GenerallyAvailable"


class KubernetesClusterFeatureDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The detailed status of the feature."""

    ERROR = "Error"
    PROVISIONING = "Provisioning"
    INSTALLED = "Installed"


class KubernetesClusterFeatureProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the Kubernetes cluster feature."""

    ACCEPTED = "Accepted"
    CANCELED = "Canceled"
    DELETING = "Deleting"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"


class KubernetesClusterFeatureRequired(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of if the feature is required or optional. Optional features may be deleted by
    the user, while required features are managed with the kubernetes cluster lifecycle.
    """

    TRUE = "True"
    FALSE = "False"


class KubernetesClusterNodeDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The detailed state of this node."""

    AVAILABLE = "Available"
    ERROR = "Error"
    PROVISIONING = "Provisioning"
    RUNNING = "Running"
    SCHEDULING = "Scheduling"
    STOPPED = "Stopped"
    TERMINATING = "Terminating"
    UNKNOWN = "Unknown"


class KubernetesClusterProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the Kubernetes cluster resource."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    ACCEPTED = "Accepted"
    IN_PROGRESS = "InProgress"
    CREATED = "Created"
    UPDATING = "Updating"
    DELETING = "Deleting"


class KubernetesNodePowerState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The power state of this node."""

    ON = "On"
    OFF = "Off"
    UNKNOWN = "Unknown"


class KubernetesNodeRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The role of this node in the cluster."""

    CONTROL_PLANE = "ControlPlane"
    WORKER = "Worker"


class KubernetesPluginType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of how this network will be utilized by the Kubernetes cluster."""

    DPDK = "DPDK"
    SRIOV = "SRIOV"
    OS_DEVICE = "OSDevice"
    MACVLAN = "MACVLAN"
    IPVLAN = "IPVLAN"


class L2NetworkDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the L2 network."""

    ERROR = "Error"
    AVAILABLE = "Available"
    PROVISIONING = "Provisioning"


class L2NetworkProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the L2 network."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class L3NetworkConfigurationIpamEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indication of whether this network will or will not perform IP address management and
    allocate IP addresses when attached.
    """

    TRUE = "True"
    FALSE = "False"


class L3NetworkDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the L3 network."""

    ERROR = "Error"
    AVAILABLE = "Available"
    PROVISIONING = "Provisioning"


class L3NetworkProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the L3 network."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class MachineSkuDiskConnectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The connection type of the rack SKU resource."""

    PCIE = "PCIE"
    SATA = "SATA"
    RAID = "RAID"
    SAS = "SAS"


class ManagedServiceIdentitySelectorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of managed identity that is being selected."""

    SYSTEM_ASSIGNED_IDENTITY = "SystemAssignedIdentity"
    USER_ASSIGNED_IDENTITY = "UserAssignedIdentity"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class OsDiskCreateOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The strategy for creating the OS disk."""

    EPHEMERAL = "Ephemeral"


class OsDiskDeleteOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The strategy for deleting the OS disk."""

    DELETE = "Delete"


class RackDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the rack."""

    ERROR = "Error"
    AVAILABLE = "Available"
    PROVISIONING = "Provisioning"


class RackProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the rack resource."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class RackSkuProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the rack SKU resource."""

    CANCELED = "Canceled"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"


class RackSkuType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the rack."""

    AGGREGATOR = "Aggregator"
    COMPUTE = "Compute"
    SINGLE = "Single"


class RemoteVendorManagementFeature(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether the storage appliance supports remote vendor management."""

    SUPPORTED = "Supported"
    UNSUPPORTED = "Unsupported"


class RemoteVendorManagementStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether the remote vendor management feature is enabled or disabled, or
    unsupported if it is an unsupported feature.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    UNSUPPORTED = "Unsupported"


class RuntimeProtectionEnforcementLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode of operation for runtime protection."""

    AUDIT = "Audit"
    DISABLED = "Disabled"
    ON_DEMAND = "OnDemand"
    PASSIVE = "Passive"
    REAL_TIME = "RealTime"


class SkipShutdown(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether to skip the graceful OS shutdown and power off the virtual machine
    immediately.
    """

    TRUE = "True"
    FALSE = "False"


class StorageApplianceDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The detailed status of the storage appliance."""

    ERROR = "Error"
    AVAILABLE = "Available"
    PROVISIONING = "Provisioning"


class StorageApplianceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the storage appliance."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class TrunkedNetworkDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the trunked network."""

    ERROR = "Error"
    AVAILABLE = "Available"
    PROVISIONING = "Provisioning"


class TrunkedNetworkProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the trunked network."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class ValidationThresholdGrouping(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Selection of how the type evaluation is applied to the cluster calculation."""

    PER_CLUSTER = "PerCluster"
    PER_RACK = "PerRack"


class ValidationThresholdType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Selection of how the threshold should be evaluated."""

    COUNT_SUCCESS = "CountSuccess"
    PERCENT_SUCCESS = "PercentSuccess"


class VirtualMachineBootMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Selects the boot method for the virtual machine."""

    UEFI = "UEFI"
    BIOS = "BIOS"


class VirtualMachineDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the virtual machine."""

    AVAILABLE = "Available"
    ERROR = "Error"
    PROVISIONING = "Provisioning"
    RUNNING = "Running"
    SCHEDULING = "Scheduling"
    STOPPED = "Stopped"
    TERMINATING = "Terminating"
    UNKNOWN = "Unknown"


class VirtualMachineDeviceModelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the device model to use."""

    T1 = "T1"
    T2 = "T2"


class VirtualMachineIPAllocationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The IP allocation mechanism for the virtual machine.
    Dynamic and Static are only valid for l3Network which may also specify Disabled.
    Otherwise, Disabled is the only permitted value.
    """

    DYNAMIC = "Dynamic"
    STATIC = "Static"
    DISABLED = "Disabled"


class VirtualMachineIsolateEmulatorThread(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Field Deprecated, the value will be ignored if provided. The indicator of whether one of the
    specified CPU cores is isolated to run the emulator thread for this virtual machine.
    """

    TRUE = "True"
    FALSE = "False"


class VirtualMachinePlacementHintPodAffinityScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scope for the virtual machine affinity or anti-affinity placement hint. It should always be
    "Machine" in the case of node affinity.
    """

    RACK = "Rack"
    MACHINE = "Machine"


class VirtualMachinePlacementHintType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The specification of whether this hint supports affinity or anti-affinity with the referenced
    resources.
    """

    AFFINITY = "Affinity"
    ANTI_AFFINITY = "AntiAffinity"


class VirtualMachinePowerState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The power state of the virtual machine."""

    ON = "On"
    OFF = "Off"
    UNKNOWN = "Unknown"


class VirtualMachineProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the virtual machine."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class VirtualMachineSchedulingExecution(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether the hint is a hard or soft requirement during scheduling."""

    HARD = "Hard"
    SOFT = "Soft"


class VirtualMachineVirtioInterfaceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Field Deprecated, use virtualizationModel instead. The type of the virtio interface."""

    MODERN = "Modern"
    TRANSITIONAL = "Transitional"


class VolumeDetailedStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The more detailed status of the volume."""

    ERROR = "Error"
    ACTIVE = "Active"
    PROVISIONING = "Provisioning"


class VolumeProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the volume."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    ACCEPTED = "Accepted"


class WorkloadImpact(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The indicator of whether the workload will be impacted during the upgrade."""

    TRUE = "True"
    FALSE = "False"
