# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.preview.bulk_exports.export import ExportList
from twilio.rest.preview.bulk_exports.export_configuration import ExportConfigurationList


class BulkExports(Version):

    def __init__(self, domain):
        """
        Initialize the BulkExports version of Preview

        :returns: BulkExports version of Preview
        :rtype: twilio.rest.preview.bulk_exports.BulkExports.BulkExports
        """
        super(BulkExports, self).__init__(domain)
        self.version = 'BulkExports'
        self._exports = None
        self._export_configuration = None

    @property
    def exports(self):
        """
        :rtype: twilio.rest.preview.bulk_exports.export.ExportList
        """
        if self._exports is None:
            self._exports = ExportList(self)
        return self._exports

    @property
    def export_configuration(self):
        """
        :rtype: twilio.rest.preview.bulk_exports.export_configuration.ExportConfigurationList
        """
        if self._export_configuration is None:
            self._export_configuration = ExportConfigurationList(self)
        return self._export_configuration

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.BulkExports>'
