/*
** TSHIFT -- Copy MIDI data from the standard input to the standard output,
** shifting the times by 'offset' to delay or rush the events.
** Example: 'tshift -b-0.5 <foo >fum' deletes the first 1/2 measures
** of 'foo' and leaves the shortened version in 'fum'.
*/
#include <stdio.h>
#include <midi.h>

main(argc, argv)
char *argv[];
{
	int laststat = 0;
	long now = 0L, offset = 0L;
	MCMD *mp;
	extern float atof();

	while (--argc > 0) {
	    if (argv[argc][0] == '-') {
		switch (argv[argc][1]) {
		case 'b':
		    offset = atof(&argv[argc][2]) * (2. * MPU_CLOCK_PERIOD);
		    break;
		case 'c':
		    offset = atoi(&argv[argc][2]);
		    break;
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s [-bBARS] [-cCLOCKS] <file\n",
		 argv[0]);
		exit(2);
	    }
	}
	while (mp = getmcmd(stdin, now)) {
	    now = mp->when;
	    mp->when += offset;
	    if (mp->when >= 0)
		putmcmd(stdout, mp);
	    laststat = mp->cmd[0];
	}
	if (laststat != RT_TCWME) {
	    Rt_tcwme.when = now + offset;
	    putmcmd(stdout, &Rt_tcwme);
	}
}
