/*                                                 MIDIOPS.H   */

#define NOTEOFF_TYPE  0x80
#define NOTEON_TYPE   0x90
#define POLYAFT_TYPE  0xA0
#define CONTROL_TYPE  0xB0
#define PROGRAM_TYPE  0xC0
#define CHNPRES_TYPE  0xD0
#define PCHBEND_TYPE  0xE0
#define SYSTEM_TYPE   0xF0

#define SUSTAIN_SW    64

typedef struct {
    short  type;
    short  chan;
    short  dat1;
    short  dat2;
} MEVENT;

typedef struct {
    OPDS   h;
    float  *r;
} MIDIVAL;

typedef struct {
    OPDS   h;
    float  *r, *imax, *ifn;
} MIDIAMP;

typedef struct {
    OPDS   h;
    float  *r, *iscal;
    float  scale;
} MIDISCL;

typedef struct {
    OPDS   h;
    float  *r, *ictlno;
    long   ctlno;
    float  scale;
} MIDICTL;
