/*
** SXSTRIP -- Strip sys. excl. commands from MPU data
**	psl 4/88
*/
#include <stdio.h>
#include <midi.h>

main(argc, argv)
char	*argv[];
{

	register int i, n, verbose = 0;
	u_char c;

	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'v':
		    verbose++;
		    break;
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s [-verbose]\n", argv[0]);
		exit(2);
	    }
	}
	while ((i = getc(stdin)) != EOF) {
	    c = i;
	    if (c != SX_CMD)
		fputc(c, stdout);
	    else {
		if (verbose)
		    fprintf(stderr, "Stripping: %02x", c);
		for (n = 1; (i = getc(stdin)) != EOF; n++) {
		    c = i;
		    if (MIDI_RT(c)) {
			fputc(c, stdout);
			continue;
		    }
		    if (verbose && n < 8)
			fprintf(stderr, " %02x", c);
		    if (MIDI_EOX(c))
			break;
		}
		if (verbose)
		    fprintf(stderr, "\n");
	    }
	}
	exit(0);
}
