#include <stdio.h>
#include <libdev.h>
#include <libmidi.h>

#define Case break; case
#define Default break; default
#define u_char unsigned char

/*
** Disassemble MIDI system exclusive commands and print them on 'f'.
** Return '0' if ok, '-1' if no vector available for the synthesizer id.
** `Note`: This routine vectors the system exclusive command to the proper
** disassembler based on the decoded manufacturer's midi id number.
** To add additional synthesizers:
** .IP 1)
**     add an '#include' statement for its library header file, which
**     must contain a macro for the manufacturer's midi ID number,
** .IP 2)
**     insert a 'case...' statement below to call the routine.
** .LP
*/
da_sx(f,c)
FILE *f;	/* output file */
u_char *c;	/* array of MIDI commands */
{
	register int i, j;

	fprintf(f, "system exclusive\n");
	switch (c[1]) {
	Case ID_DX7:
	    da_dx7_sx(f,c);
	Case ID_ENSONIQ:
	    da_mirage_sx(f,c);
	Case ID_LEXICON:
	    fprintf(f,"%5x ; Lexicon mfg id=%d\n", c[1], c[1]);
	    j = 1;
	    goto dump;
	Case ID_MISC:
	    switch (SUBID(c[2], c[3])) {
	    Case SUBID_IOTA:
		if ((j = da_iota_sx(f,c)) > 0)
		    goto dump;
	    Case SUBID_HEADER:
		if ((j = da_head_sx(f,c)) > 0)
		    goto dump;
	    Default:
		fprintf(f,
		 "%5x %2x %2x ; da_sx: unknown misc mfg id=\t%d %d %d\n",
		 c[1], c[2], c[3], c[1], c[2], c[3]);
		j = 4;
		goto dump;
	    }
	Default:
	    fprintf(f,"%5x ; da_sx: unknown mfg id=%d\n", c[1], c[1]);
	    j = 1;
dump:
	    for (i = 1; c[j + i] != SX_EOB; i++)
		fprintf(f, "%3x%s", c[j + i], (i % 16)? "" : "\n");
	    if ((i % 16) != 1)
		fprintf(f, "\n");
	}
	return 0;
}
