/*	SYSEXMON -- Watch Mpudev & print any sysex commands
**	psl 4/88
*/
#include	<stdio.h>
#include	<midi.h>

char	*Mpudev = MPU_DEV_0;

main(argc, argv)
char	*argv[];
{
	register int fh, mode;
	u_char buf[8], *bp;

	if (argc != 1) {
	    fprintf(stderr, "Usage: %s\n", argv[0]);
	    exit(2);
	}
	if ((fh = open(Mpudev, 2)) < 0) {
	    perror(Mpudev);
	    exit(1);
	}
	bp = buf;
	*bp++ = MPU_RESET;
	*bp++ = MPU_EXCLUSIVE_TO_HOST_ON;
	*bp++ = MPU_SEND_MEASURE_END_OFF;
	write(fh, buf, bp - buf);	/* command track by default */
	bp = buf;
	for (mode = 0; read(fh, bp, 1) > 0; ) {
	    if (mode == 0 && *bp == SX_CMD)
		mode = SX_CMD;
	    if (mode == SX_CMD) {
		printf(" %02x", *bp);
		if (MIDI_EOX(*bp)) {
		    printf("\n");
		    mode = 0;
		}
	    }
	}
}
