#include <libmidi.h>
#include <libdx7.h>
#define u_char unsigned char
#define Case	break; case
#define Default break; default

vdx7(dx, c)
	struct dx7 *dx;	/* virtual dx7 */
	u_char c[3];	/* midi command */
/*
 * Set parameter on state structure,
 * return '-1' on unknown command, '0' if okay.
 * Only accepts channel commands.
 */
{
	switch (*c) {
	Case CH_KEY_OFF:if (dx->dx7_kbd_val[c[1]]) dx->dx7_nsv--;
		 	dx->dx7_kbd_val[c[1]] = 0;
	Case CH_KEY_ON: if (!dx->dx7_kbd_val[c[1]] && c[2]) dx->dx7_nsv++;
			dx->dx7_kbd_val[c[1]] = c[2];
	Case CH_CTL:	dx->dx7_ctl_val[c[1]] = c[2];
	Case CH_PRG:	dx->dx7_prg_val = c[1];
	Case CH_P_BEND: dx->dx7_pbd_val = (c[1] << 8) | c[2];
	Default:	MidiError("vdx7: bad channel command=%d\n", c);
			return -1;
	}
	return 0;
}
