/* File: tables.c */

/* Stat effects, blows per round (inc. non-stat effects), store owners, 
 * speed-to-energy, base exp level cost, player sexes, races, classes, 
 * spell table (for each class), spells in books, traps on chests, class 
 * names, color names, stat abbrevs, window flags, options and their
 * default values.  Druid blows.  What classes are legal for what races.
 *
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

#include "angband.h"

/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/* What classes a race can realistically play. -LM- */
bool legal_class[MAX_RACES][MAX_CLASS] = 
{

/* Warrior, Mage, Priest, Rogue, Ranger, Paladin, Druid, Necromancer, Assassin */

	{1,	1,	1,	1,	1,	1,	1,	1,	1 },		/*Human*/
	{1,	1,	1,	1,	1,	1,	1,	1,	1 },		/*Half-Elf*/
	{1,	1,	1,	1,	1,	0,	1,	1,	1 },		/*Elf*/
	{1,	1,	0,	1,	0,	0,	1,	0,	1 },		/*Hobbit*/
	{1,	1,	1,	1,	0,	0,	0,	1,	1 },		/*Gnome*/
	{1,	0,	1,	0,	0,	0,	0,	1,	0 },		/*Dwarf*/
	{1,	0,	1,	1,	0,	0,	0,	1,	1 },		/*Half-Orc*/
	{1,	0,	1,	0,	0,	0,	0,	1,	0 },		/*Half-Troll*/
	{1,	1,	1,	1,	1,	1,	1,	1,	1 },		/*Dunadain*/
	{1,	1,	1,	1,	1,	0,	1,	1,	1 }		/*High-Elf*/
};



/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	1	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	4	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	4	/* 18/120-18/129 */,
	4	/* 18/130-18/139 */,
	4	/* 18/140-18/149 */,
	4	/* 18/150-18/159 */,
	4	/* 18/160-18/169 */,
	4	/* 18/170-18/179 */,
	4	/* 18/180-18/189 */,
	4	/* 18/190-18/199 */,
	4	/* 18/200-18/209 */,
	4	/* 18/210-18/219 */,
	4	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra half-mana-points per level
 */
byte adj_mag_mana[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	1	/* 7 */,
	1	/* 8 */,
	2	/* 9 */,
	2	/* 10 */,
	2	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	16	/* 18/190-18/199 */,
	16	/* 18/200-18/209 */,
	16	/* 18/210-18/219 */,
	16	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99	/* 3 */,
	99	/* 4 */,
	99	/* 5 */,
	99	/* 6 */,
	50	/* 7 */,
	40	/* 8 */,
	30	/* 9 */,
	20	/* 10 */,
	15	/* 11 */,
	12	/* 12 */,
	11	/* 13 */,
	10	/* 14 */,
	9	/* 15 */,
	8	/* 16 */,
	7	/* 17 */,
	6	/* 18/00-18/09 */,
	6	/* 18/10-18/19 */,
	5	/* 18/20-18/29 */,
	5	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	4	/* 18/70-18/79 */,
	4	/* 18/80-18/89 */,
	3	/* 18/90-18/99 */,
	3	/* 18/100-18/109 */,
	2	/* 18/110-18/119 */,
	2	/* 18/120-18/129 */,
	2	/* 18/130-18/139 */,
	2	/* 18/140-18/149 */,
	1	/* 18/150-18/159 */,
	1	/* 18/160-18/169 */,
	1	/* 18/170-18/179 */,
	1	/* 18/180-18/189 */,
	1	/* 18/190-18/199 */,
	0	/* 18/200-18/209 */,
	0	/* 18/210-18/219 */,
	0	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Reduction of failure rate
 */
byte adj_mag_stat[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	17	/* 18/190-18/199 */,
	18	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentage of normal.  Effect of CHR 
 * increased because of changes elsewhere. -LM-
 */
byte adj_chr_gold[] =
{
	150	/* 3 */,
	143	/* 4 */,
	138	/* 5 */,
	132	/* 6 */,
	127	/* 7 */,
	123	/* 8 */,
	120	/* 9 */,
	117	/* 10 */,
	114	/* 11 */,
	112	/* 12 */,
	110	/* 13 */,
	108	/* 14 */,
	106	/* 15 */,
	104	/* 16 */,
	102	/* 17 */,
	100	/* 18/00-18/09 */,
	99	/* 18/10-18/19 */,
	98	/* 18/20-18/29 */,
	97	/* 18/30-18/39 */,
	96	/* 18/40-18/49 */,
	95	/* 18/50-18/59 */,
	94	/* 18/60-18/69 */,
	93	/* 18/70-18/79 */,
	92	/* 18/80-18/89 */,
	91	/* 18/90-18/99 */,
	90	/* 18/100-18/109 */,
	89	/* 18/110-18/119 */,
	88	/* 18/120-18/129 */,
	87	/* 18/130-18/139 */,
	86	/* 18/140-18/149 */,
	85	/* 18/150-18/159 */,
	84	/* 18/160-18/169 */,
	83	/* 18/170-18/179 */,
	82	/* 18/180-18/189 */,
	81	/* 18/190-18/199 */,
	80	/* 18/200-18/209 */,
	80	/* 18/210-18/219 */,
	80	/* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	4	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	6	/* 18/60-18/69 */,
	6	/* 18/70-18/79 */,
	7	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	17	/* 18/190-18/199 */,
	18	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	5	/* 18/80-18/89 */,
	6	/* 18/90-18/99 */,
	7	/* 18/100-18/109 */,
	8	/* 18/110-18/119 */,
	9	/* 18/120-18/129 */,
	10	/* 18/130-18/139 */,
	11	/* 18/140-18/149 */,
	12	/* 18/150-18/159 */,
	13	/* 18/160-18/169 */,
	14	/* 18/170-18/179 */,
	15	/* 18/180-18/189 */,
	16	/* 18/190-18/199 */,
	17	/* 18/200-18/209 */,
	18	/* 18/210-18/219 */,
	19	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	0	/* 10 */,
	0	/* 11 */,
	0	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	4	/* 18/00-18/09 */,
	4	/* 18/10-18/19 */,
	4	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	5	/* 18/60-18/69 */,
	6	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	8	/* 18/110-18/119 */,
	8	/* 18/120-18/129 */,
	8	/* 18/130-18/139 */,
	8	/* 18/140-18/149 */,
	9	/* 18/150-18/159 */,
	9	/* 18/160-18/169 */,
	9	/* 18/170-18/179 */,
	9	/* 18/180-18/189 */,
	9	/* 18/190-18/199 */,
	10	/* 18/200-18/209 */,
	10	/* 18/210-18/219 */,
	10	/* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	4	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	6	/* 18/60-18/69 */,
	7	/* 18/70-18/79 */,
	8	/* 18/80-18/89 */,
	9	/* 18/90-18/99 */,
	10	/* 18/100-18/109 */,
	10	/* 18/110-18/119 */,
	11	/* 18/120-18/129 */,
	12	/* 18/130-18/139 */,
	13	/* 18/140-18/149 */,
	14	/* 18/150-18/159 */,
	15	/* 18/160-18/169 */,
	16	/* 18/170-18/179 */,
	17	/* 18/180-18/189 */,
	18	/* 18/190-18/199 */,
	19	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	19	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 1	/* 16 */,
	128 + 1	/* 17 */,
	128 + 2	/* 18/00-18/09 */,
	128 + 2	/* 18/10-18/19 */,
	128 + 2	/* 18/20-18/29 */,
	128 + 2	/* 18/30-18/39 */,
	128 + 2	/* 18/40-18/49 */,
	128 + 3	/* 18/50-18/59 */,
	128 + 3	/* 18/60-18/69 */,
	128 + 3	/* 18/70-18/79 */,
	128 + 4	/* 18/80-18/89 */,
	128 + 5	/* 18/90-18/99 */,
	128 + 6	/* 18/100-18/109 */,
	128 + 7	/* 18/110-18/119 */,
	128 + 8	/* 18/120-18/129 */,
	128 + 9	/* 18/130-18/139 */,
	128 + 9	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to Deadliness (plus 128).  To compensate
 * for changes elsewhere, STR now has a larger effect. -LM-
 */
byte adj_str_td[] =
{
	128 + -2	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 5	/* 18/30-18/39 */,
	128 + 6	/* 18/40-18/49 */,
	128 + 7	/* 18/50-18/59 */,
	128 + 8	/* 18/60-18/69 */,
	128 + 9	/* 18/70-18/79 */,
	128 + 10	/* 18/80-18/89 */,
	128 + 11	/* 18/90-18/99 */,
	128 + 12	/* 18/100-18/109 */,
	128 + 13	/* 18/110-18/119 */,
	128 + 14	/* 18/120-18/129 */,
	128 + 15	/* 18/130-18/139 */,
	128 + 16	/* 18/140-18/149 */,
	128 + 17	/* 18/150-18/159 */,
	128 + 18	/* 18/160-18/169 */,
	128 + 19	/* 18/170-18/179 */,
	128 + 20	/* 18/180-18/189 */,
	128 + 21	/* 18/190-18/199 */,
	128 + 22	/* 18/200-18/209 */,
	128 + 23	/* 18/210-18/219 */,
	128 + 25	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to Skill (plus 128.  To compensate for
 * changes elsewhere, DEX now has a larger effect. -LM-
 */
byte adj_dex_th[] =
{
	128 + -4	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + -1	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 2	/* 16 */,
	128 + 3	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 3	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 4	/* 18/30-18/39 */,
	128 + 4	/* 18/40-18/49 */,
	128 + 5	/* 18/50-18/59 */,
	128 + 5	/* 18/60-18/69 */,
	128 + 6	/* 18/70-18/79 */,
	128 + 6	/* 18/80-18/89 */,
	128 + 7	/* 18/90-18/99 */,
	128 + 8	/* 18/100-18/109 */,
	128 + 9	/* 18/110-18/119 */,
	128 + 10	/* 18/120-18/129 */,
	128 + 11	/* 18/130-18/139 */,
	128 + 12	/* 18/140-18/149 */,
	128 + 13	/* 18/150-18/159 */,
	128 + 14	/* 18/160-18/169 */,
	128 + 15	/* 18/170-18/179 */,
	128 + 16	/* 18/180-18/189 */,
	128 + 17	/* 18/190-18/199 */,
	128 + 18	/* 18/200-18/209 */,
	128 + 19	/* 18/210-18/219 */,
	128 + 20	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to Skill (plus 128).  Because combat Skill as
 * implemented in Oangband has far more to do with dexterity and knowledge
 * than strength, I have reduced the effect of this stat. -LM-
 */
byte adj_str_th[] =
{
	128 + -3	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 0	/* 16 */,
	128 + 0	/* 17 */,
	128 + 1	/* 18/00-18/09 */,
	128 + 1	/* 18/10-18/19 */,
	128 + 1	/* 18/20-18/29 */,
	128 + 1	/* 18/30-18/39 */,
	128 + 1	/* 18/40-18/49 */,
	128 + 1	/* 18/50-18/59 */,
	128 + 1	/* 18/60-18/69 */,
	128 + 2	/* 18/70-18/79 */,
	128 + 2	/* 18/80-18/89 */,
	128 + 2	/* 18/90-18/99 */,
	128 + 3	/* 18/100-18/109 */,
	128 + 3	/* 18/110-18/119 */,
	128 + 3	/* 18/120-18/129 */,
	128 + 3	/* 18/130-18/139 */,
	128 + 3	/* 18/140-18/149 */,
	128 + 4	/* 18/150-18/159 */,
	128 + 4	/* 18/160-18/169 */,
	128 + 4	/* 18/170-18/179 */,
	128 + 4	/* 18/180-18/189 */,
	128 + 4	/* 18/190-18/199 */,
	128 + 5	/* 18/200-18/209 */,
	128 + 5	/* 18/210-18/219 */,
	128 + 5	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	5	/* 3 */,
	6	/* 4 */,
	7	/* 5 */,
	8	/* 6 */,
	9	/* 7 */,
	10	/* 8 */,
	11	/* 9 */,
	12	/* 10 */,
	13	/* 11 */,
	14	/* 12 */,
	15	/* 13 */,
	16	/* 14 */,
	17	/* 15 */,
	18	/* 16 */,
	19	/* 17 */,
	20	/* 18/00-18/09 */,
	22	/* 18/10-18/19 */,
	24	/* 18/20-18/29 */,
	26	/* 18/30-18/39 */,
	28	/* 18/40-18/49 */,
	30	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	30	/* 18/70-18/79 */,
	30	/* 18/80-18/89 */,
	30	/* 18/90-18/99 */,
	30	/* 18/100-18/109 */,
	30	/* 18/110-18/119 */,
	30	/* 18/120-18/129 */,
	30	/* 18/130-18/139 */,
	30	/* 18/140-18/149 */,
	30	/* 18/150-18/159 */,
	30	/* 18/160-18/169 */,
	30	/* 18/170-18/179 */,
	30	/* 18/180-18/189 */,
	30	/* 18/190-18/199 */,
	30	/* 18/200-18/209 */,
	30	/* 18/210-18/219 */,
	30	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4	/* 3 */,
	5	/* 4 */,
	6	/* 5 */,
	7	/* 6 */,
	8	/* 7 */,
	10	/* 8 */,
	12	/* 9 */,
	14	/* 10 */,
	16	/* 11 */,
	18	/* 12 */,
	20	/* 13 */,
	22	/* 14 */,
	24	/* 15 */,
	26	/* 16 */,
	28	/* 17 */,
	30	/* 18/00-18/09 */,
	30	/* 18/10-18/19 */,
	35	/* 18/20-18/29 */,
	40	/* 18/30-18/39 */,
	45	/* 18/40-18/49 */,
	50	/* 18/50-18/59 */,
	55	/* 18/60-18/69 */,
	60	/* 18/70-18/79 */,
	65	/* 18/80-18/89 */,
	70	/* 18/90-18/99 */,
	80	/* 18/100-18/109 */,
	80	/* 18/110-18/119 */,
	80	/* 18/120-18/129 */,
	80	/* 18/130-18/139 */,
	80	/* 18/140-18/149 */,
	90	/* 18/150-18/159 */,
	90	/* 18/160-18/169 */,
	90	/* 18/170-18/179 */,
	90	/* 18/180-18/189 */,
	90	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0	/* 3 */,
	0	/* 4 */,
	1	/* 5 */,
	2	/* 6 */,
	3	/* 7 */,
	4	/* 8 */,
	4	/* 9 */,
	5	/* 10 */,
	5	/* 11 */,
	6	/* 12 */,
	6	/* 13 */,
	7	/* 14 */,
	7	/* 15 */,
	8	/* 16 */,
	8	/* 17 */,
	9	/* 18/00-18/09 */,
	10	/* 18/10-18/19 */,
	12	/* 18/20-18/29 */,
	15	/* 18/30-18/39 */,
	20	/* 18/40-18/49 */,
	25	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	35	/* 18/70-18/79 */,
	40	/* 18/80-18/89 */,
	45	/* 18/90-18/99 */,
	50	/* 18/100-18/109 */,
	55	/* 18/110-18/119 */,
	60	/* 18/120-18/129 */,
	65	/* 18/130-18/139 */,
	70	/* 18/140-18/149 */,
	75	/* 18/150-18/159 */,
	80	/* 18/160-18/169 */,
	85	/* 18/170-18/179 */,
	90	/* 18/180-18/189 */,
	95	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table.  Altered by LM.
 */
byte adj_str_blow[] =
{
	3	/* 3 */,
	4	/* 4 */,
	5	/* 5 */,
	6	/* 6 */,
	7	/* 7 */,
	8	/* 8 */,
	9	/* 9 */,
	10	/* 10 */,
	11	/* 11 */,
	12	/* 12 */,
	13	/* 13 */,
	14	/* 14 */,
	15	/* 15 */,
	16	/* 16 */,
	17	/* 17 */,
	19 /* 18/00-18/09 */,
	23 /* 18/10-18/19 */,
	27 /* 18/20-18/29 */,
	31 /* 18/30-18/39 */,
	35 /* 18/40-18/49 */,
	40 /* 18/50-18/59 */,
	45 /* 18/60-18/69 */,
	50 /* 18/70-18/79 */,
	55 /* 18/80-18/89 */,
	60 /* 18/90-18/99 */,
	70 /* 18/100-18/109 */,
	80 /* 18/110-18/119 */,
	90 /* 18/120-18/129 */,
	100 /* 18/130-18/139 */,
	110 /* 18/140-18/149 */,
	120 /* 18/150-18/159 */,
	130 /* 18/160-18/169 */,
	140 /* 18/170-18/179 */,
	150 /* 18/180-18/189 */,
	160 /* 18/190-18/199 */,
	170 /* 18/200-18/209 */,
	180 /* 18/210-18/219 */,
	190 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	1	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	4	/* 18/70-18/79 */,
	4	/* 18/80-18/89 */,
	5	/* 18/90-18/99 */,
	6	/* 18/100-18/109 */,
	7	/* 18/110-18/119 */,
	8	/* 18/120-18/129 */,
	9	/* 18/130-18/139 */,
	10	/* 18/140-18/149 */,
	11	/* 18/150-18/159 */,
	12	/* 18/160-18/169 */,
	14	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	18	/* 18/190-18/199 */,
	20	/* 18/200-18/209 */,
	20	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling".  Modified to 
 * make both theft and security from theft less of a sure thing by LM.  Now
 * thefts work like hits do, with a minimum chance of 5% and a max of 95%.
 */
byte adj_dex_safe[] =
{
	5	/* 3 */,
	5	/* 4 */,
	6	/* 5 */,
	6	/* 6 */,
	7	/* 7 */,
	7	/* 8 */,
	8	/* 9 */,
	8	/* 10 */,
	9	/* 11 */,
	10	/* 12 */,
	12	/* 13 */,
	14	/* 14 */,
	16	/* 15 */,
	18	/* 16 */,
	20	/* 17 */,
	22	/* 18/00-18/09 */,
	25	/* 18/10-18/19 */,
	27	/* 18/20-18/29 */,
	30	/* 18/30-18/39 */,
	32	/* 18/40-18/49 */,
	35	/* 18/50-18/59 */,
	40	/* 18/60-18/69 */,
	45	/* 18/70-18/79 */,
	50	/* 18/80-18/89 */,
	55	/* 18/90-18/99 */,
	60	/* 18/100-18/109 */,
	65	/* 18/110-18/119 */,
	70	/* 18/120-18/129 */,
	75	/* 18/130-18/139 */,
	80	/* 18/140-18/149 */,
	82	/* 18/150-18/159 */,
	85	/* 18/160-18/169 */,
	87	/* 18/170-18/179 */,
	90	/* 18/180-18/189 */,
	92	/* 18/190-18/199 */,
	95	/* 18/200-18/209 */,
	95	/* 18/210-18/219 */,
	95	/* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	0	/* 10 */,
	0	/* 11 */,
	0	/* 12 */,
	0	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	3	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	6	/* 18/130-18/139 */,
	6	/* 18/140-18/149 */,
	7	/* 18/150-18/159 */,
	7	/* 18/160-18/169 */,
	8	/* 18/170-18/179 */,
	8	/* 18/180-18/189 */,
	8	/* 18/190-18/199 */,
	9	/* 18/200-18/209 */,
	9	/* 18/210-18/219 */,
	9	/* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128).
 * Because monsters don't breath as powerfully now, I have reduced the
 * effect of this stat. -LM-
 */
byte adj_con_mhp[] =
{
	128 + -5	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 4	/* 18/30-18/39 */,
	128 + 4	/* 18/40-18/49 */,
	128 + 5	/* 18/50-18/59 */,
	128 + 5	/* 18/60-18/69 */,
	128 + 6	/* 18/70-18/79 */,
	128 + 6	/* 18/80-18/89 */,
	128 + 7	/* 18/90-18/99 */,
	128 + 8	/* 18/100-18/109 */,
	128 + 9	/* 18/110-18/119 */,
	128 + 9	/* 18/120-18/129 */,
	128 + 10	/* 18/130-18/139 */,
	128 + 11	/* 18/140-18/149 */,
	128 + 12	/* 18/150-18/159 */,
	128 + 12	/* 18/160-18/169 */,
	128 + 13	/* 18/170-18/179 */,
	128 + 14	/* 18/180-18/189 */,
	128 + 15	/* 18/190-18/199 */,
	128 + 17	/* 18/200-18/209 */,
	128 + 18	/* 18/210-18/219 */,
	128 + 20	/* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from two to four blows/round, but is set to one (in
 * Xtra1.c) if the weapon is too heavy to wield effectively. -LM-
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class (figures in xtra1.c), we extract some values:
 *
 *    Warrior --> num = 4; mul = 5; div = MAX(30, weapon_weight);
 *    Mage    --> num = 4; mul = 2; div = MAX(30, weapon_weight);
 *    Priest  --> num = 4; mul = 3; div = MAX(30, weapon_weight);
 *    Rogue   --> num = 4; mul = 3; div = MAX(30, weapon_weight);
 *    Ranger  --> num = 4; mul = 4; div = MAX(30, weapon_weight);
 *    Paladin --> num = 4; mul = 4; div = MAX(30, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 * Eventually, all this will be greatly simplified.  -LM-
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/* 0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */

	/* 0  */
	{  2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2},

	/* 1 */
	{  2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3},

	/* 2 */
	{  2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3},

	/* 3 */
	{  2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   4},

	/* 4 */
	{  2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   4,   4},

	/* 5 */
	{  2,   2,   2,   2,   3,   3,   3,   3,   3,   4,   4,   4},

	/* 6 */
	{  2,   2,   2,   2,   3,   3,   3,   3,   4,   4,   4,   4},

	/* 7 */
	{  2,   2,   2,   3,   3,   3,   3,   4,   4,   4,   4,   4},

	/* 8 */
	{  2,   2,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4},

	/* 9 */
	{  2,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4},

	/* 10 */
	{  2,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4},

	/* 11+ */
	{  3,   3,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4}
};

/* The old blows table has been removed. -LM- */

/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store */
		{ "Haldro the Friendly",	200,		170, 108,  5, 15, RACE_HOBBIT},
		{ "Rincewind the Chicken",	200,		175, 108,  4, 12, RACE_HUMAN},
		{ "Snafu the Midget",		300,		170, 107,  5, 15, RACE_GNOME},
		{ "Lyar-el the Comely",		300,		165, 107,  6, 18, RACE_ELF},
	},
	{
		/* Armoury */
		{ "Kon-Dar the Ugly",		5000,		210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",		10000,	190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",	25000,  	200, 112,  4, 10, RACE_DUNADAN},
		{ "Mauglin the Grumpy",		30000,	200, 112,  4,  5, RACE_DWARF},
	},
	{
		/* Weapon Smith */
		{ "Ithyl-Mak the Beastly",	5000,		210, 115,  6,  6, RACE_HALF_TROLL},
		{ "Arndal Beast-Slayer",	10000,	185, 110,  5,  9, RACE_HALF_ELF},
		{ "Tarl Stronginthearm",	25000,	190, 115,  5,  7, RACE_HOBBIT},
		{ "Oglign Dragon-Slayer",	30000,	195, 112,  4,  8, RACE_DWARF},
	},
	{
		/* Temple */
		{ "Ludwig the Humble",		5000,		175, 109,  6, 15, RACE_HUMAN},
		{ "Gunnar the Paladin",		10000,	185, 110,  5, 23, RACE_HUMAN},
		{ "Delilah the Pure",		25000,	180, 107,  6, 20, RACE_ELF},
		{ "Bosk the Wise",		30000,	185, 109,  5, 15, RACE_DWARF},
	},
	{
		{ "Mauser the Chemist",		10000,	190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",		10000,	190, 110,  6,  8, RACE_HOBBIT},
		{ "Ga-nat the Greedy",		15000,	200, 116,  6,  9, RACE_GNOME},
		{ "Vella the Slender",		15000,	220, 111,  4,  9, RACE_HUMAN},
	},
	{
		/* Magic Shop */
		{ "Ariel the Sorceress",	20000,	200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",		20000,	215, 113,  6, 10, RACE_GNOME},
		{ "Inglorian the Mage",		30000,	200, 110,  7, 10, RACE_HUMAN},
		{ "Luthien Starshine",		30000,	175, 110,  5, 11, RACE_HIGH_ELF},
	},

	/* The high greed factors of Black marketeers are deliberate, as the 
	 * hack that made the BM expensive has been removed. -LM-
	 */
	{
		/* Black Market */
		{ "Lo-Hak the Awful",		20000,	450, 300, 10,  5, RACE_HALF_TROLL},
		{ "Histor the Goblin",		20000,	450, 300, 10,  5, RACE_HALF_ORC},
		{ "Durwin the Shifty",		30000,	450, 310, 10,  5, RACE_HUMAN},
		{ "Drago the Fair",		30000,	450, 310, 10,  5, RACE_ELF},
	},
	{
		/* Home */
		{ "Your home",				0,      100, 100,  0, 99, 99},
		{ "Your home",				0,      100, 100,  0, 99, 99},
		{ "Your home",				0,      100, 100,  0, 99, 99},
		{ "Your home",				0,      100, 100,  0, 99, 99},
	},
	{
		/* Bookseller */
		{ "Nastra the Dusty",		10000,	120, 105, 6,  7, RACE_HALF_ELF},
		{ "Gabberam the Sage",		20000,	190, 130, 5,  8, RACE_GNOME},
		{ "Bilbo the Tome-master",	25000,	150, 115, 3, 12, RACE_HOBBIT},
		{ "Hastiel the Encyclopedist",30000,	160, 120, 5,  7, RACE_HIGH_ELF}
	}
};


/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};







/*
 * Base experience levels, may be adjusted up for race and/or class
 */
s32b player_exp[PY_MAX_LEVEL] =
{
	10,
	25,
	45,
	70,
	100,
	140,
	200,
	280,
	380,
	500,
	650,
	850,
	1100,
	1400,
	1800,
	2300,
	2900,
	3600,
	4400,
	5400,
	7000,
	9000,
	11500,
	15000,
	20000,
	28000,
	37500L,
	55000L,
	75000L,
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,
	450000L,
	550000L,
	700000L,
	850000L,
	1000000L,
	1250000L,
	1500000L,
	1800000L,
	2100000L,
	2400000L,
	2700000L,
	3000000L,
	3500000L,
	4000000L,
	4500000L,
	5000000L
};


/*
 * Player Sexes
 *
 *	Title,
 *	Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
		"Female",
		"Queen"
	},

	{
		"Male",
		"King"
	}
};


/*
 * Player Races
 *
 *	Title,
 *	{STR,INT,WIS,DEX,CON,CHR},
 *	r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *	hitdie, exp base,
 *	Age (Base, Mod),
 *	Male (Hgt, Wgt),
 *	Female (Hgt, Wgt)
 *	infra,
 *	class-choices
 */
player_race race_info[MAX_RACES] =
{
	{
		"Human",
		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		14,  6,
		72,  6, 180, 25,
		66,  4, 150, 20,
		0,
		0x3F
	},

	{
		"Half-Elf",
		{ -1,  1,  0,  1, -1,  1 },
		2,  3,  3,  1, 6,  11, -2,  3,
		9,  110,
		24, 16,
		66,  6, 130, 15,
		62,  6, 100, 10,
		2,
		0x3F
	},

	{
		"Elf",
		{ -1,  2,  1,  1, -2,  1 },
		5,  8,  8,  3, 8,  12, -5, 4,
		8,  125,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		3,
		0x1F
	},

	{
		"Hobbit",
		{ -2,  2,  1,  3,  2,  1 },
		15, 18, 18, 3, 12,  15, -8, 7,
		7,  110,
		21, 12,
		36,  3, 60,  3,
		33,  3, 50,  3,
		4,
		0x0B
	},

	{
		"Gnome",
		{ -1,  2,  0,  2,  1, -2 },
		10, 12, 12,  3, 6,  13, -6, 5,
		8,  125,
		50, 40,
		42,  3, 90,  6,
		39,  3, 75,  3,
		4,
		0x0F
	},

	{
		"Dwarf",
		{  2, -3,  2, -2,  2, -3 },
		-3,  3,  12,  -1,  0,  10, 6,  0,
		11,  130,
		35, 15,
		48,  3, 150, 10,
		46,  3, 120, 10,
		5,
		0x05
	},

	{
		"Half-Orc",
		{  2, -1,  0,  0,  1, -4 },
		-3, -3, -3,  -1,  0, 7, 4, -2,
		10,  110,
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		0x0D
	},

	{
		"Half-Troll",
		{ 4, -4, -2, -4,  3, -6 },
		-5, -8, -8, -2,  -1, 5, 8, -4,
		12,  110,
		20, 10,
		96, 10, 250, 50,
		84,  8, 225, 40,
		3,
		0x05
	},

	{
		"Dunadan",
		{  1,  2,  2,  2,  3,  2 },
		5,  5,  5,  1, 3, 13, 4, 4,
		10,  180,
		50, 20,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		0x3F
	},

	{
		"High-Elf",
		{  1,  3, -1,  3,  1,  5 },
		7,  15, 15,  2,  3, 14, 0, 10,
		10,  200,
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		0x1F
	}
};


/*
 * Player Classes
 *
 *	Title,
 *	{STR,INT,WIS,DEX,CON,CHR},
 *	c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *	x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *	HD, Exp
 */
player_class class_info[MAX_CLASS] =
{
	{
		"Warrior",
		{ 5, -2, -2, 2, 2, -1},
		18, 18, 18, 1,  14, 5, 25, 25,
		10, 7,  10, 0,  0,  0,  19, 15,
		9,  0
	},

	{	
/* Note that the decrease in stealth is divided by 100 in xtra1.c, so
 * a level 50 mage will have an intrinsic stealth of 0.  -LM-
 */
		"Mage",
		{-4, 3, 0, 1, -2, 1},
		14, 36, 30, 3,  16, 12, 10, 15,
		6,  13, 9, -6,  0,  0,  5, 5,
		0, 25
	},

	{
		"Priest",
		{-1, -3, 3, -1, 0, 2},
		17, 32, 32, 2,  16, 8, 16, 15,
		6,  10, 12, 0,  0,  0, 9, 5,
		2, 20
	},

		/* A high-level rogue sees and disarms *everything*. -LM- */
	{
		"Rogue",
		{ 2, 1, -2, 3, 1, -6},
		45, 32, 28, 6, 36, 28, 15, 29,
		18, 10, 10, 0,  8,  8, 13, 14,
		5, 30
	},

	{
		"Ranger",
		{ 2, 0, 1, 1, 1, 1},
		22, 32, 28, 3,  24, 16, 15, 30,
		10,  10, 10, 0,  0,  0,  12, 18,
		5, 30
	},

	{
		"Paladin",
		{ 3, -3, 1, 0, 2, 2},
		14, 16, 25, 1,  12, 2, 19, 15,
		6,  6,  11, 0,  0,  0, 15, 4,
		7, 35
	},

	{
		"Druid",
		{ -2, -2, 3, 2, 0, 1},
		22, 26, 30, 4,  24, 16, 12, 21,
		8,  9, 12, 0,  0,  0,  6, 7,
		0, 20
	},

	{
		"Necromancer",
		{ -3, 3, -3, -1, 0, -2},
		14, 32, 25, 2,  14, 6,  10, 15,
		6,  10, 8,  0,  0,  0,  5, 5,
		0, 25
	},

	{
		"Assassin",
		{ 2, 1, -3, 2, 0, -2},
		35, 26, 20, 5, 30, 22, 17, 29,
		14, 10, 8,  0,  2,  2, 14, 14,
		4, 30
	}
};



/*
 * Hack -- the spell information table.
 *
 *   Class Name
 *
 *   Spell Book
 *   Spell Xtra
 *
 *   Spell Stat,
 *   Spell Realm,
 *
 *   Spell Level,
 *   Spell Encumbrance,
 *
 *   Array of { Lev, Mana, Fail, Exp/Lev }
 */
player_magic magic_info[MAX_CLASS] =
{
	{
		/*** Warrior ***/

		0,
		0,

		A_STR,
		0,

		99,
		0,

		{
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Mage ***/

		TV_MAGIC_BOOK,
		0,

		A_INT,
		1,

		1,
		250,

		{
			{  1,  1, 22,   4},
			{  1,  1, 23,   4},
			{  2,  1, 24,   4},
			{  3,  2, 25,   4},
			{  3,  1, 25,   4},
			{  4,  2, 25,   4},
			{  5,  3, 25,   4},
			{  5,  3, 25,   4},
			{  6,  3, 27,   5},

			{  7,  3, 30,   5},
			{  7,  3, 30,   6},
			{  9,  3, 30,   6},
			{  9,  3, 30,   6},
			{ 11,  6, 35,   6},
			{ 11,  5, 35,   6},
			{ 12,  6, 30,   7},
			{ 13,  5, 40,   9},
			{ 13,  5, 44,   7},

			{ 14,  8, 45,   7},
			{ 15,  7, 45,   7},
			{ 15,  7, 45,   7},
			{ 17, 12, 75,   8},
			{ 17,  7, 50,   8},
			{ 19,  7, 50,   8},
			{ 19,  7, 50,   8},
			{ 21, 12, 65,   8},

			{ 22, 12, 75,   9},
			{ 23, 10, 75,  11},
			{ 25, 10, 60,   9},
			{ 25, 12, 65,  11},
			{ 29, 16, 65,  12},
			{ 37, 30, 80,  15},
			{ 43, 35, 70,  26},

			{ 12,  4, 20,  16},
			{ 16,  8, 40,  20},
			{ 20, 11, 60,  20},
			{ 25, 15, 60,  25},
			{ 43, 20, 55,  75},

			{ 16,  6, 55,  20},
			{ 21, 10, 65,  17},
			{ 27, 15, 70,  22},
			{ 33, 23, 70,  35},
			{ 39, 33, 70,  60},
			{ 46, 42, 60, 120},

			{ 5,   2, 50,  10},
			{ 15,  6, 70,  12},
			{ 25, 10, 85,  20},
			{ 37, 24, 70,  55},
			{ 45, 70, 75, 100},

			{ 21,  5, 50,  20},
			{ 21,  5, 50,  20},
			{ 21,  5, 50,  20},
			{ 27, 11, 75,  30},
			{ 35, 22, 85,  50},

			{ 18,  0, 50,  22},
			{ 30,  8, 75,  30},
			{ 30, 10, 95,  50},
			{ 38, 18, 50,  55},
			{ 44, 24, 75,  90},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Priest ***/

		TV_PRAYER_BOOK,
		0,

		A_WIS,
		2,

		1,
		350,

		{
			{  1,  1, 10,   4},
			{  1,  1, 15,   4},
			{  3,  2, 20,   4},
			{  3,  2, 25,   4},
			{  3,  2, 25,   4},
			{  5,  4, 25,   4},
			{  5,  4, 25,   4},
			{  6,  1, 30,   4},

			{  7,  4, 28,   4},
			{  7,  2, 29,   4},
			{  8,  5, 32,   4},
			{  9,  4, 34,   5},
			{  9,  4, 36,   5},
			{ 11,  4, 38,   5},
			{ 13,  5, 38,   5},
			{ 13,  6, 38,   5},

			{ 14,  6, 38,   5},
			{ 15,  7, 38,   6},
			{ 15,  7, 40,   6},
			{ 17,  7, 42,   6},
			{ 17,  8, 42,   7},
			{ 19,  8, 55,   7},
			{ 19,  9, 45,   7},
			{ 21,  9, 45,   7},
			{ 21,  9, 50,   8},

			{ 23, 11, 50,   8},
			{ 25, 16, 60,  11},
			{ 27, 18, 70,  15},
			{ 32, 22, 75,  20},
			{ 37, 40, 90,  29},
			{ 40, 40, 90,  35},

			{  2,  2, 50,  12},
			{ 10,  8, 80,  16},
			{ 23, 20, 80,  20},
			{ 28, 20, 80,  40},
			{ 38, 50, 80,  70},

			{ 36, 30, 50,  65},
			{ 38, 40, 60,  70},
			{ 38, 50, 80,  70},
			{ 40, 60, 90,  90},
			{ 40, 60, 90,  90},

			{ 17, 14, 70,  25},
			{ 21, 16, 75,  30},
			{ 29, 25, 80,  40},
			{ 40, 30, 80,  65},
			{ 48, 40, 70, 150},

			{  5,  2, 40,  20},
			{ 15, 30, 80,  25},
			{ 25, 30, 80,  40},
			{ 31, 18, 70,  55},
			{ 35, 40, 80,  70},
			{ 37, 40, 85,  80},

			{  3,  2, 50,  15},
			{ 10,  7, 50,  20},
			{ 20, 20, 80,  25},
			{ 30, 40, 75,  40},
			{ 35, 50, 75,  65},
			{ 40, 50, 75,  90},

			{ 99,  0,  0,    0},
			{ 99,  0,  0,    0},
			{ 99,  0,  0,    0},
			{ 99,  0,  0,    0},
			{ 99,  0,  0,    0},
			{ 99,  0,  0,    0}
		}
	},

	{
		/*** Rogue ***/

		TV_MAGIC_BOOK,
		0,

		A_INT,
		1,

		5,
		300,

		{
			{ 99,  0,  0,   0},
			{  5,  1, 50,   1},
			{  6,  1, 55,   1},
			{  7,  2, 60,   1},
			{  7,  1, 60,   1},
			{  9,  2, 65,   1},
			{  9,  1, 65,   1},
			{ 10,  1, 70,   2},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 13,  3, 40,   2},
			{ 15,  5, 70,   2},
			{ 17,  5, 70,   2},
			{ 19,  4, 50,   2},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 21,  8, 70,   2},
			{ 23,  4, 20,   2},
			{ 25,  7, 50,   3},
			{ 25,  7, 50,   3},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 27,  7, 70,   3},
			{ 29, 10, 90,   3},

			{ 99,  0,  0,   0},
			{ 29,  9, 85,   3},
			{ 31, 13, 85,   3},
			{ 33, 18, 70,   4},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 24,  7, 20,   6},
			{ 30,  8, 40,   6},
			{ 34, 11, 60,   6},
			{ 40, 15, 60,  10},
			{ 48, 24, 40,  25},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 26,  3, 50,   8},
			{ 36,  8, 70,  14},
			{ 45, 14, 80,  25},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 24,  7, 50,  15},
			{ 24,  7, 50,  15},
			{ 24,  7, 50,  15},
			{ 24, 11, 50,  20},
			{ 40, 24, 75,  30},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Ranger ***/

		TV_DRUID_BOOK,
		0,

		A_WIS,
		3,

		3,
		300,

		{
			{  3,  1, 30,   1},
			{  3,  2, 35,   1},
			{  3,  1, 35,   1},
			{  5,  6, 99,   1},
			{  5,  2, 35,   1},
			{ 99,  0,  0,   0},
			{  7,  2, 30,   1},
			{ 99,  0,  0,   0},
			{  7,  3, 40,   2},

			{  7,  5, 40,   2},
			{  9,  5, 45,   3},
			{  9,  5, 45,   3},
			{ 11,  4, 40,   3},
			{ 13,  6, 45,   3},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 15,  9, 80,   4},
			{ 15, 13, 55,   4},

			{ 99,  0,  0,   0},
			{ 17, 13, 99,   4},
			{ 99,  0,  0,   0},
			{ 21,  6, 60,   4},
			{ 23, 10, 90,   5},
			{ 23,  7, 60,   5},
			{ 25,  7, 60,   6},
			{ 99,  0,  0,   0},

			{ 27,  8, 65,   8},
			{ 29, 14, 95,   9},
			{ 33, 12, 70,  11},
			{ 35, 15, 75,  13},
			{ 41, 45, 75,  16},
			{ 43, 20, 65,  20},
			{ 43, 22, 65,  20},

			{ 22,  1, 25,  15},
			{ 27, 10, 40,  20},
			{ 29,  5, 60,  26},
			{ 37,  5, 65,  35},
			{ 45, 20, 70,  45},

			{ 21,  6, 50,  20},
			{ 26, 12, 60,  20},
			{ 31, 18, 70,  25},
			{ 99,  0,  0,   0},
			{ 39, 18, 85,  35},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 25, 10, 40,  20},
			{ 30, 10, 55,  20},
			{ 35, 20, 60,  35},
			{ 99,  0,  0,   0},
			{ 48, 60, 60,  55},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Paladin ***/

		TV_PRAYER_BOOK,
		0,

		A_WIS,
		2,

		3,
		400,

		{
			{  3,  1, 30,   1},
			{  3,  1, 35,   1},
			{  4,  2, 35,   1},
			{  5,  1, 35,   1},
			{  7,  3, 35,   3},
			{  7,  5, 70,   3},
			{  9,  5, 70,   2},
			{  9,  2, 40,   2},

			{ 11,  4, 40,   2},
			{ 11,  5, 40,   2},
			{ 13,  5, 50,   2},
			{ 13,  4, 45,   2},
			{ 99,  0,  0,   0},
			{ 15,  8, 45,   3},
			{ 15, 12, 45,   3},
			{ 17, 12, 45,   3},

			{ 17, 10, 50,   3},
			{ 99,  0,  0,   0},
			{ 19, 10, 50,   4},
			{ 21, 11, 50,   4},
			{ 21, 11, 50,   4},
			{ 99,  0,  0,   0},
			{ 25, 10, 50,   5},
			{ 27,  8, 50,   6},
			{ 29,  8, 50,   7},

			{ 31, 11, 50,   9},
			{ 35, 16, 60,  12},
			{ 37, 20, 70,  15},
			{ 43, 22, 80,  21},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{  4,  2, 50,  10},
			{ 15,  8, 80,  16},
			{ 26,  5, 80,  20},
			{ 36, 20, 80,  25},
			{ 42, 55, 80,  30},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 23, 14, 70,  20},
			{ 30, 16, 75,  30},
			{ 39, 35, 80,  40},
			{ 46, 25, 80,  80},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 12,  3, 50,  12},
			{ 20,  8, 50,  20},
			{ 25, 25, 80,  25},
			{ 33, 18, 70,  28},
			{ 35, 30, 75,  35},
			{ 40, 40, 75,  42},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Druid ***/

		TV_DRUID_BOOK,
		0,

		A_WIS,
		3,

		1,
		250,

		{
			{  1,  1, 22,   4},
			{  1,  1, 23,   4},
			{  2,  1, 24,   4},
			{  3,  2, 25,   4},
			{  3,  1, 25,   4},
			{  4,  2, 25,   4},
			{  5,  3, 45,   4},
			{  5,  3, 25,   4},
			{  6,  4, 27,   5},

			{  7,  4, 30,   5},
			{  7,  5, 30,   5},
			{  9,  5, 30,   6},
			{  9,  5, 30,   6},
			{ 11,  6, 35,   6},
			{ 11,  6, 35,   6},
			{ 13,  7, 30,   6},
			{ 99,  0,  0,   0},
			{ 13,  9, 44,   7},

			{ 15,  8, 45,   7},
			{ 15,  8, 75,   8},
			{ 17, 10, 45,   8},
			{ 17,  5, 45,   8},
			{ 19,  8, 75,   8},
			{ 19,  7, 50,   8},
			{ 21, 14, 50,   8},
			{ 21,  1, 50,   8},

			{ 22,  9, 55,   9},
			{ 23, 14, 90,  11},
			{ 23, 12, 60,   9},
			{ 25, 20, 85,  11},
			{ 29, 50, 65,  12},
			{ 33, 20, 80,  15},
			{ 37, 22, 80,  26},

			{ 20,  2, 20,  16},
			{ 24,  8, 40,  20},
			{ 20, 10, 60,  20},
			{ 25, 16, 60,  25},
			{ 39, 28, 60,  60},

			{ 21,  9, 50,  20},
			{ 25, 18, 60,  17},
			{ 25, 16, 70,  22},
			{ 34, 25, 70,  27},
			{ 39, 28, 70,  40},
			{ 49, 40, 60, 140},

			{ 26, 12, 50,  40},
			{ 35, 15, 70,  50},
			{ 38, 20, 85,  60},
			{ 40, 22, 60,  70},
			{ 45, 26, 60,  80},

			{ 15,  4, 50,  15},
			{ 15,  7, 50,  15},
			{ 18,  9, 50,  20},
			{ 20, 16, 75,  25},
			{ 25, 20, 85,  32},

			{ 18,  9, 20,  35},
			{ 30,  9, 35,  50},
			{ 30, 24, 40,  50},
			{ 45, 40, 55,  80},
			{ 45, 70, 65,  80},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Necromancer ***/

		TV_NECRO_BOOK,
		0,

		A_INT,
		4,

		1,
		200,

		{
			{  1,  1, 22,   4},
			{  1,  1, 23,   4},
			{  3,  1, 24,   4},
			{  3,  2, 25,   4},
			{  4,  3, 25,   4},
			{  5,  3, 25,   4},
			{  5,  3, 25,   4},
			{  6,  3, 85,   6},

			{  7,  4, 27,   4},
			{  8,  3, 30,   4},
			{  9,  6, 30,   4},
			{  9,  3, 20,   4},
			{ 11,  5, 30,   4},
			{ 11,  4, 35,   5},
			{ 12,  6, 45,   5},
			{ 13,  7, 50,   5},

			{ 14,  5, 40,   6},
			{ 15,  5, 75,   7},
			{ 17,  8, 75,   6},
			{ 17,  8, 75,   6},
			{ 17,  7, 45,   6},
			{ 19,  8, 45,   7},
			{ 19,  5, 50,   7},
			{ 21,  7, 50,   7},
			{ 21,  6, 50,   8},

			{ 23, 11, 50,   8},
			{ 23, 11, 55,   9},
			{ 24, 11, 60,  10},
			{ 25, 17, 60,  11},
			{ 29, 22, 65,  13},
			{ 37, 21, 70,  20},

			{ 19, 10, 40,  21},
			{ 19, 15, 40,  28},
			{ 23, 18, 80,  30},
			{ 27, 18, 50,  40},
			{ 99,  0,  0,   0},

			{ 31, 12, 75,  30},
			{ 36, 15, 50,  35},
			{ 38, 25, 60,  40},
			{ 43, 25, 70,  75},
			{ 46, 36, 70, 120},

			{ 31, 24, 45,  30},
			{ 36, 30, 50,  35},
			{ 38, 32, 60,  40},
			{ 43, 50, 70,  75},
			{ 47, 40, 70, 120},

			{ 18,  9, 40,  20},
			{ 32, 12, 50,  35},
			{ 34, 12, 50,  40},
			{ 40, 16, 50,  60},
			{ 40, 22, 50,  60},
			{ 44, 40, 70,  90},

			{ 25, 12, 45,  25},
			{ 30, 12, 60,  30},
			{ 36, 12, 60,  40},
			{ 38, 12, 60,  60},
			{ 43, 20, 70,  90},
			{ 47, 35, 70, 140},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},


	{
		/*** Assassin ***/

		TV_NECRO_BOOK,
		0,

		A_INT,
		4,

		5,
		300,

		{
			{  5,  1, 75,   1},
			{  5,  1, 23,   1},
			{  5,  1, 24,   1},
			{  7,  3, 25,   2},
			{  7,  4, 25,   2},
			{  7,  4, 25,   2},
			{  9,  5, 25,   2},
			{ 11,  9, 99,   4},

			{ 11,  2, 20,   2},
			{ 99,  0,  0,   0},
			{ 13,  6, 30,   3},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 15,  3, 35,   3},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 19,  3, 40,   4},
			{ 19,  3, 65,   4},
			{ 21,  2, 45,   5},
			{ 21,  2, 45,   5},
			{ 23,  7, 45,   6},
			{ 25,  8, 45,   7},
			{ 25,  3, 50,   7},
			{ 27,  7, 50,   8},
			{ 29,  6, 50,  10},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 13,  8, 35,  14},
			{ 19,  8, 40,  17},
			{ 27, 18, 70,  20},
			{ 33, 11, 50,  28},
			{ 33,  6, 70,  45},

			{ 13,  4, 45,  16},
			{ 39, 15, 50,  30},
			{ 42, 25, 60,  40},
			{ 46, 25, 65,  55},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 16,  6, 40,  18},
			{ 34, 16, 50,  35},
			{ 99,  0,  0,   0},
			{ 44, 18, 50,  60},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 30,  8, 35,  25},
			{ 33,  8, 40,  30},
			{ 99,  0,  0,   0},
			{ 41, 12, 45,  42},
			{ 45, 20, 60,  60},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	}
};


/*
 * Spells in each book (mage spells then priest spells)
 */
u32b spell_flags[MAX_REALM][9][2] =
{
	{
		/*** Mage spell books ***/
		{ 0x000001ff, 0x00000000 },
		{ 0x0003fe00, 0x00000000 },
		{ 0x03fc0000, 0x00000000 },
		{ 0xfc000000, 0x00000001 },
		{ 0x00000000, 0x003e0000 },
		{ 0x00000000, 0x0000003e },
		{ 0x00000000, 0x0001f000 },
		{ 0x00000000, 0x07c00000 },
		{ 0x00000000, 0x00000fc0 }
	},

	{
		/*** Priest spell books ***/
		{ 0x000000ff, 0x00000000 },
		{ 0x0000ff00, 0x00000000 },
		{ 0x01ff0000, 0x00000000 },
		{ 0x7e000000, 0x00000000 },
		{ 0x00000000, 0x03f00000 },
		{ 0x80000000, 0x0000000f },
		{ 0x00000000, 0x000001f0 },
		{ 0x00000000, 0x000fc000 },
		{ 0x00000000, 0x00003e00 }
	},

	{
		/*** Druid spell books ***/
		{ 0x000001ff, 0x00000000 },
		{ 0x0003fe00, 0x00000000 },
		{ 0x03fc0000, 0x00000000 },
		{ 0xfc000000, 0x00000001 },
		{ 0x00000000, 0x003e0000 },
		{ 0x00000000, 0x0000003e },
		{ 0x00000000, 0x0001f000 },
		{ 0x00000000, 0x07c00000 },
		{ 0x00000000, 0x00000fc0 }
	},

	{
		/*** Necromancer spell books ***/
		{ 0x000000ff, 0x00000000 },
		{ 0x0000ff00, 0x00000000 },
		{ 0x01ff0000, 0x00000000 },
		{ 0x7e000000, 0x00000000 },
		{ 0x00000000, 0x03f00000 },
		{ 0x80000000, 0x0000000f },
		{ 0x00000000, 0x000001f0 },
		{ 0x00000000, 0x000fc000 },
		{ 0x00000000, 0x00003e00 }
	}
};


/*
 * Names of the spells (mage spells, priestly prayers, Nature magics,
 * and Necromantic spells) -LM-
 */
cptr spell_names[MAX_REALM][64] =
{
	/*** Mage Spells ***/

	{
		/* Magic for Beginners (sval 0) */
		"Magic Missile",
		"Detect Monsters",
		"Phase Door",
		"Light Area",
		"Combat Poison",
		"Cure Light Wounds",
		"Find Hidden Traps",
		"Find Hidden Doors/Stairs",
		"Stinking Cloud",

		/* Conjurings and Tricks (sval 1) */
		"Confuse Monster",
		"Lightning Bolt",
		"Door Destruction",
		"Sleep I",
		"Cure Poison",
		"Teleport Self",
		"Spear of Light",
		"Recharge Item I",
		"Frost Bolt",

		/* Incantations and Illusions (sval 2) */
		"Satisfy Hunger",
		"Magic Disarm",
		"Polymorph Other",
		"Identify",
		"Sleep III",
		"Fire Bolt",
		"Slow Monster",
		"Turn Stone to Mud",

		/* Sorcery and Evocations (sval 3) */
		"Frost Ball",
		"Recharge Item II",
		"Teleport Other",
		"Haste Self",
		"Fire Ball",
		"Word of Destruction",
		"Genocide",

		/* Mordenkainen's Escapes (sval 5) */
		"Door Creation",
		"Stair Creation",
		"Teleport Level",
		"Word of Recall",
		"Dimension Door",

		/* Raal's Tome of Destruction (sval 8) */
		"Acid Bolt",
		"Cloud Kill",
		"Acid Ball",
		"Ice Storm",
		"Meteor Swarm",
		"Mana Storm",

		/* Kelek's Grimoire of Power (sval 6) */
		"Detect Evil",
		"Detect Enchantment",
		"Earthquake",
		"Starburst",
		"Mass Genocide",

		/* Resistance of Scarabtarices (sval 4) */
		"Resist Fire",
		"Resist Cold",
		"Resist Acid",
		"Resist Poison",
		"Resistance",

		/* Tenser's transformations... (sval 7) */
		"Clear Mind",
		"Shield",
		"Recharge Item III",
		"Essence of Speed",
		"Strengthen Defenses",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	},


	/*** Priest Spells ***/

	{
		/* Novice's Handbook (sval 0) */
		"Detect Evil",
		"Bind Door",
		"Bless",
		"Remove Fear",
		"Call Light",
		"Find Traps",
		"Detect Doors/Stairs",
		"Slow Poison",

		/* Words of Wisdom (sval 1) */
		"Cure Serious Wounds",
		"Scare Monster",
		"Portal",
		"Chant",
		"Sanctuary",
		"Satisfy Hunger",
		"Remove Curse",
		"Resist Heat and Cold",

		/* Chants and Blessings (sval 2) */
		"Neutralize Poison",
		"Orb of Draining",
		"Sense Invisible",
		"Protection from Evil",
		"Cure Mortal Wounds",
		"Earthquake",
		"Sense Surroundings",
		"Turn Undead",
		"Prayer",

		/* Exorcism and Dispelling (sval 3) */
		"Dispel Undead",
		"Heal",
		"Dispel Evil",
		"Sacred Shield",
		"Glyph of Warding",
		"Holy Word",

		/* Godly Insights... (sval 5) */
		"Detect Monsters",
		"Detection",
		"Probing",
		"Perception",
		"Clairvoyance",

		/* Purifications and Healing (sval 6) */
		"Banishment",
		"Healing",
		"Sacred Knowledge",
		"Restoration",
		"Remembrance",

		/* Wrath of God (sval 8) */
		"Ball of Light",
		"Holy Lance",
		"Word of Destruction",
		"Annihilation",
		"Call on Varda",

		/* Holy Infusions (sval 7) */
		"Unbarring Ways",
		"Recharging",
		"Dispel Curse",
		"Disarm Trap",
		"Enchant Weapon",
		"Enchant Armour",

		/* Ethereal openings (sval 4) */
		"Blink",
		"Teleport Self",
		"Teleport Other",
		"Teleport Level",
		"Word of Recall",
		"Alter Reality",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	},

	/*** Druid Spells ***/

	{
		/* Call of the Wild (sval 0) */
		"Detect Life",
		"Call Light",
		"Foraging",
		"Blink",
		"Combat Poison",
		"Lightning Bolt",
		"Door Destruction",
		"Turn Stone to Mud",
		"Ray of Sunlight",

		/* Communion with Nature (sval 1) */
		"Cure Poison",
		"Sleep Creature",
		"Frighten Creature",
		"Detect Traps/Doors",
		"Cease Small Life",
		"Frost Bolt",
		"Fire Bolt",
		"Heroism",
		"Remove Curse",

		/* Gifts of Nature (sval 2) */
		"Acid Bolt",
		"Teleport Monster",
		"Poison Bolt",
		"Resist Poison",
		"Earthquake",
		"Resist Fire & Cold",
		"Detect All",
		"Natural Vitality",

		/* Book of Combat (sval 3) */
		"Resist Acid & Lightning",
		"Wither Foe",
		"Disarm Trap",
		"Identify",
		"Create Athelas",
		"Raging Storm",
		"Thunderclap",

		/* Melian's Lore (sval 5) */
		"Detect Evil",
		"Song of Frightening",
		"Sense Surroundings",
		"Sight beyond Sight",
		"Herbal Healing",

		/* Spirit of Yavanna (sval 8) */
		"Time Blast",
		"Essence of Speed",
		"Genocide",
		"Become Ent",
		"Regain Life",
		"Intervention of Yavanna",

		/* Primal Forces (sval 6) */
		"Bizzard",
		"Trigger Tsunami",
		"Volcanic Eruption",
		"Molten Lightning",
		"Starburst",

		/* Radagast's Shapeshifts (sval 4) */
		"Become Mouse",
		"Become Ferret",
		"Become Hound",
		"Become Gazelle",
		"Become Lion",

		/* Bombadil's Songs (sval 7) */
		"Song of Lulling",
		"Song of Protection",
		"Song of Dispelling",
		"Song of Warding",
		"Song of Renewal",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	},


	/*** Necromantic Spells ***/

	{
		/* Beginner's Curses (sval 0) */
		"Magic Bolt",
		"Detect Evil",
		"Enhanced Infravision",
		"Break Curse",
		"Slow Monster",
		"Sleep Monster",
		"Horrify",
		"Become Bat",

		/* Dark Initiation (sval 1) */
		"Door Destruction",
		"Dark Bolt",
		"Noxious Fumes",
		"Turn Undead",
		"Turn Evil",
		"Cure Poison",
		"Dispel Undead",
		"Dispel Evil",

		/* Blood Novitiate (sval 2) */
		"See Invisible",
		"Shadow Shifting",
		"Detect Traps",
		"Detect Doors/Stairs",
		"Sleep Monsters",
		"Slow Monsters",
		"Detect Magic",
		"Death Bolt",
		"Resist Poison",

		/* Frightful Realms (sval 3) */
		"Exorcise Demons",
		"Dark Spear",
		"Mana Bolt",
		"Genocide",
		"Dark Ball",
		"Stench of Death",	

		/* Mysteries of Angmar (sval 5) */
		"Probing",
		"Shadow Mapping",
		"Identify",
		"Shadow Warping",
		"Poison Ammo",

		/* Life Force Mastery (sval 6) */
		"Detect All Monsters",
		"Strike at Life",
		"Orb of Death",
		"Dispel Life",
		"Vampiric Drain",

		/* Necronomicon(sval 8) */
		"Word of Destruction",
		"Teleport Other",
		"Smash Undead",
		"Mass Genocide",
		"Darkness Storm",

		/* Metamorphoses(sval 7) */
		"Recharging",
		"Become Werewolf",
		"Dispel Curse",
		"Become Vampire",
		"Haste Self",
		"Prepare Black Breath",

		/* Unholy Protection (sval 4) */
		"Resist Acid and Cold",
		"Cure Any Wound",
		"Protection From Evil",
		"Black Blessing",
		"Banish Evil",
		"Shadow Barrier",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	}
};



/*
 * Each chest has a certain set of traps, determined by pval (which 
 * also controls the quality of treasure).
 * Table revised for Oangband.
 */
byte chest_traps[100] =
{
	0,					/* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	0,
	(CHEST_POISON),
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),			/* 15 == best small wooden */
	0,
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),			/* 25 == best large wooden */
	0,
	(CHEST_POISON | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),	/* 35 == best small iron */
	0,
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),	/* 45 == best large iron */
	0,
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),	/* 65 == best small steel */
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),	/* 75 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),	/* 95 == best large jeweled */
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_PARALYZE),
};


/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 */
cptr player_title[MAX_CLASS][PY_MAX_LEVEL/5] =
{
	/* Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Mage */
	{
		"Novice",
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Mage Lord",
	},

	/* Priest */
	{
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Lama",
		"Patriarch",
		"Priest",
		"High Priest",
		"Priest Lord",
	},

	/* Rogue */
	{
		"Vagabond",
		"Cutpurse",
		"Robber",
		"Burglar",
		"Filcher",
		"Sharper",
		"Low Thief",
		"High Thief",
		"Master Thief",
		"Guildmaster",
	},

	/* Ranger */
	{
		"Runner",
		"Strider",
		"Scout",
		"Courser",
		"Tracker",
		"Guide",
		"Pathfinder",
		"Low Ranger",
		"High Ranger",
		"Ranger Lord",
	},

	/* Paladin */
	{
		"Gallant",
		"Keeper",
		"Protector",
		"Defender",
		"Warder",
		"Knight",
		"Guardian",
		"Low Paladin",
		"High Paladin",
		"Paladin Lord",
	},

	/* Druid */
	{
		"Wanderer",
		"Tamer",
		"Nurturer",
		"Gardener",
		"Creator",
		"Earth Warder",
		"Windrider",
		"Stormwielder",
		"High Mystic",
		"Mystic Lord",
	},

	/* Necromancer */
	{
		"Acolyte",
		"Curser",
		"Dark Student",
		"Initiate",
		"Slavemaster",
		"Summoner",
		"Controller",
		"Commander",
		"Dark Master",
		"Night Lord",
	},
	/* Assassin */
	{
		"Trainee",
		"Myrmidon",
		"Initiate",
		"Knifer",
		"Bladesman",
		"Hashishin",
		"Black Dagger",
		"Shadowstrike",
		"Assassinator",
		"Death Lord",
	}

};



/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[6] =
{
	"STR: ", "INT: ", "WIS: ", "DEX: ", "CON: ", "CHR: "
};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[6] =
{
	"Str: ", "Int: ", "Wis: ", "Dex: ", "Con: ", "Chr: "
};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 */
cptr window_flag_desc[32] =
{
	"Display inven/equip",
	"Display equip/inven",
	"Display player (basic)",
	"Display player (extra)",
	NULL,
	NULL,
	"Display messages",
	"Display overhead view",
	"Display monster recall",
	"Display object recall",
	NULL,
	"Display snap-shot",
	NULL,
	NULL,
	"Display borg messages",
	"Display borg status",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Options -- textual names (where defined)
 */
cptr option_text[OPT_MAX] =
{
	"rogue_like_commands",		/* OPT_rogue_like_commands */
	"quick_messages",			/* OPT_quick_messages */
	"floor_query_flag",			/* OPT_floor_query_flag */
	"carry_query_flag",			/* OPT_carry_query_flag */
	"use_old_target",			/* OPT_use_old_target */
	"always_pickup",			/* OPT_always_pickup */
	"always_repeat",			/* OPT_always_repeat */
	"depth_in_feet",			/* OPT_depth_in_feet */
	"stack_force_notes",		/* OPT_stack_force_notes */
	"stack_force_costs",		/* OPT_stack_force_costs */
	"show_labels",				/* OPT_show_labels */
	"show_weights",				/* OPT_show_weights */
	"show_choices",				/* OPT_show_choices */
	"show_details",				/* OPT_show_details */
	"ring_bell",				/* OPT_ring_bell */
	"show_flavors",				/* OPT_flavors */
	"run_ignore_stairs",		/* OPT_run_ignore_stairs */
	"run_ignore_doors",			/* OPT_run_ignore_doors */
	"run_cut_corners",			/* OPT_run_cut_corners */
	"run_use_corners",			/* OPT_run_use_corners */
	"disturb_move",				/* OPT_disturb_move */
	"disturb_near",				/* OPT_disturb_near */
	"disturb_panel",			/* OPT_disturb_panel */
	"disturb_state",			/* OPT_disturb_state */
	"disturb_minor",			/* OPT_disturb_minor */
	"disturb_other",			/* OPT_disturb_other */
	"alert_hitpoint",			/* OPT_alert_hitpoint */
	"alert_failure",			/* OPT_alert_failure */
	"verify_destroy",			/* OPT_verify_destroy */
	"verify_special",			/* OPT_verify_special */
	"allow_quantity",			/* OPT_allow_quantity */
#ifdef ALLOW_EASY_OPEN /* TNB */
	"easy_open",   /* OPT_easy_open */
#else
	NULL,                                           /* xxx */
#endif /* ALLOW_EASY_OPEN */
	"auto_haggle",				/* OPT_auto_haggle */
	"auto_scum",				/* OPT_auto_scum */
	"testing_stack",			/* OPT_testing_stack */
	"testing_carry",			/* OPT_testing_carry */
	"expand_look",				/* OPT_expand_look */
	"expand_list",				/* OPT_expand_list */
	"view_perma_grids",			/* OPT_view_perma_grids */
	"view_torch_grids",			/* OPT_view_torch_grids */
	"dungeon_align",			/* OPT_dungeon_align */
	"dungeon_stair",			/* OPT_dungeon_stair */
	"flow_by_sound",			/* OPT_flow_by_sound */
	"flow_by_smell",			/* OPT_flow_by_smell */
#ifdef ALLOW_EASY_DISARM /* TNB */
	"easy_disarm",			/* OPT_easy_disarm */
#else
	NULL,					/* xxx track_follow */
#endif /* ALLOW_EASY_DISARM */
	NULL,						/* xxx track_target */
	"smart_learn",				/* OPT_smart_learn */
	"smart_cheat",				/* OPT_smart_cheat */
	"view_reduce_lite",			/* OPT_view_reduce_lite */
	"hidden_player",			/* OPT_hidden_player */
	"avoid_abort",				/* OPT_avoid_abort */
	"avoid_other",				/* OPT_avoid_other */
	"flush_failure",			/* OPT_flush_failure */
	"flush_disturb",			/* OPT_flush_disturb */
	NULL,						/* xxx flush_command */
	"fresh_before",				/* OPT_fresh_before */
	"fresh_after",				/* OPT_fresh_after */
	"allow arena levels",			/* OPT_empty_levels */
	"compress_savefile",		/* OPT_compress_savefile */
	"hilite_player",			/* OPT_hilite_player */
	"view_yellow_lite",			/* OPT_view_yellow_lite */
	"view_bright_lite",			/* OPT_view_bright_lite */
	"view_granite_lite",		/* OPT_view_granite_lite */
	"view_special_lite"			/* OPT_view_special_lite */
};


/*
 * Options -- descriptions (where defined)
 */
cptr option_desc[OPT_MAX] =
{
	"Rogue-like commands",						/* OPT_rogue_like_commands */
	"Activate quick messages",					/* OPT_quick_messages */
	"Prompt for floor item selection",			/* OPT_floor_query_flag */
	"Prompt before picking things up",			/* OPT_carry_query_flag */
	"Use old target by default",				/* OPT_use_old_target */
	"Pick things up by default",				/* OPT_always_pickup */
	"Repeat obvious commands",					/* OPT_always_repeat */
	"Show dungeon level in feet",				/* OPT_depth_in_feet */
	"Merge inscriptions when stacking",			/* OPT_stack_force_notes */
	"Merge discounts when stacking",			/* OPT_stack_force_costs */
	"Show labels in equipment listings",		/* OPT_show_labels */
	"Show weights in all object listings",		/* OPT_show_weights */
	"Show choices in inven/equip windows",		/* OPT_show_choices */
	"Show details in monster descriptions",		/* OPT_show_details */
	"Audible bell (on errors, etc)",			/* OPT_ring_bell */
	"Show flavors in object descriptions",		/* OPT_show_flacors */
	"When running, ignore stairs",				/* OPT_run_ignore_stairs */
	"When running, ignore doors",				/* OPT_run_ignore_doors */
	"When running, cut corners",				/* OPT_run_cut_corners */
	"When running, use corners",				/* OPT_run_use_corners */
	"Disturb whenever any monster moves",		/* OPT_disturb_move */
	"Disturb whenever viewable monster moves",	/* OPT_disturb_near */
	"Disturb whenever map panel changes",		/* OPT_disturb_panel */
	"Disturb whenever player state changes",	/* OPT_disturb_state */
	"Disturb whenever boring things happen",	/* OPT_disturb_minor */
	"Disturb whenever various things happen",	/* OPT_disturb_other */
	"Alert user to critical hitpoints",			/* OPT_alert_hitpoint */
	"Alert user to various failures",			/* OPT_alert_failure */
	"Verify destruction of objects",			/* OPT_verify_destroy */
	"Verify use of special commands",			/* OPT_verify_special */
	"Allow quantity specification",				/* OPT_allow_quantity */
#ifdef ALLOW_EASY_OPEN /* TNB */
	"Open and close automatically",			/* OPT_easy_open */
#else
	NULL,										/* xxx */
#endif /* ALLOW_EASY_OPEN */
	"Auto-haggle in stores",					/* OPT_auto_haggle */
	"Auto-scum for good levels",				/* OPT_auto_scum */
	"Allow objects to stack on floor",			/* OPT_testing_stack */
	"Allow monsters to carry objects",			/* OPT_testing_carry */
	"Expand the power of the look command",		/* OPT_expand_look */
	"Expand the power of the list commands",	/* OPT_expand_list */
	"Map remembers all perma-lit grids",		/* OPT_view_perma_grids */
	"Map remembers all torch-lit grids",		/* OPT_view_torch_grids */
	"Generate dungeons with aligned rooms",		/* OPT_dungeon_align */
	"Generate dungeons with connected stairs",	/* OPT_dungeon_stair */
	"Monsters chase current location (v.slow)",	/* OPT_flow_by_sound */
	"Monsters chase recent locations (v.slow)",	/* OPT_flow_by_smell */
#ifdef ALLOW_EASY_OPEN /* TNB */
	"Disarm traps automatically",   /* OPT_easy_disarm */
#else
	NULL,									/* xxx */
#endif /* ALLOW_EASY_DISARM */
	NULL,									/* xxx */
	"Monsters learn from their mistakes",		/* OPT_smart_learn */
	"Monsters exploit players weaknesses",		/* OPT_smart_cheat */
	"Reduce lite-radius when running",			/* OPT_view_reduce_lite */
	"Hide player symbol when running",			/* OPT_hidden_player */
	"Avoid checking for user abort",			/* OPT_avoid_abort */
	"Avoid processing special colors",			/* OPT_avoid_other */
	"Flush input on various failures",			/* OPT_flush_failure */
	"Flush input whenever disturbed",			/* OPT_flush_disturb */
	NULL,										/* xxx */
	"Flush output before every command",		/* OPT_fresh_before */
	"Flush output after various things",		/* OPT_fresh_after */
	"Allow empty 'Arena' levels",				/* OPT_empty_levels */
	"Compress messages in savefiles",			/* OPT_compress_savefile */
	"Hilite the player with the cursor",		/* OPT_hilite_player */
	"Use special colors for torch lite",		/* OPT_view_yellow_lite */
	"Use special colors for field of view",		/* OPT_view_bright_lite */
	"Use special colors for wall grids",		/* OPT_view_granite_lite */
	"Use special colors for floor grids"		/* OPT_view_special_lite */
};


/*
 * Options -- normal values
 */
bool option_norm[OPT_MAX] =
{
	FALSE,		/* OPT_rogue_like_commands */
	FALSE,		/* OPT_quick_messages */
	TRUE,		/* OPT_floor_query_flag */
	FALSE,		/* OPT_carry_query_flag */
	FALSE,		/* OPT_use_old_target */
	TRUE,		/* OPT_always_pickup */
	TRUE,		/* OPT_always_repeat */
	TRUE,		/* OPT_depth_in_feet */
	TRUE,		/* OPT_stack_force_notes */
	FALSE,		/* OPT_stack_force_costs */
	TRUE,		/* OPT_show_labels */
	TRUE,		/* OPT_show_weights */
	TRUE,		/* OPT_show_choices */
	TRUE,		/* OPT_show_details */
	TRUE,		/* OPT_ring_bell */
	TRUE,		/* OPT_show_flavors */
	TRUE,		/* OPT_run_ignore_stairs */
	TRUE,		/* OPT_run_ignore_doors */
	TRUE,		/* OPT_run_cut_corners */
	TRUE,		/* OPT_run_use_corners */
	TRUE,		/* OPT_disturb_move */
	TRUE,		/* OPT_disturb_near */
	TRUE,		/* OPT_disturb_panel */
	TRUE,		/* OPT_disturb_state */
	TRUE,		/* OPT_disturb_minor */
	TRUE,		/* OPT_disturb_other */
	TRUE,		/* OPT_alert_hitpoint */
	FALSE,		/* OPT_alert_failure */
	TRUE,		/* OPT_verify_destroy */
	TRUE,		/* OPT_verify_special */
	TRUE,		/* OPT_allow_quantity */
#ifdef ALLOW_EASY_OPEN /* TNB */
	TRUE, 	  /* OPT_easy_open */
#else
	FALSE,          /* xxx */
#endif /* ALLOW_EASY_OPEN */
	TRUE,		/* OPT_auto_haggle */
	FALSE,		/* OPT_auto_scum */
	TRUE,		/* OPT_testing_stack */
	TRUE,		/* OPT_testing_carry */
	TRUE,		/* OPT_expand_look */
	FALSE,		/* OPT_expand_list */
	TRUE,		/* OPT_view_perma_grids */
	TRUE,		/* OPT_view_torch_grids */
	FALSE,		/* OPT_dungeon_align */
	TRUE,		/* OPT_dungeon_stair */
	FALSE,		/* OPT_flow_by_sound */
	FALSE,		/* OPT_flow_by_smell */
#ifdef ALLOW_EASY_DISARM /* TNB */
	FALSE,   		/* OPT_easy_disarm */
#else
	FALSE,		/* xxx */
#endif /* ALLOW_EASY_DISARM */
	FALSE,		/* xxx */
	TRUE,		/* OPT_smart_learn */
	FALSE,		/* OPT_smart_cheat */
	FALSE,		/* OPT_view_reduce_lite */
	FALSE,		/* OPT_hidden_player */
	FALSE,		/* OPT_avoid_abort */
	FALSE,		/* OPT_avoid_other */
	TRUE,		/* OPT_flush_failure */
	FALSE,		/* OPT_flush_disturb */
	FALSE,		/* xxx */
	TRUE,		/* OPT_fresh_before */
	FALSE,		/* OPT_fresh_after */
	TRUE,		/* OPT_empty_levels */
	TRUE,		/* OPT_compress_savefile */
	FALSE,		/* OPT_hilite_player */
	TRUE,		/* OPT_view_yellow_lite */
	TRUE,		/* OPT_view_bright_lite */
	FALSE,		/* OPT_view_granite_lite */
	TRUE		/* OPT_view_special_lite */
};


/*
 * Option screen interface
 */
byte option_page[4][16] =
{
	/*** User-Interface ***/

	{
		OPT_rogue_like_commands,
		OPT_quick_messages,
		OPT_floor_query_flag,
		OPT_carry_query_flag,
		OPT_use_old_target,
		OPT_always_pickup,
		OPT_always_repeat,
		OPT_depth_in_feet,
		OPT_stack_force_notes,
		OPT_stack_force_costs,
		OPT_show_labels,
		OPT_show_weights,
		OPT_show_choices,
		OPT_show_details,
		OPT_show_flavors,
		OPT_ring_bell
	},

	/*** Disturbance ***/

	{
		OPT_run_ignore_stairs,
		OPT_run_ignore_doors,
		OPT_run_cut_corners,
		OPT_run_use_corners,
		OPT_disturb_move,
		OPT_disturb_near,
		OPT_disturb_panel,
		OPT_disturb_state,
		OPT_disturb_minor,
		OPT_disturb_other,
		OPT_alert_hitpoint,
		OPT_alert_failure,
		OPT_verify_destroy,
		OPT_verify_special,
		OPT_allow_quantity,
		255
	},

	/*** Game-Play ***/

	{
		OPT_auto_haggle,
		OPT_auto_scum,
		OPT_testing_stack,
		OPT_testing_carry,
		OPT_expand_look,
		OPT_expand_list,
		OPT_view_perma_grids,
		OPT_view_torch_grids,
		OPT_dungeon_align,
		OPT_dungeon_stair,
		OPT_flow_by_sound,
		OPT_flow_by_smell,
		OPT_smart_learn,
		OPT_smart_cheat,
		OPT_empty_levels,
		255
	},

	/*** Efficiency ***/

	{
		OPT_view_reduce_lite,
		OPT_hidden_player,
		OPT_avoid_abort,
		OPT_avoid_other,
		OPT_flush_failure,
		OPT_flush_disturb,
		OPT_fresh_before,
		OPT_fresh_after,
		OPT_compress_savefile,
		OPT_hilite_player,
		OPT_view_yellow_lite,
		OPT_view_bright_lite,
		OPT_view_granite_lite,
		OPT_view_special_lite,
#ifdef ALLOW_EASY_OPEN /* TNB */
		OPT_easy_open,
#else
		255,
#endif /* ALLOW_EASY_OPEN */
#ifdef ALLOW_EASY_DISARM /* TNB */
		OPT_easy_disarm,
#else
		255
#endif /* ALLOW_EASY_DISARM */
	}
};

/* Table of Druid blows. -LM- */
druid_blows d_blow[NUM_D_BLOWS] =
{
	{ "punch", 			 1, 4 },
	{ "kick", 			 2, 3 },
	{ "knee", 			 1,10 },
	{ "chop", 			 2, 6 },
	{ "uppercut",		 3, 5 },
	{ "boot",			 3, 8 },
	{ "bang on", 		 5, 5 },
	{ "slam", 			 4, 9 },
	{ "grapple with", 	12, 3 },
	{ "hammer", 		 9, 6 },
	{ "head butt",		 3,24 },
	{ "strangle", 		 8,10 },
	{ "roundhouse kick",	 5,19 },
	{ "assault",		10,11 },
	{ "crush",			11,11 },
	{ "double-kick",		21, 6 },
	{ "thunderclap belt",	 8,19 },
	{ "blizzard gouge",	14,11 },
	{ "tsunami whirl",	 7,26 },
	{ "stormwind chop",	10,22 }
};
