/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include "global.h"

#define	PUBLIC_RELEASE
#ifdef HAVE_XPM
#ifdef PUBLIC_RELEASE
#include "author.xpm"
#else
#include "unifix.xpm"
#endif
static	XpmAttributes	pattr;
#else
#ifdef PUBLIC_RELEASE
#include "author.xbm"
#else
#include "unifix.xbm"
#endif
#endif

/*
 * Local variables
 */
static char	*notice =
"Xfilemanager Version "
VERSION
" - Licensed for Unifix Software GmbH\n\n"
#ifdef PUBLIC_RELEASE
"                                       Copyright (C.) 1993\n"
"                                       by\n"
"                                       Ove Kalkan\n"
"                                       All rights reserved\n\n\n\n"
#else
"\n\n"
"Copyright (C.) 1993 by Ove Kalkan - All rights reserved\n\n"
#endif
"Copyright notice:\n\n"
"xfilemanager is for personal use only and no public-domain\n"
"software\n"
"Commercial users must register their version and get a\n"
"\"distributing-license\".\n\n"
"Permission to use, copy and distribute xfilemanager\n"
"for non-commercial purposes is hereby granted without\n"
"fee, provided that this copyright notice appear in\n"
"all copies.\n\n"
"Note that distributing xfilemanager \"bundled\" in\n"
"with any product is considered to be a\n"
"\"commercial purpose\"\n\n"
"The software may be modified for your own purposes,\n"
"but modified versions may not be distributed without\n"
"prior consent of the author.\n\n"
"This software is provided \"as-is\", without any express\n"
"or implied warranty. In no event will the author be\n"
"held liable for any damages arising from the use of\n"
"this software.\n\n"
"If you would like to do something with xfilemanager that\n"
"this copyright prohibes (such as distributing it with a\n"
"commercial product, using portions of the source in some\n"
"other programs, etc.), please contact the author.\n"
"Arrangements can probably be worked out.\n\n"
"The Author:\n"
"       Ove Kalkan\n"
"       Vor der Burg 2a\n"
"       38162 Cremlingen\n"
"       Germany\n\n"
"Email: kalkan@ramz.ing.tu-bs.de\n\n";

static	Widget	about_shell = NULL;
static	Widget	oicon = NULL;
static	Pixmap	opmap = (Pixmap) NULL;

static	void	hide_adialog(void);
#ifdef HAVE_XPM
static	int	about_width, about_height;
#endif


/*********************************************************
 * name:	initAbout
 * description:	Mappen des Info-Windows mit der Copyright notiz
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	2.7.93
 *********************************************************/
void	initAbout(void)
{
	Widget	form, icon, title, text, but;
	Arg	args[10];

	if (!opmap) {	/* Einlesen der PGM-Datei mit meinem Konterfei */
#ifdef HAVE_XPM
		XpmCreatePixmapFromData(XtDisplay(toplevel),XtWindow(toplevel),author,
					&opmap,&smap,&pattr);
		about_width = pattr.width;
		about_height = pattr.height;
		if (about_height*about_width == 0)
			about_width = about_height = 90;
#else
		Pixmap	tmp;

		tmp = XCreatePixmapFromBitmapData(XtDisplay(toplevel), XtWindow(toplevel), about_bits,
					   about_width,about_height, 1,0, 1);
		opmap = XCreatePixmap(XtDisplay(toplevel),
						XtWindow(toplevel),
						about_width, about_height,
						XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))));
		if (opmap) {
			XCopyPlane(XtDisplay(toplevel),tmp,opmap,line_gc,0,0,
				   about_width,about_height,0,0,1);
		}
		XFreePixmap(XtDisplay(toplevel),tmp);
#endif
	}

	/*
	 * Dialog loeschen falls noch vorhanden
	 */
	if (about_shell)
		XtDestroyWidget(about_shell);

	/*
	 * Neues Shellwidget erzeugen
	 */
	about_shell = XtVaCreatePopupShell ("dialog_shell", 
					topLevelShellWidgetClass,
					toplevel, 
					XtNallowShellResize, TRUE,
					NULL);
	/*
	 * Darauf eine form erzeugen
	 */
	form = XtVaCreateManagedWidget ("dialog_form", formWidgetClass, about_shell,
					NULL);

	/*
	 * Den Simple fuer das Icon erstellen
	 */
	icon = XtVaCreateManagedWidget ("dialog_icon", iconWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNimageWidth, 32,
					XtNimageHeight, 32,
					XtNimage, Icon_Help_PM,
					XtNborderWidth, 0,
					NULL);
	/*
	 * Den Simple fuer das Icon erstellen
	 */
	oicon = XtVaCreateManagedWidget ("dialog_icon", iconWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNimageWidth, about_width,
					XtNimageHeight, about_height,
					XtNimage, opmap,
					XtNfromVert,icon,
#ifdef PUBLIC_RELEASE
					XtNvertDistance, 40,
					XtNhorizDistance, 20,
#else
#ifdef HAVE_XPM
					XtNborderWidth, 0,
#endif
					XtNvertDistance, 30,
					XtNhorizDistance, 10,
#endif
					NULL);

	/*
	 * den Label darauf erzeugen, der sagt, das es sich hierbei um
	 * eine Verschiebe-Aktion handelt
	 */
	title = XtVaCreateManagedWidget ("about_title", labelWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNborderWidth, 0,
					XtNlabel, strings[106],
					XtNfromHoriz, icon,
					NULL);

	/*
	 * Darauf jetzt ein Textwidget setzen
	 */
	text = XtVaCreateManagedWidget("about_text",labelWidgetClass,form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainBottom,
					XtNright, XtChainRight,
					XtNleft, XtChainLeft,
					XtNfromVert, icon,
					XtNlabel, notice,
					XtNborderWidth, 0,
					NULL);

	/*
	 * Den Hide Button
	 */
	but = XtVaCreateManagedWidget ("dialog_cancel", commandWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainBottom,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNlabel, strings[41],
					XtNfromVert, text,
					NULL);
	XtAddCallback(but,XtNcallback, (XtCallbackProc) hide_adialog, NULL);

	XtManageChild(about_shell);

	{
		Dimension	w,h;

		XtVaGetValues(about_shell,XtNwidth,&w,NULL);
		XtVaGetValues(about_shell,XtNheight,&h,NULL);
		XtVaSetValues(about_shell,XtNminWidth,w,NULL);
		XtVaSetValues(about_shell,XtNminHeight,h,NULL);
		XtVaSetValues(about_shell,XtNmaxWidth,w,NULL);
		XtVaSetValues(about_shell,XtNmaxHeight,h,NULL);
	}

}


/*********************************************************
 * name:	hide_adialog
 * description:	loeschen der About-shell
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	10.Sep.1993
 *********************************************************/
static	void	hide_adialog(void)
{
	if (about_shell)
		XtDestroyWidget(about_shell);
	about_shell = NULL;
}