/*
 * Simple mouse driver for the Logitech Bus Mouse
 * Mouse deltas and button state is accessed through an ioctl()
 *
 *	Written By
 *	John Plocher
 *	Jas Cluff
 *	Ken Chapin
 *
 *	This code is released into the Public Domain
 */

/*
**	Compile with    cc -Ml -c mouse.c	V/286  (V/AT)
**			cc     -c mouse.c	V/386  (3.0 or 3.2)
**
**	Install in the kernel configuration directories
**	generate a kernel & reboot off of it
**	run the tst program to test out behavior
*/

#include	"sys/param.h"
#include	"sys/types.h"
#include	"sys/dir.h"
#include	"sys/signal.h"
#include	"sys/user.h"
#include	"sys/errno.h"
#include	"mouse.h"

#ifdef DEBUG
#  define Dprintf(string)	printf(string)
#else
#  define Dprintf(string)
#endif

msinit()
{
	/*	Is mouse there?		*/

/* Test hardware registers to see if installed       TODO */

	/*	Initailize registers	*/
	outb(CONTROL, MOUSEDEFAULT);
	outb(PORTC, PORTC_DISABLE_INTERRUPTS);

	/*      Say hello world         */
#ifdef USE_INTS
	printf("ms 1.01 %x-%x %x Ints are used\n",
#else
	printf("ms 1.01 %x-%x %x No ints for now\n",
#endif
			PORTA, CONTROL, inb(SIGNATURE_PORT));
}

msstart()
{
	Dprintf("MSSTART\n");
}

msopen()
{
	Dprintf("MSOPEN\n");
	/*	Enable interrupts	*/
#ifdef USE_INTS
	outb(PORTC, PORTC_ENABLE_INTERRUPTS);
#endif
}

msclose()
{
	/*	Disable interrupts	*/
	Dprintf("MSCLOSE\n");
	outb(PORTC, PORTC_DISABLE_INTERRUPTS);
}

msread()
{
/* NOP - do nothing but disable interrupt generator on bus mouse board */
	Dprintf("MSREAD\n");
	outb(PORTC, PORTC_DISABLE_INTERRUPTS);
}

mswrite()
{
/* NOP - do nothing but disable interrupt generator on bus mouse board */
	Dprintf("MSWRITE\n");
	outb(PORTC, PORTC_DISABLE_INTERRUPTS);
}

msioctl(dev, cmd, arg)
int dev, cmd, *arg;
{
	/*	Get mouse values for user	*/

	/*
	** The Bus Mouse board keeps a running delta between reads
	** so all we do here is send it back to the user when she wants it
	*/

	register struct mousedat md;
	register unsigned int i;

	switch(cmd) {
	case MIOGETDATA:outb(PORTC, READ_X_LOW);
			md.deltax = inb(PORTA) & 0xf;
			outb(PORTC, READ_X_HIGH);
			md.deltax |= (inb(PORTA) & 0xf) << 4;

			outb(PORTC, READ_Y_LOW );
			md.deltay = inb(PORTA) & 0xf;
			outb(PORTC, READ_Y_HIGH);
			i = inb(PORTA);
			outb(PORTC, PORTC_DISABLE_INTERRUPTS);
			md.deltay |= (i & 0xf) << 4;
			md.buttons = i >> 5;

			if (copyout(&md, arg, sizeof md))
				u.u_error = EFAULT;
			break;

	default:	u.u_error = EFAULT;
			break;
	}
}

msintr()
{

/*
** Not Used - might be used to keep a running delta and send a signal to
** the controlling tty if a button was pressed ....
*/
	/*	Respond to squeak	*/
	Dprintf("M");
}

