
/*
**	Test program for Mouse Driver
*/

/* #define USE_GFX /* Microport 2.4 (286) or 3.0e (386) graphics interface */

#include <sys/io_op.h>
#include <sys/types.h>
#ifdef USE_GFX
#include <gfx.h>
#endif
#include "mouse.h"

int     mousefd;

#ifdef USE_GFX
Gfx_Bitmap bm;
#endif

main()
{
	register struct mousedat	new,old;
	register int xpos, ypos;

	old.deltax = old.deltay = old.buttons = 1;

	if ((mousefd = open("/dev/mouse")) == -1) {
		perror("open of mouse device");
		exit(1);
	}

#ifdef USE_GFX
	if (!(bm = gfx_open())) {
		perror("open of gfx");
		exit(1);
	}
	gfx_mode(bm, GRAPHIC);
	gfx_clear(bm, BLACK);
	ega_flush();
#else
#endif

	xpos = ypos = 1;
	while (old.buttons != 7) {	/* press all 3 buttons to quit */
		readmouse(&new);
		if (memcmp(&old, &new, sizeof(struct mousedat))) {	
#ifdef USE_GFX
            gfx_rect(bm,xpos-1, ypos-1,xpos+1, ypos+1,7+old.buttons,GFX_XOR);
			xpos += new.deltax; ypos += new.deltay;
            gfx_rect(bm,xpos-1, ypos-1,xpos+1, ypos+1,7+new.buttons,GFX_XOR);
			ega_flush();
			memcpy(&old, &new, sizeof(struct mousedat));
#else
			xpos += new.deltax; ypos += new.deltay;
		        printf("X=%03d Y=%03d  Buttons=%c%c%c\n", xpos, ypos,
				   new.buttons & 1 ? '*' : ' ',
				      new.buttons & 2 ? '*' : ' ',
				         new.buttons & 4 ? '*' : ' ' );
#endif
		}
	}
#ifdef USE_GFX
	gfx_dot(bm,xpos, ypos, BLACK, GFX_SRC);
	ega_flush();
	gfx_mode(bm, ALPHA);
#else
#endif
}

readmouse( md )
register struct mousedat *md;
{
	if ((ioctl(mousefd, MIOGETDATA, md)) == -1) {
		perror("IOCTL failed on /dev/mouse");
		exit(2);
	}
}

