/*	mouse.h:	header file for Logitech Bus Mouse driver	*/

#ifndef MOUSE_H
#define MOUSE_H

/* #define USE_INTS	/* Should the driver use interrupts? */

#define	PORTA	0x23c		/*	1100		*/
#define	SIGNATURE_PORT	0x23d	/*	1101		*/
#define	PORTC	0x23e		/*	1110		*/
#define	CONTROL	0x23f		/*	1111		*/

#define	SETMODE		0x80	/*	1xxx xxxx	*/
	/* Group A */
#define M_AMODE0	0x00	/*	x00x xxxx	*/
#define M_AMODE1	0x20	/*	x01x xxxx	*/
#define M_AMODE2	0x40	/*	x10x xxxx	*/
#define M_AIN		0x10	/*	xxx1 xxxx	*/
#define M_AOUT		0x00	/*	xxx0 xxxx	*/
#define M_CUIN		0x08	/*	xxxx 1xxx	*/
#define M_CUOUT		0x00	/*	xxxx 0xxx	*/
	/* Group B */
#define M_BMODE0	0x00	/*	xxxx x0xx	*/
#define M_BMODE1	0x04	/*	xxxx x1xx	*/
#define M_BIN		0x02	/*	xxxx xx1x	*/
#define M_BOUT		0x00	/*	xxxx xx0x	*/
#define M_CLIN		0x01	/*	xxxx xxx1	*/
#define M_CLOUT		0x00	/*	xxxx xxx0	*/

#define MOUSEDEFAULT	(SETMODE|M_AMODE0|M_AIN)	/* 1001 0000 */

#define	READ_X_LOW	0x80	/*	1000 0000	*/
#define	READ_X_HIGH	0xa0	/*	1010 0000	*/
#define	READ_Y_LOW	0xc0	/*	1100 0000	*/
#define	READ_Y_HIGH	0xe0	/*	1110 0000	*/

#define	PORTC_ENABLE_INTERRUPTS		0x80	/*	1000 0000	*/
#define	PORTC_DISABLE_INTERRUPTS	0x10	/*	0000 0000	*/

struct	mousedat { 
	unsigned char buttons; 
	char deltax,deltay;
};

/* IOCTLS */
#define	MIOGETDATA	(('M'<<8) | 0x01)	/* get mouse data */

#endif

