/*
 * Copyrighted as an unpublished work.
 * (c) Copyright 1991 Brian Smith
 * All rights reserved.
 *
 * Read the LICENSE file for details on distribution and use.
 *
 */

#ifndef NBPP
#include <sys/immu.h>
#endif

#if !defined(TRUE) || !defined(FALSE)
#define FALSE 0
#define TRUE  1
#endif

/* minor numbers */
#define SB_CMS_NUM  0
#define SB_FM_NUM   1
#define SB_DSP_NUM  2

/* These are hard wired for speed */
#define SB_DMA_CHAN 1
#define SB_IO_PORT 0x220

/* C/MS (not supported) */
#define CMS_DATA1   (SB_IO_PORT + 0x00)
#define CMS_REG1    (SB_IO_PORT + 0x01)
#define CMS_DATA2   (SB_IO_PORT + 0x02)
#define CMS_REG2    (SB_IO_PORT + 0x03)

/* FM Chips */
#define FM_SELECT   (SB_IO_PORT + 0x08)
#define FM_REG      (SB_IO_PORT + 0x09)
#define MAX_FM_NOTES 9

/* DSP (DAC and ADC) Chip(s) */
#define DSP_RESET   (SB_IO_PORT + 0x06)
#define DSP_RDDATA  (SB_IO_PORT + 0x0A)
#define DSP_WRDATA  (SB_IO_PORT + 0x0C)
#define DSP_COMMAND (SB_IO_PORT + 0x0C)
#define DSP_STATUS  (SB_IO_PORT + 0x0C)
#define DSP_RDAVAIL (SB_IO_PORT + 0x0E)

/* status bytes (can be OR'ed) */
#define NOT_OPEN    0
#define OPEN_READ   1
#define OPEN_WRITE  2

/* compression types */
#define ADCPM_8     0
#define ADCPM_4     1
#define ADCPM_2_6   2
#define ADCPM_2     3

/* ioctl numbers for DSP */
#define DSP_IOCTL_RESET 00
#define DSP_IOCTL_SPEED 01
#define DSP_IOCTL_VOICE 02

/* ioctl numbers for FM */
#define FM_IOCTL_RESET      00
#define FM_IOCTL_NOTE_ON    01
#define FM_IOCTL_NOTE_OFF   02
#define FM_IOCTL_SET_VOICE  03
#define FM_IOCTL_SET_OPCELL 04
#define FM_IOCTL_SET_RHYTHM 05

/* struct for setting a note/voice/key on */
typedef int sb_fm_note;
#define note_num(X) (((unsigned char *)&X)[0])
#define fnum_low(X) (((unsigned char *)&X)[1])
#define keyon_blk_fnum(X) (((unsigned char *)&X)[2])

typedef struct {
    unsigned char   voice_num;
    unsigned char   data[16];
} sb_fm_character;

#ifdef INKERNEL
struct sb_stat_type {
    char unsigned   cms_open;           /* whether in read/write */
    char unsigned   cms_waiting;        /* number of procs waiting to open */
    char unsigned   fm_open;            /* whether in read/write */
    char unsigned   fm_waiting;         /* number of procs waiting to open */
    char unsigned   dsp_open;           /* whether in read/write */
    unsigned int    dsp_speed;          /* sample read/write HZ */
    char unsigned   dsp_compression;    /* compression protocol */
};

extern struct sb_stat_type sb_status;
extern struct iobuf sbtab[3];

#endif
