/*
 * stuff for the scsi driver
 */

#define HD_FMT 		((unsigned char) 0x04)
#define HD_MDSEL	((unsigned char) 0x15)
#define HD_MDSEN	((unsigned char) 0x1a)
#define HD_READ		((unsigned char) 0x28) /* extended */
#define HD_WRITE	((unsigned char) 0x2a) /* extended */
#define HD_TRDY		((unsigned char) 0x00)
#define HD_RSENSE	((unsigned char) 0x03)
#define HD_MSTART	((unsigned char) 0x1b)
#define HD_INQUIRY	((unsigned char) 0x12)

#define HD_ERPAR	0x1
#define HD_CONPAR	0x2
#define HD_FORMPAR	0x3
#define HD_GEOPAR	0x4
#define HD_CACHEPAR	0x8
#define HD_MODPAR	0x20

#define HD_TRY1		9

#define FD_SPEC		0x03
#define FD_SDS		0x04
#define FD_RECAL	0x07
#define FD_SEEK		0x0f
#define FD_SIS		0x08
#define FD_EMO		0x1e

#define MT_MDSEL	((unsigned char) 0x15)
#define MT_MDSEN	((unsigned char) 0x1a)
#define MT_READ		((unsigned char) 0x08)
#define MT_WRITE	((unsigned char) 0x0a)
#define MT_TRDY		((unsigned char) 0x00)
#define MT_RSENSE	((unsigned char) 0x03)
#define MT_INQUIRY	((unsigned char) 0x12)
#define MT_RWND		((unsigned char) 0x01)
#define MT_RSNS		((unsigned char) 0x03)

#define DM_READ		((unsigned char) 0x08)
#define DM_SPACE	((unsigned char) 0x11)
#define DM_TRDY		((unsigned char) 0x00)

#define RECOVERED_ERR	0x01
#define NOT_READY	0x02
#define UNITATTENTION	0x06

#define CHECK_CONDITION	0x02

#define MESSAGE_REJECT	0x07

#define DISKTYPE	0x00
#define TAPETYPE	0x01

static char *drive_type[] = {
	"Disk",
	"Tape",
	(char *) 0,
};

static char *sensekey[] = {
	"No sense",
	"Recovered error",
	"Not ready",
	"Medium error",
	"Hardware error",
	"Illegal request",
	"Unit attention",
	"Data protect",
	"Blank check",
	"Vendor unique ?",
	"Copy aborted",
	"Aborted command",
	"Equal",
	"Volume overflow",
	"Miscompare",
	"Reserved ?",
	"???",
};

static char *bus_phases[] = {
	"Data out",
	"Unknown",
	"Unknown",
	"Unknown",
	"Data in",
	"Unknown",
	"Unknown",
	"Unknown",
	"Command",
	"Unknown",
	"Unknown",
	"Message out",
	"Unknown",
	"Status",
	"Unknown",
	"Message in",
};


/*
 * structure of some data returned by SCSI commands is below:
 */

/* INQUIRY DATA */
struct  inquiry_data {
	unchar  inqd_pdt;       /* Peripheral Device Type (see below) */
	unchar  inqd_dtq;       /* Device Type Qualifier (see below) */
};

/* values for inqd_pdt: */
#define INQD_PDT_DA     0x00    /* Direct-access (DISK) device */
#define INQD_PDT_SEQ    0x01    /* Sequential-access (TAPE) device */
#define INQD_PDT_PRINT  0x02    /* Printer device */
#define INQD_PDT_PROC   0x03    /* Processor device */
#define INQD_PDT_WORM   0x04    /* Write-once read-many direct-access device */
#define INQD_PDT_ROM    0x05    /* Read-only directe-access device */
#define INQD_PDT_NOLUN  0x7f    /* Logical Unit Not Present */

/* masks for inqd_dtq: */
#define INQD_DTQ_RMB    0x80    /* Removable Medium Bit mask */
#define INQD_DTQ_MASK   0x7f    /* mask for device type qualifier field */


/* READ CAPACITY DATA */
struct readcap_data {
	unchar rdcd_lba[4];   /* Logical Block Address (MSB first, LSB last) */
	unchar rdcd_bl[4];    /* Block Length (MSB first, LSB last) */
};


/* SENSE DATA (non-extended) */
struct nxsense_data {
	unchar  nxsd_err;       /* error class and code (see fields, below) */
	unchar  nxsd_lba[3];    /* logical block number */
};

#define NXSD_LBA_MASK0  0x1f    /* mask for block # portion of nxsd_lba[0] */

/* SENSE DATA (extended) */
struct exsense_data {
	unchar  exsd_err;       /* error class and code (see fields, below) */
	unchar  exsd_seg;       /* segment number */
	unchar  exsd_key;       /* sense key & other fields (defined below) */
	unchar  exsd_info[4];   /* information bytes */
	unchar  exsd_adlen;     /* additional sense length */
	unchar  exsd_adsd[1];   /* additional sense bytes */
};

/* fields for nxsd_err and exsd_err bytes: */
union   sd_err_fields {
	struct {
		uint    sder_errcod : 4; /* error code (0 for extended sense) */
		uint    sder_errcls : 3; /* error class (7 for ext sense) */
		uint    sder_valid  : 1; /* Address Valid bit */
	} sef;
	unchar  sec;
};

/* fields for exsd_key byte: */
union   sd_key_fields {
	struct {
		uint    sdky_key    : 4;        /* actual sense key */
		uint    sdky_res1   : 1;        /* reserved */
		uint    sdky_ili    : 1;        /* Incorrect Length Indicator */
		uint    sdky_eom    : 1;        /* End of Medium bit */
		uint    sdky_fmark  : 1;        /* Filemark bit */
	} skf;
	unchar  skc;
};


/* Read Block Limits Data */
struct blocklim_data {
	unchar  bkld_res;       /* reserved */
	unchar  bkld_max[3];    /* Maximum block length */
	unchar  bkld_min[2];    /* Minimum block length */
};


/* Viper Tape (Archive) Mode Sense Data */
struct tpmsen_data {
	unchar  tmsd_dl;        /* Sense Data Length */
	unchar  tmsd_med;       /* Medium Type */
	unchar  tmsd_modes;     /* WP bit,  buffer mode, speed (below) */
	unchar  tmsd_bdl;       /* Block Descriptor Length */
	/* Following 8 bytes are Block Descriptors */
	unchar  tmsd_den;       /* Density code (below) */
	unchar  tmds_nblk[3];   /* Number of blocks field */
	unchar  tmds_res;       /* Reserved */
	unchar  tmds_blkl[3];   /* Block Length */
};

/* Field for accessing tmsd_modes byte */
union tms_mode_fields {
	struct {
		uint    tmsm_speed : 4; /* Speed */
		uint    tmsm_bufm  : 3; /* Buffer mode (below) */
		uint    tmsm_wp    : 1; /* Write-Protect bit */
	} tmf;
	unchar  tmc;
};

/* Definitions for Buffer Mode field */
#define TMSD_NOBUF      0       /* Unbuffered mode */
#define TMSD_BUF        1       /* Buffered mode */

/* Definitions for Density Code field */
#define TMSD_60MB       5       /* Low-density (9-trk) mode */
#define TMSD_125MB      0x0f    /* Medium-density (15-trk) mode */
#define TMSD_150MB      0x10    /* High-density (18-trk) mode */

typedef struct {
	unsigned char di_state;	/* state variable */
	unsigned char di_ccode;	/* completion code */
	unsigned char di_sb;	/* status byte */
	unsigned char di_scsi_type; /* disk, tape, ... */
	unsigned char di_is_scsi2;	/* does it support scsi2 ? */
	unsigned char di_pad;
	unsigned short di_flags;
	unsigned char *di_cdbp;	/* CDB pointer */
	int di_cdb_len;		/* CDB length */
	unsigned char *di_data_p;	/* data pointer */
	int di_data_len;		/* length of data to read/write */
} driveinfo_t;

/* states */
#define DI_CMD		1
#define DI_DATA		2
#define DI_CCS		3
#define DI_MACK		4
#define DI_PAD		5
#define DI_NCMD		6
#define DI_MSGIN	7
#define DI_MSGOUT	8
#define DI_MSG		9
#define DI_ENRES	10

/* flags */
#define DI_CANDIS	0x01
#define DI_RETRY	0x02
#define DI_INIT		0x04
#define DI_MSGONLY	0x08
#define DI_READ		0x10
#define DI_WRITE	0x20

typedef struct {
	int flags;
	unsigned char *nextmsg;
	int nextlen;
	unsigned char syncoff;	/* value to use */
	unsigned char period;	/* value to use */
	unsigned char my_syncoff;	/* value I'd like */
	unsigned char his_syncoff;	/* value he'd like */
	unsigned char my_period;	/* value I'd like */
	unsigned char his_period;	/* value he'd like */
} tcinfo_t;

/* tcinfo flags */
#define TI_SENTSDTR	1	/* sent synchronous i/o data */
#define TI_RCVDSDTR	2	/* received synchronous i/o data */
#define TI_WANTSDTR	4	/* waiting for synchronous i/o data */

