#include "saio.h"

#define NUMBLK 200
#undef DOWRITE
#define READ 0
#define WRITE 2
unsigned char rbuffer [NUMBLK * 512];
#if defined(DOWRITE)
unsigned char wbuffer [NUMBLK * 512];
#endif
struct iob miob;
extern hd_open(), hd_strategy(), hd_close();

main()
{
     register int res;
     register int i;

     if (do_scsi_init() < 0) {
	printf("main: init failed\n");
	exit (1);
     }

     bzero (rbuffer, NUMBLK * 512);
#if defined(DOWRITE)
     for (i=0; i < NUMBLK * 512; i++)
	  wbuffer [i] = i & 255;
#endif
     miob.i_cntrl = 0;
     miob.i_target = 0;
     miob.i_lun = 0;
     res = hd_open (&miob);
     if (res) {
	  printf ("after open res 0x%x\n", res);
	  exit (1);
     }
     /* change the block number to on you can use */
     miob.i_bn = 250000;
     miob.i_boff = 0;
     miob.i_cc = NUMBLK * 512;
#if defined(DOWRITE)
     miob.i_ma = wbuffer;
     res = hd_strategy (&miob, WRITE);
     if (res < 0 || res != miob.i_cc) {
	     printf("after write res = 0x%x cc = 0x%x\n", res, miob.i_cc);
	     hd_close ();
	     exit (1);
     }
     printf ("wbuffer is at 0x%x\n", wbuffer);
#endif
     miob.i_ma = rbuffer;
     for(i = 0; i < 1; i++) {
         res = hd_strategy (&miob, READ);
         if (res < 0 || res != miob.i_cc) {
	         printf("after read res = 0x%x cc = 0x%x\n", res, miob.i_cc);
	         hd_close ();
	         exit (1);
         }
     }
     printf ("rbuffer is at 0x%x\n", rbuffer);
#if defined(DOWRITE)
     for (i = 0; i < NUMBLK * 512; i++) {
	  if (rbuffer [i] != wbuffer [i]) {
	       printf ("byte %d not equal!!!\n", i);
	       break;
	  }
     }
#endif

     hd_close ();
     exit (0);
}

ulimit() {}
