#include <stdio.h>
#include <termios.h>
#include "ttyio.h"

#define TRUE 1
#define FALSE 0

static struct termios savetty;
static struct termios tty;
static int havetty = FALSE;

static int savevmin, savevtime;
static int havevminvtime = FALSE;

tty_init()
{
}

tty_setmode(flags)
int flags;
{
if(!havetty)
	{
	if(tcgetattr(0, &savetty) < 0)
		return -1;

	tty = savetty;
	havetty = TRUE;
	}

if(flags & TTY_ECHO)
	tty.c_lflag |= ECHO;

if(flags & TTY_NOECHO)
	tty.c_lflag &= ~ECHO;

if(flags & TTY_CANON)
	{
	tty.c_lflag |= ICANON;
	tty.c_iflag |= ICRNL;
	if(havevminvtime)
		{
		tty.c_cc[VMIN] = savevmin;
		tty.c_cc[VTIME] = savevtime;
		}
	}

if(flags & TTY_NOCANON)
	{
	tty.c_lflag &= ~ICANON;
	tty.c_iflag &= ~ICRNL;
	savevmin = tty.c_cc[VMIN];
	savevtime = tty.c_cc[VTIME];
	havevminvtime = TRUE;
	tty.c_cc[VMIN] = 1;
	tty.c_cc[VTIME] = 0;
	}

if(tcsetattr(0, TCSANOW, &tty) < 0)
	return -1;

return 0;
}

tty_getchar()
{
return getchar();
}

tty_navail()
{
#ifdef FIONREAD

int nchars;

if(ioctl(0, FIONREAD, &nchars) < 0)
	return -1;

return nchars;

#else

return -1;

#endif
}

tty_reset()
{
if(havetty)
	{
	if(!(tty.c_lflag & ICANON) && havevminvtime)
		{
		savetty.c_cc[VMIN] = savevmin;
		savetty.c_cc[VTIME] = savevtime;
		}

	tcsetattr(0, TCSANOW, &savetty);
	}
}
