 
/*-----------------------------------------------------------------------
-------------------------------------------------------------------------

   FILE:	sim.h
   PURPOSE:	Global data structures and declarations for the 
		execution model.

   AUTHOR: 	Tan Phan
   DATE:	Spring 1989

   USAGE:	See the 'make' file.

   HISTORY:	Spring 1989	-- Creation


   Copyright North Carolina State University. All Rights Reserved.

-------------------------------------------------------------------------
------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------
   Constants definitions:
------------------------------------------------------------------------*/
/* Add new DS5 here:							*/
#define	START_SIM_DS		0
#define	SSTEP_ON_DS		1
#define	STRACE_ON_DS		2
#define	DTRACE_ON_DS		7

/* Add new CB here:							*/
#define LOAD_CODE_CB		0
#define START_SIM_CB		1
#define STRACE_ON_CB		2
#define SSTEP_ON_CB		3
#define TAKE_STEP_CB		4

#define EXIT_PROG_CB		8
#define HALT_SIM_CB		9
#define STRACE_OFF_CB		10
#define SSTEP_OFF_CB		11
#define VIEW_MEM_CB		12
#define CLEAR_ALL_CB		13
#define INT_CB			16

/*-----------------------------------------------------------------------
   Add your constants here:
------------------------------------------------------------------------*/
/* Indexes for array of registers:					*/
#define D0	0
#define D1	1
#define D2	2
#define D3	3
#define D4	4
#define D5	5
#define D6	6
#define D7	7
#define A0	8
#define A1	9
#define A2	10
#define A3	11
#define A4	12
#define A5	13
#define A6	14
#define A7	15
#define SSP	16
#define USP	17 


#define DAMask		0x8000		/* Data or address register */
#define AddrMask	0x7000		/* the register number */
#define SizeMask	0x0800		/* long or word index length */
#define DispMask	0x00ff		/* get the displacement */
#define BitImmed  	0		/* Bit Manipulation/MOVEP/Immediate */
#define Short		1
#define Word		3
#define Long		2
#define MOVEB		1
#define MOVEL		2
#define MOVEW		3
#define MISC		4
#define DBcc		5
#define BSR		6
#define MOVEQ		7
#define ORDIV		8
#define SUBX		9
#define CMP		11
#define ANDMUL		12
#define ADDX		13
#define SHFTROT   	14
#define DDirect		0
#define ADirect		1
#define AIndirect 	2
#define AIndInc		3
#define AIndDec		4
#define AIndDisp	5
#define AIndIx		6
#define SpecModes 	7
#define AbShort		0
#define AbLong		1
#define PCDis		2
#define PCIx		3
#define Immed		4
#define STOP		1
#define NORMAL	 	0
#define MemErr		-1
#define IllOpcode	-2
#define IllAddMode	-3
#define BrkPt		-4
#define TrapCode	-5
#define DEST		1
#define SOURCE		0
#define ModeMask	7
/*-----------------------------------------------------------------------
   External variables declaration:
   
   Declare the global simulator variables here.
   Global declarations must be preceded by `extern' statement.
------------------------------------------------------------------------*/
extern	int		strace_on,
			sstep_on;

/*----------------------------------------------------------------------
   Our global variables.
------------------------------------------------------------------------*/
extern  unsigned int 	reg[18],
		        pc;
extern	unsigned int	f_X, f_N, f_Z, f_V, f_C,
			Sbit,Tbit,I0Bit,I1Bit,I2Bit;
extern char  		*Un1,*Un2,*Un3,*Un4,*Un5,*Un6;
