/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_fn_members.h"
 *                                    created: 22/10/97 {11:46:12 am} 
 *                                last update: 05/06/98 {16:26:39 PM} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  22/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_fn_members_
#define _Cpptcl_cpptcl_fn_members_

#include "cpptcl_member_base.icc"

//@Section: Cpptcl library
//@Man: 
DLL_IMPORT_EXPORT
class cpp_fn_mem: public cpp_operator_mem {
	friend class cpp_member_info;
  protected:
    ///
	cpp_fn_mem(const cpp_fn_mem& c):cpp_operator_mem(c) {}
  public:
	Cpptcl_BaseClass(cpp_fn_mem);
    ///
	cpp_fn_mem(const char* n):cpp_operator_mem(n) {}
	///
	int parse_tcl_command (tcl_args& arg);
	///
	bool ensemble_behaviour(void) const { return true;}
    ///
	int parse_meta_commands(tcl_obj&, tcl_args& arg);
	///
	void get_syntax(tcl_args& arg) const;
    ///
    void conversion_error(tcl_args&) const {}
    ///
	virtual const char* return_type(void) const=0;
    ///
	virtual const char* arguments(void) const=0;	
};

//@Section: Cpptcl library
//@Man: 
template <class T>
class cpptcl_fn_member: public cpp_fn_mem {
  protected:
    ///
	cpp_mem* copy(void) const {return new cpptcl_fn_member<T>(*this);}
    ///
	cpptcl_fn_member(const cpptcl_fn_member<T>& c)
	:cpp_fn_mem(c),ptmf(c.ptmf),_arguments(c._arguments),
	_description(c._description) {}
  public:
	/// method arguments
	const char* arguments(void) const { return _arguments;}
	/// method description
	const char* description(void) const { return _description;}
    ///
	cpptcl_fn_member(const char* n, T p, const char* a, const char* d)
	:cpp_fn_mem(n),ptmf(p),_arguments(a),_description(d){}
	~cpptcl_fn_member(void) {}
	///
	bool private_data(const cpp_private& data) const {
	    #ifdef __GNUC__
	    return (data == (cpp_mfptr)ptmf);
	    #else
	    return (data == (cpp_mptr)ptmf);
	    #endif
	}
	//@Man: method details
	//@{
	/// method return type
	const char* return_type(void) const { return "";}
	/// call function and put result in the output
	void tcl_get(tcl_object* o, tcl_obj& out) const;
	/// read argument list for function call from arg list
	tcl_args& read(tcl_args& arg) const { return arg;}
  protected:
	/// pointer to member function
	T ptmf;
	/// arguments
	const char* _arguments;
	/// description
	const char* _description;
	//@}
};

#define cppFnmember(n,name,ret,param,args,desc) \
  cpptcl_fn_member<ret (tcl_object::*)(param)>(n, \
  	(ret (tcl_object::*)(param))name,args,desc)

#endif
