## -*-Tcl-*-
 # ###################################################################
 #  Cpptcl - connecting C++ with Tcl
 # 
 #  FILE: "Mwerks_export.tcl"
 #                                    created: 19/2/98 {8:20:16 am} 
 #                                last update: 03/22/1999 {22:39:16 PM} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Copyright (c) 1998  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

package require Tk 8.0
set dir [file dirname [info script]]
set exps [glob -nocomplain [file join $dir *.exp]]
update
if {[llength $exps] == 1} {
    set orig [lindex $exps 0]
} else {
    set orig [tk_getOpenFile]
}
set fin [open $orig r]
set contents [read $fin]
close $fin
set out "[file root $orig].exp"
#set out [tk_getSaveFile -initialfile "[file root $orig].exp"]
if {[file exists $out]} {
    button .b -text "Replace" -command "set replace 1"
    button .c -text "Append" -command "set replace 0" -default active \
	    -takefocus 1
    pack .b .c -side left
    focus .b 
    console show
    update
    global replace
    #vwait replace
    set replace 0
    if {$replace} {
	file delete $out
    }
}
regsub -all {Link Error   : Too many errors; link terminated} $contents "" contents
regsub -all {Link Error   : Undefined symbol: } $contents "/EXPORT: " contents
regsub -all  "(\\(\[^)\]+\\) )?in( file:)?\[\r\n\]+\[^\r\n\]+\[\r\n\]+" $contents "\n" contents
set contents [lsort -dictionary [split $contents "\n"]]
set fout [open $out a+]
set last ""
foreach c $contents {
    set c [string trimright $c]
    if {$c != $last} {
	if {[regexp {@@[AB]$} $c]} {
	    puts $fout "[set last $c] ,DATA"
	} else {
	    puts $fout [set last $c]
	}
    }
}
close $fout
foreach file [glob -nocomplain "[file root $orig]{0,1,2,3,4,5,6,7,8,9}*.dll"] {
    file delete $file
}
file delete "[file root $orig].dll"
exit
