/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "Demofour.h"
 *									  created: 21/10/95 {4:43:43 pm}	
 *								  last update: 28/10/97 {11:39:47 am}	
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	9/12/96	 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_siteswap_
#define _Cpptcl_siteswap_

#include "cpptcl.h"

//@Section: Demonstration classes
//@Man: 
struct juggle_flags {
	int	ground, numonly, sequence, irred,
			oneone, rhythm, number, maxThrow,
			pattLen, multiplex, streams;
};

const  int ASYNCH_SOLO   =   1;
       /* different types of modes */
const  int SYNCH_SOLO     =  2;

const  int ASYNCH_PASSING  = 3;

const  int CUSTOM        =   4;
 

/*
const MaxStreams	4
const MaxThrow	11
const MaxLength	11
const MaxSlotSize 13
const MaxBalls	11
const MaxMplex	4
*/


//const  BUFFER_SIZE      160     /* # of chars. in file input buffer */
const  int CHARS_PER_THROW =  10;     /* max. # of chars. printed per throw */

struct jthrow {                    /* records throw information */
   int to;                            /* destination hand # */
   int height;                         /* total time ticks aloft */
};

struct filter {                   /* multiplexing filter slot entry */
   int type;                          /* type of entry */
   int from;                          /* source hand # */
   int height;                         /* total time ticks aloft */
};

const  int EMPTY     =       0  ;     /* types of multiplexing filter slots */
const  int THROW      =      1;
const  int LOWER_BOUND  =    2;

//@Section: Demonstration classes
//@Man: 
class siteswap: public tcl_object {
  public:
	// we need to know our interpreter and the name of our tcl command
	siteswap(tcl_args&);

  	~siteswap(void);

   /* 
	* we must supply this function so 'siteswap' can do something. it looks through
	* the arguments	and	does whatever it wants.	 the intention is for 
	* parse_tcl_command	to decide which	member function	to call, 
	* prepare the arguments	to that	member function	(perhaps 
	* converting strings to	ints or	suchlike), then	call the member	
	* function to do the actual	work.  parse_tcl_command should	just 
	* be a parser, as the name implies.
	*/

    int parse_tcl_command(tcl_args& arg);
	Cpptcl_Class(siteswap);

  protected:
  	
   /* The class siteswap manipulates these patterns */
	
   public:
 	int ground;
 	bool numonly;
 	bool irred;
 	bool allow_oneone;
 	int rhythm;
 	int number;
 	int maxThrow;
 	int pattLen;
 	int multiplex;
 	int streams;
 	long total_num;
 	
	int		rhythm_repunit[2][2],
				rhythm_period;	

  protected:	
	int	print_width;
	void set_rhythm(void);
  public:
 	virtual bool find_ground(void);
	virtual void print_streams(void);
	virtual void print_pattern(tcl_obj&);
	virtual bool check_pattern(void);
	virtual void make_rhythm(void);
	virtual bool find_next_possible(int position, int stream, int mplex_slot, int remainder);
  
 protected:
	char * starting_seq;
	char* ending_seq;
	int** pattern_catch;
	int *** ground_rhythm;
	int *** pattern_rhythm;
	jthrow*** pattern_throw;
	
   	virtual bool excited(void);
   	virtual bool pattern_increment(int& p, int& s, int& m, int& r);
   	virtual char *print_number(char *pos, int number);
   	virtual char *print_throw(char *pos, jthrow**, int**);
  
    bool *oneone, *old_oneone;
    
	/* virtual int valid_throw(int pos); */
	/* virtual int valid_pattern(void); */
	/* virtual int mp_addthrow(struct filter *dest_slot, int slot_hand, int type, int height, int from); */
	/* virtual void find_start_end(void); */

  private:
	void delete_arrays(void);
	void declare_arrays(void);
	
};


#endif
