            title   TeX_arith

; arithmetic subroutines for (e)TeX
; Copyright (C) 1989,97 by Peter Breitenlohner
; Distributed under terms of GNU General Public License

DATA        segment word
            extrn   aritherror:byte
            extrn   remainder:word
DATA        ends

CODE        segment word
            assume  cs:CODE, ds:DATA

; function  mult_and_add(n:integer;x,y:scaled;big:boolean):scaled;
;           computes n*x+y

            public multandadd
multandadd  proc   far
            push    bp
            mov     bp,sp

n_hi        equ     word ptr [bp+18]
n_lo        equ     word ptr [bp+16]
x_hi        equ     word ptr [bp+14]
x_lo        equ     word ptr [bp+12]
y_hi        equ     word ptr [bp+10]
y_lo        equ     word ptr [bp+8]
big         equ     byte ptr [bp+6]

            xor     bx,bx
            mov     di,x_lo
            mov     ax,x_hi      ; ax:di = x
            or      ax,ax
            jns     xpos1
            inc     bx           ; indicate x<0
            neg     ax
            neg     di
            sbb     ax,0         ; ax:di = |x|
xpos1:      mov     si,n_lo
            mov     dx,n_hi      ; dx:si = n
            or      dx,dx
            jns     npos
            xor     bl,1         ; indicate n<0
            neg     dx
            neg     si
            sbb     dx,0         ; dx:si = |n|
npos:       jz      nsmall       ; |n|<2^16
            or      ax,ax
            jz      xsmall       ; |x|<2^16

error1:     mov     aritherror,1 ; indicate overflow
            xor     ax,ax
            xor     dx,dx
            jmp     short done1

xsmall:     xchg    ax,dx
            xchg    di,si   ; |x| <=> |n|; si = |n|; ax:di = |x|
nsmall:     mul     si      ; dx:ax = x_hi*n
            or      dx,dx
            jnz     error1
            xchg    ax,di   ; di = x_hi*n
            mul     si      ; dx:ax = x_lo*n
            add     dx,di   ; dx:ax = |n*x|
            js      error1
            jc      error1
            dec     bx
            jnz     nxpos   ; n*x>0
            sub     ax,y_lo
            sbb     dx,y_hi ; dx:ax = -(n*x+y)
            jmp     short nxall
nxpos:      add     ax,y_lo
            adc     dx,y_hi ; dx:ax = n*x+y
nxall:      jo      error1
            test    big,1
            jnz     nxsign
            mov     cx,dx
            shl     cx,1
            jo      error1
nxsign:     inc     bx
            jz      done1   ; n*x>0
            neg     dx
            neg     ax
            sbb     dx,0    ; dx:ax = n*x+y
done1:      pop     bp
            ret     14
multandadd  endp

; function  xn_over_d(x:scaled;n,d:integer):scaled;
;           computes x*n/d

            public xnoverd
xnoverd     proc   far
            push    bp
            mov     bp,sp

x_hi        equ     word ptr [bp+16]
x_lo        equ     word ptr [bp+14]
n_hi        equ     word ptr [bp+12]
n_lo        equ     word ptr [bp+10]
d_hi        equ     word ptr [bp+8]
d_lo        equ     word ptr [bp+6]

            xor     si,si
            mov     ax,x_lo
            mov     di,x_hi      ; di:ax = x
            or      di,di
            jns     xpos2
            dec     si           ; indicate x<0
            neg     di
            neg     ax
            sbb     di,0         ; di:ax = |x|
xpos2:      mov     bx,n_lo
            mov     dx,n_hi      ; dx:bx = n
            or      dx,dx
            jnz     nlarge       ; n >= 2^16
            mul     bx
            xchg    bx,ax        ; ax = n
            mov     cx,dx        ; cx:bx = x_lo*n
            mul     di           ; dx:ax = x_hi*n
            add     ax,cx
            adc     dx,0         ; dx:ax:bx = |x|*n
            jmp     short divide
nlarge:     cmp     dx,1
            jne     error2       ; n > 2^16
            mov     dx,di
            or      bx,bx
            jz      divide       ; dx:ax:bx = |x|*2^16
            jmp     short error2 ; n > 2^16

dlarge:     cmp     di,1
            jne     error2       ; d > 2^16
            or      cx,cx
            jz      result       ; d = 2^16

error2:     mov     aritherror,1
            xor     dx,dx
            xor     si,si
            jmp     short done2

divide:     mov     cx,d_lo
            mov     di,d_hi      ; di:cx = d
            or      di,di
            jnz     dlarge       ; d >= 2^16
            cmp     dx,cx
            jnb     error2       ; result >= 2^32
            div     cx
            xchg    bx,ax
            div     cx
            xchg    bx,dx        ; dx:ax = |x|*n div d; bx = |x|*n mod d
result:     test    dh,0c0h
            jnz     error2       ; result >= 2^30
            or      si,si
            jns     done2
            neg     dx
            neg     ax
            sbb     dx,0         ; negate quotient
            neg     bx
            jnz     done2
            inc     si           ; remainder = 0
done2:      mov     remainder,bx
            mov     remainder+2,si
            pop     bp
            ret     12
xnoverd     endp

CODE        ends
            end
