/*
                A simple example of IPC for W32TeX

͊ȒPȃTvŁA܂ɂ̂ł͂܂B
TeX ̃RpCIAdviout オĂȂ
I dviout 𗧂グăvr[n߂܂B
dviout オĂA dviout Ńvr[n߂܂B
dviout オĂȂꍇAIɗグ邽߂ɂ
dviout.exe  PATH 猩Kv܂B ܂ATCP/IP 
gpłKv܂B

2002/06/08
A. Kakuto <kakuto@fuk.kindai.ac.jp>
*/

#include <stdio.h>
#include <string.h>
#include <process.h>
#include <windows.h>
#include <ddeml.h>

/*
ėf[^ADVI f[^ǂ𔻒f鐔lłB
ۂɂ DVI f[^͑Ȃ悤ɂĂ܂B
*/
#define THIS_IS_DVI_DATA 0x7fffffff


/*
IP AhX̓[JzXg 127.0.0.1 ɌŒ肳ĂāAύX
ł܂B
*/
#define IPC_LOCAL_HOST "127.0.0.1"

/*
gp|[g 4242 ɌŒ肳ĂāAύX͂ł܂B
*/
#define FIXED_PORT     htons((unsigned short)4242)

/*
TeX 瑗ĂRg[̌`łB
eof        : ɏoꂽ DVI t@C̃oCgɋ߂̂łB
namelength : ʏ 0 łB 0 łȂꍇɂ filename  DVI t@C
             tpXĂ܂B̖O̒ namelength łB
             A̒オ '\0' ɂȂĂۏ؂͂܂B
*/
struct msg
{
  int    namelength;
  int    eof;
  char   filename[256];
};

/*
DDE p̊e`łB
*/
DWORD DDEInst = 0;
HSZ hszDviout;
HSZ hszTopic;
DWORD hTransaction = 0;
HCONV hConv = NULL;

char ServiceName[] = "dviout";
char TopicName[]   = "dviout";

int  dde_connect(void);
void dde_disconnect(void);
void DoClientTransaction(LPSTR Data);
int  Stay = 0;
/*
DDE p callback function ͉ȂƂɂĂ܂B
*/
HDDEDATA CALLBACK DdeCallback( UINT uType, UINT uFmt, HCONV hconv, HSZ hsz1,
			      HSZ hsz2, HDDEDATA hdata, DWORD dwData1,
			      DWORD dwData2 )
{
  return 0;
}

/*
DDE 
*/
int dde_init(void)
{
  DDEInst = 0;
  DdeInitialize((LPDWORD) &DDEInst, (PFNCALLBACK) DdeCallback,
		APPCMD_CLIENTONLY, 0L);
  hszDviout = DdeCreateStringHandle(DDEInst, ServiceName, CP_WINANSI);
  if(!hszDviout) return 0;
  else return 1;
}

/*
XTYP_EXECUTE transaction  dviout Ɉ˗
*/
void DoClientTransaction(LPSTR Data)
{
  UINT DataLen = 0;

  if (hTransaction) DdeAbandonTransaction(DDEInst, hConv, hTransaction);
  if (Data) DataLen = strlen(Data) + 1;
  if (!DdeClientTransaction( Data, DataLen, hConv, 0, 0,
			    XTYP_EXECUTE, TIMEOUT_ASYNC, &hTransaction ) )
    {
      fprintf(stderr,"texview: DDE Transaction not accepted.\n");
      hTransaction = 0;
    }
}

/*
disconnect DDE
*/
void dde_disconnect(void)
{
  if (!hConv) return;

  if (hTransaction) DdeAbandonTransaction(DDEInst, hConv, hTransaction);
  hTransaction = 0;
  DdeDisconnect(hConv);
  hConv = 0;
}

int dde_connect(void)
{
  int ret = 1;
  if (hConv) return ret;

  dde_disconnect();
  hszTopic = DdeCreateStringHandle(DDEInst, TopicName, CP_WINANSI);
  if(!hszTopic) {
    fprintf(stderr, "texview: StringHandle not created.\n");
    return 0;
  }
  hConv = DdeConnect(DDEInst, hszDviout, hszTopic, NULL);
  if(!hConv) ret = 0;
  DdeFreeStringHandle(DDEInst, hszTopic);
  return ret;
}

int main(int argc, char **argv)
{
/*
̃vÕ\Pbgp
*/
  struct sockaddr_in ipc_addr;

/*
ڑ (TeX) p
*/
  struct sockaddr_in remote_addr;

  int ipc_addr_len;
  unsigned long n_addr;

  struct WSAData wsadata;
  int    i, j;
  SOCKET sock, sd;
  struct msg buff;
  char   fname[256];
  char   ddecmd[320];

  if(argc == 1)
    Stay = 0;
  else if((argc == 2) && strcmp(argv[1], "--stay") == 0)
    Stay = 1;

/*

*/
 Redo:
  if((i = WSAStartup(MAKEWORD(1,1), &wsadata)) != 0) {
    fprintf(stderr, "texview: WSAStartup error.\n");
    return 1;
  }

  n_addr = inet_addr(IPC_LOCAL_HOST);
  if(n_addr == INADDR_NONE) {
    fprintf(stderr, "texview: Invalid address.\n");
    WSACleanup();
    return 1;
  }

  sock = socket (AF_INET, SOCK_STREAM, 0);

  if(sock == INVALID_SOCKET) {
    fprintf(stderr, "texview: Invalid socket.\n");
    WSACleanup();
    return 1;
  }

  ipc_addr.sin_family = AF_INET;
  ipc_addr.sin_addr.s_addr = n_addr;
  ipc_addr.sin_port = FIXED_PORT;
  ipc_addr_len = sizeof(struct sockaddr_in);

  if (bind(sock, (struct sockaddr*)&ipc_addr, 
	   sizeof(struct sockaddr_in)) != SOCKET_ERROR) {
    listen(sock, 1);
  }
  else {
    closesocket(sock);
    fprintf(stderr, "texview: Bind error.\n");
    WSACleanup();
    return 1;
  }

  i = sizeof(remote_addr);

  fprintf(stderr,"\ntexview: Waiting for a connection ...\n");
  fprintf(stderr,"         Hit Control C to terminate this process.\n");

  sd = accept(sock, (struct sockaddr *)&remote_addr, &i);
  if(sd == INVALID_SOCKET) {
    fprintf(stderr, "texview: Invalid socket.\n");
    closesocket(sock);
    WSACleanup();
    return 1;
  }

  do {
    j = recv(sd, (char *)&buff, sizeof(struct msg), 0);
    if(j > 0) {
      if((buff.namelength != 0) &&
	 (buff.namelength != THIS_IS_DVI_DATA)) {
	buff.filename[buff.namelength] = '\0';
	strcpy(fname, buff.filename);
      }
    }
  } while( j != 0 && j != SOCKET_ERROR);

/*
terminate TCP/IP
*/
  closesocket(sock);
  WSACleanup();

/*
start DDE communication
*/
  sprintf(ddecmd,"[FileOpen(%s)]", fname);
  if(!dde_init()) {
    fprintf(stderr, "texview: Failed to initialize DDE.\n");
    return 1;
  }
  if(!dde_connect()) {
    if(spawnlp(P_NOWAIT, "dviout.exe", "dviout.exe", NULL) == -1) {
      fprintf(stderr, "texview: Failed to execute dviout.\n");
      return 1;
    }
    while(!dde_connect())
      Sleep(100);
  }

  DoClientTransaction(ddecmd);
  Sleep(400);

  dde_disconnect();
  DdeFreeStringHandle(DDEInst, hszDviout);

  if(Stay == 1)
    goto Redo;

  return 0;
}
