/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.TeXCellAlign;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;
import java.util.Vector;

public class TeXCellAlignList
extends Vector<TeXCellAlign> {
    public TeXCellAlignList(int n) {
        super(n);
    }

    public TeXCellAlignList() {
    }

    public TeXCellAlignList(TeXParser teXParser, TeXObject teXObject) throws IOException {
        this.parseAlignment(teXParser, teXObject);
    }

    public void parseAlignment(TeXParser teXParser, TeXObject teXObject) throws IOException {
        if (teXObject instanceof CharObject) {
            int n = ((CharObject)teXObject).getCharCode();
            this.add(new TeXCellAlign(n));
            return;
        }
        if (!(teXObject instanceof TeXObjectList)) {
            throw new TeXSyntaxException(teXParser, "tex.error.illegal_align", teXObject.toString(teXParser));
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject;
        TeXCellAlign teXCellAlign = null;
        while (teXObjectList.size() > 0) {
            TeXObject teXObject2;
            TeXObject teXObject3 = teXObjectList.popArg(teXParser);
            if (!(teXObject3 instanceof CharObject)) {
                throw new TeXSyntaxException(teXParser, "tex.error.illegal_align", teXObject.toString(teXParser));
            }
            int n = ((CharObject)teXObject3).getCharCode();
            if (n == 64 || n == 33) {
                teXObject2 = teXObjectList.popArg(teXParser);
                if (teXCellAlign == null) {
                    teXCellAlign = new TeXCellAlign(-1);
                    teXCellAlign.addBefore(teXObject2);
                    continue;
                }
                if (teXCellAlign.getAlign() == -1) {
                    teXCellAlign.addBefore(teXObject2);
                    continue;
                }
                teXCellAlign.addAfter(teXObject2);
                continue;
            }
            if (n == 62) {
                teXObject2 = teXObjectList.popArg(teXParser);
                if (teXCellAlign == null) {
                    teXCellAlign = new TeXCellAlign(-1);
                    teXCellAlign.addPreShift(teXObject2);
                    continue;
                }
                if (teXCellAlign.getAlign() == -1) {
                    teXCellAlign.addPreShift(teXObject2);
                    continue;
                }
                throw new TeXSyntaxException(teXParser, "tex.error.illegal_align", teXObject.toString(teXParser));
            }
            if (n == 124) {
                if (teXCellAlign == null) {
                    teXCellAlign = new TeXCellAlign(-1);
                }
                if (teXCellAlign.getAlign() == -1) {
                    teXCellAlign.addPreRule();
                    continue;
                }
                teXCellAlign.addPostRule();
                continue;
            }
            teXObject2 = null;
            if (this.requiresDimension(n)) {
                TeXObject teXObject4 = teXObjectList.popArg(teXParser);
                if (teXObject4 instanceof TeXDimension) {
                    teXObject2 = (TeXDimension)teXObject4;
                } else if (teXObject4 instanceof TeXObjectList) {
                    teXObject2 = ((TeXObjectList)teXObject4).popDimension(teXParser);
                } else {
                    throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", teXObject4.toString(teXParser));
                }
            }
            if (teXCellAlign == null) {
                teXCellAlign = new TeXCellAlign(n);
            } else if (teXCellAlign.getAlign() == -1) {
                teXCellAlign.setAlign(n);
            } else {
                this.add(teXCellAlign);
                teXCellAlign = new TeXCellAlign(n);
            }
            teXCellAlign.setWidth((TeXDimension)teXObject2);
        }
        if (teXCellAlign != null && teXCellAlign.getAlign() != -1) {
            this.add(teXCellAlign);
        }
    }

    public boolean requiresDimension(int n) {
        return n == 112 || n == 109 || n == 98;
    }
}

