/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.shortvrb;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class VerbChar
extends ActiveChar {
    private int codePoint;
    private boolean showSpaces;

    public VerbChar(int n) {
        this(n, false);
    }

    public VerbChar(int n, boolean bl) {
        this.codePoint = n;
        this.showSpaces = bl;
    }

    @Override
    public Object clone() {
        return new VerbChar(this.codePoint, this.showSpaces);
    }

    @Override
    public int getCharCode() {
        return this.codePoint;
    }

    public boolean visibleSpaces() {
        return this.showSpaces;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.toString();
    }

    @Override
    public String toString() {
        return new String(Character.toChars(this.codePoint));
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) {
        return null;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = teXParser.popRemainingVerb(this.codePoint);
        teXParser.getListener().verb("verb", this.showSpaces, this.codePoint, teXObjectList.toString(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        if (teXObjectList == null || teXObjectList == teXParser) {
            this.process(teXParser);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (!(teXObjectList.size() <= 0 || (teXObject = teXObjectList.pop()) instanceof ActiveChar && ((ActiveChar)teXObject).getCharCode() == this.codePoint || teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == this.codePoint)) {
            if (teXObject instanceof Comment) {
                stringBuilder.appendCodePoint(teXParser.getCommentChar());
                TeXObjectList teXObjectList2 = new TeXObjectList();
                teXParser.scan(((Comment)teXObject).getText(), teXObjectList2);
                teXObjectList.addAll(0, teXObjectList2);
                continue;
            }
            stringBuilder.append(teXObject.toString(teXParser));
        }
        teXParser.getListener().verb("verb", this.showSpaces, this.codePoint, stringBuilder.toString());
    }
}

