/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.primitives.TeXFontDeclaration;
import java.io.IOException;

public class TeXFontShapeDeclaration
extends TeXFontDeclaration {
    private int shape;
    private int orgWeight;
    private int orgFamily;
    private int orgShape;

    public TeXFontShapeDeclaration(String string, int n) {
        super(string);
        this.shape = n;
        this.orgWeight = -1;
        this.orgFamily = -1;
        this.orgShape = -1;
    }

    @Override
    public Object clone() {
        return new TeXFontShapeDeclaration(this.getName(), this.shape);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgWeight = teXSettings.getCurrentFontWeight();
        this.orgShape = teXSettings.getCurrentFontShape();
        this.orgFamily = teXSettings.getCurrentFontFamily();
        teXSettings.setFontWeight(0);
        teXSettings.setFontShape(this.shape);
        teXSettings.setFontFamily(0);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void end(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setFontWeight(this.orgWeight);
        teXSettings.setFontShape(this.orgShape);
        teXSettings.setFontFamily(this.orgFamily);
    }
}

