/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pp4;

import de.tu_darmstadt.sp.pp4.PP4Exception;
import de.tu_darmstadt.sp.pp4.PP4Handler;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class PP4hdGradBg
extends PP4Handler {
    public void doit(String command, String arguments) throws PP4Exception {
        String hashkey;
        Object resultid;
        String firstcolor;
        boolean twocolors;
        String secondcolor = null;
        if ((arguments = arguments.trim()) == null || arguments.length() < 2) {
            throw new PP4Exception(String.valueOf(command) + ": missing arguments");
        }
        boolean vertical = arguments.charAt(0) == 'v';
        boolean bl = twocolors = arguments.charAt(1) == 't';
        if (twocolors) {
            int splitpos = arguments.indexOf(47);
            if (splitpos == -1) {
                throw new PP4Exception(String.valueOf(command) + ": expect two arguments, got " + arguments);
            }
            firstcolor = arguments.substring(2, splitpos).trim();
            secondcolor = arguments.substring(splitpos + 1).trim();
        } else {
            firstcolor = arguments.substring(2).trim();
        }
        float[] bounds = this.getPagesRef().getPageBounds();
        if (PP4Handler.resulthash == null) {
            PP4Handler.resulthash = new Hashtable();
        }
        if ((resultid = PP4Handler.resulthash.get(hashkey = String.valueOf(command) + " " + arguments + " " + bounds[0] + "/" + bounds[1] + "/" + bounds[2] + "/" + bounds[3])) == null) {
            float ypos;
            float xpos;
            float[] c2;
            float val;
            String token;
            float[] c1;
            StringBuffer workarea = new StringBuffer(8192);
            StringTokenizer st = null;
            String colormodel = "";
            float deltax = 0.0f;
            float deltay = 0.0f;
            float[] cd = new float[4];
            int colorloop = 0;
            int i = 0;
            if (firstcolor.startsWith("c")) {
                if (firstcolor.charAt(1) == '\"') {
                    colormodel = "rg";
                    colorloop = 2;
                } else if (firstcolor.charAt(1) == ':') {
                    colormodel = "k";
                    colorloop = 3;
                } else {
                    throw new PP4Exception(String.valueOf(command) + ": bad color spec " + firstcolor);
                }
                c1 = this.getVTeXColors(firstcolor);
            } else {
                c1 = new float[4];
                st = new StringTokenizer(firstcolor, " \t\n\r\f");
                i = 0;
                while (i < 5) {
                    token = st.nextToken();
                    try {
                        val = Float.valueOf(token).floatValue();
                        if (i < 4) {
                            c1[i] = val;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (i == 1 && (token.equals("g") || token.equals("G"))) {
                            colormodel = "g";
                            colorloop = 0;
                            break;
                        }
                        if (i == 3 && (token.equals("rg") || token.equals("RG"))) {
                            colormodel = "rg";
                            colorloop = 2;
                            break;
                        }
                        if (i == 4 && (token.equals("k") || token.equals("K"))) {
                            colormodel = "k";
                            colorloop = 3;
                            break;
                        }
                        throw new PP4Exception(String.valueOf(command) + ": bad color spec " + firstcolor);
                    }
                    ++i;
                }
            }
            if (secondcolor == null) {
                c2 = new float[4];
                if (colormodel.equals("g")) {
                    c2[0] = (float)((double)c1[0] + (1.0 - (double)c1[0]) / 2.0);
                } else if (colormodel.equals("rg")) {
                    i = 0;
                    while (i <= colorloop) {
                        c2[i] = (float)((double)c1[i] + (1.0 - (double)c1[i]) / 2.0);
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i <= colorloop) {
                        c2[i] = (float)((double)c1[i] - (double)c1[i] / 2.0);
                        ++i;
                    }
                }
            } else {
                if (secondcolor.startsWith("c")) {
                    if (secondcolor.charAt(1) == '\"') {
                        token = "rg";
                        colorloop = 2;
                    } else if (secondcolor.charAt(1) == ':') {
                        token = "k";
                        colorloop = 3;
                    } else {
                        throw new PP4Exception(String.valueOf(command) + ": bad color spec " + secondcolor);
                    }
                    c2 = this.getVTeXColors(secondcolor);
                } else {
                    c2 = new float[4];
                    st = new StringTokenizer(secondcolor, " \t\n\r\f");
                    i = 0;
                    i = 0;
                    while (i <= colorloop) {
                        token = st.nextToken();
                        try {
                            val = Float.valueOf(token).floatValue();
                            if (i < 4) {
                                c2[i] = val;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PP4Exception(String.valueOf(command) + ": color models do not match: " + firstcolor + " vs. " + secondcolor);
                        }
                        ++i;
                    }
                    token = st.nextToken().toLowerCase();
                }
                if (!token.equals(colormodel)) {
                    throw new PP4Exception(String.valueOf(command) + ": color models do not match: " + firstcolor + " vs. " + secondcolor + "/" + token + "/" + colormodel);
                }
            }
            if (!vertical) {
                float[] tmpcolor = c2;
                c2 = c1;
                c1 = tmpcolor;
            }
            int steps = 100;
            i = 0;
            while (i <= colorloop) {
                int tmp = (int)((c2[i] - c1[i]) * 100.0f);
                if (tmp < 0) {
                    tmp = -tmp;
                }
                if (tmp > steps) {
                    steps = tmp;
                }
                ++i;
            }
            if (steps > 100) {
                steps = 100;
            }
            float floatsteps = steps;
            i = 0;
            while (i <= colorloop) {
                cd[i] = (c2[i] - c1[i]) / floatsteps;
                ++i;
            }
            if (vertical) {
                xpos = bounds[0];
                ypos = bounds[3];
                deltay = (bounds[3] - bounds[1]) / floatsteps;
                bounds[3] = -deltay;
            } else {
                ypos = bounds[1];
                xpos = bounds[2];
                deltax = (bounds[2] - bounds[0]) / floatsteps;
                bounds[2] = -deltax;
            }
            DecimalFormatSymbols usdecforms = new DecimalFormatSymbols(Locale.US);
            DecimalFormat positionformat = new DecimalFormat("0.0##", usdecforms);
            DecimalFormat colorformat = new DecimalFormat("0.0##", usdecforms);
            workarea.append(" q 1 i\n");
            int j = 0;
            while (j < steps - 1) {
                i = 0;
                while (i <= colorloop) {
                    workarea.append(" " + colorformat.format(c1[i]));
                    int n = i;
                    c1[n] = c1[n] + cd[i];
                    ++i;
                }
                workarea.append(" " + colormodel + " " + positionformat.format(xpos) + " " + positionformat.format(ypos) + " " + positionformat.format(bounds[2]) + " " + positionformat.format(bounds[3]) + " re f\n");
                ypos -= deltay;
                xpos -= deltax;
                ++j;
            }
            i = 0;
            while (i <= colorloop) {
                workarea.append(" " + colorformat.format(c1[i]));
                ++i;
            }
            workarea.append(" " + colormodel + " " + positionformat.format(xpos) + " " + positionformat.format(ypos) + " " + positionformat.format(bounds[2]) + " " + positionformat.format(bounds[3]) + " re f\n");
            i = 0;
            while (i <= colorloop) {
                workarea.append(" " + colorformat.format(c1[i]));
                ++i;
            }
            if (vertical) {
                workarea.append(" " + colormodel + " " + positionformat.format(xpos) + " " + positionformat.format(ypos) + " " + positionformat.format(bounds[2]) + " " + positionformat.format(deltay) + " re f Q\n");
            } else {
                workarea.append(" " + colormodel + " " + positionformat.format(xpos) + " " + positionformat.format(ypos) + " " + positionformat.format(deltax) + " " + positionformat.format(bounds[3]) + " re f Q\n");
            }
            resultid = this.getPagesRef().makeStream(workarea.toString());
            PP4Handler.resulthash.put(hashkey, resultid);
        }
        this.getPagesRef().addBgStream(resultid);
    }

    float[] getVTeXColors(String txt) throws PP4Exception {
        long color;
        float[] args = new float[4];
        int len = 1;
        if (txt.charAt(1) == '\"') {
            len = 3;
        } else if (txt.charAt(1) == ':') {
            len = 4;
        } else {
            throw new PP4Exception("Bad VTeX color specification in " + txt);
        }
        try {
            color = Integer.parseInt(txt.substring(2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PP4Exception("Invalid hex value in " + txt);
        }
        int i = len;
        while (i > 0) {
            args[--i] = (float)((double)(color % 256L) / 255.0);
            color /= 256L;
        }
        return args;
    }

    public String pattern() {
        return "%gradbackground";
    }
}

