/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.ITextEditor;

public class BibStringCompleter
implements IDocumentListener {
    private ITextEditor editor;
    private IDocument document;
    private boolean recentlyAdded = false;

    public BibStringCompleter(ITextEditor editor) {
        this.editor = editor;
        this.document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("bibString")) {
            if ("{".equals(event.getText())) {
                ITextSelection textSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
                try {
                    this.document.replace(textSelection.getOffset() + 0, 1, "}");
                }
                catch (BadLocationException badLocationException) {}
            } else if ("\"".equals(event.getText()) && !this.recentlyAdded) {
                ITextSelection textSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
                try {
                    this.recentlyAdded = true;
                    this.document.replace(textSelection.getOffset() + 1, 0, "\"");
                }
                catch (BadLocationException badLocationException) {}
                this.recentlyAdded = false;
            }
        }
    }
}

