/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.TexlipseNature;
import net.sourceforge.texlipse.editor.TexDocumentSetupParticipant;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.wizards.TexlipseProjectCreationOperation;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class TexDocumentProvider
extends TextFileDocumentProvider {
    public TexDocumentProvider() {
        TextFileDocumentProvider provider = new TextFileDocumentProvider();
        provider = new ForwardingDocumentProvider("__tex_partitioning", (IDocumentSetupParticipant)new TexDocumentSetupParticipant(), (IDocumentProvider)provider);
        this.setParentDocumentProvider((IDocumentProvider)provider);
    }

    public IDocument getDocument(Object element) {
        IFile file;
        IDocument doc = super.getDocument(element);
        if (element instanceof FileEditorInput && (file = (IFile)((FileEditorInput)element).getAdapter(IFile.class)) != null) {
            IProject project = file.getProject();
            try {
                if (!project.hasNature(TexlipseNature.NATURE_ID)) {
                    TexlipseProjectCreationOperation.addProjectNature(project, (IProgressMonitor)new NullProgressMonitor());
                } else if (TexlipseProperties.getProjectProperty((IResource)project, "outputFormat") == null) {
                    TexlipseNature n = new TexlipseNature();
                    n.setProject(project);
                    n.configure();
                }
            }
            catch (CoreException coreException) {
                return doc;
            }
            String format = TexlipseProperties.getProjectProperty((IResource)project, "outputFormat");
            if (format == null || format.length() == 0) {
                TexlipseProperties.setProjectProperty((IResource)project, "outputFormat", TexlipsePlugin.getPreference("outputFormat"));
                TexlipseProperties.setProjectProperty((IResource)project, "builderNum", TexlipsePlugin.getPreference("builderNum"));
                TexlipseProperties.setProjectProperty((IResource)project, "markTmpDer", "true");
                TexlipseProperties.setProjectProperty((IResource)project, "markDer", "true");
                String name = file.getName();
                TexlipseProperties.setProjectProperty((IResource)project, "mainTexFile", name);
                String output = String.valueOf(name.substring(0, name.lastIndexOf(46) + 1)) + TexlipsePlugin.getPreference("outputFormat");
                TexlipseProperties.setProjectProperty((IResource)project, "outputFile", output);
                IPath path = file.getFullPath();
                String dir = path.removeFirstSegments(1).removeLastSegments(1).toString();
                if (dir.length() > 0) {
                    TexlipseProperties.setProjectProperty((IResource)project, "srcDir", dir);
                    TexlipseProperties.setProjectProperty((IResource)project, "outputDir", dir);
                    TexlipseProperties.setProjectProperty((IResource)project, "tempDir", dir);
                }
            }
        }
        return doc;
    }
}

