/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexlipseProperties {
    public static final String PACKAGE_NAME = TexlipsePlugin.class.getPackage().getName();
    public static final String LATEX_PROJECT_SETTINGS_FILE = ".texlipse";
    public static final String MAINFILE_PROPERTY = "mainTexFile";
    public static final String OUTPUTFILE_PROPERTY = "outputFile";
    public static final String BIBFILE_PROPERTY = "bibFiles";
    public static final String BIBSTYLE_PROPERTY = "bibStyle";
    public static final String SESSION_BIBLATEXMODE_PROPERTY = "biblatexMode";
    public static final String SESSION_BIBLATEXBACKEND_PROPERTY = "biblatexBackend";
    public static final String SESSION_BIBLATEXLOCALBIB_PROPERTY = "biblatexLocalBib";
    public static final String PREAMBLE_PROPERTY = "preamble";
    public static final String PARTIAL_BUILD_PROPERTY = "partialBuild";
    public static final String PARTIAL_BUILD_FILE = "partialFile";
    public static final String BIBFILES_CHANGED = "bibFilesChanged";
    public static final String FORCED_REBUILD = "forcedRebuild";
    public static final String OUTPUT_DIR_PROPERTY = "outputDir";
    public static final String SOURCE_DIR_PROPERTY = "srcDir";
    public static final String TEMP_DIR_PROPERTY = "tempDir";
    public static final String BIBREF_DIR_PROPERTY = "bibrefDir";
    public static final String MARK_OUTPUT_DERIVED_PROPERTY = "markDer";
    public static final String MARK_TEMP_DERIVED_PROPERTY = "markTmpDer";
    public static final String LANGUAGE_PROPERTY = "langSpell";
    public static final String MAKEINDEX_STYLEFILE_PROPERTY = "makeIndSty";
    public static final String BIBCONTAINER_PROPERTY = "bibContainer";
    public static final String LABELCONTAINER_PROPERTY = "labelContainer";
    public static final String COMCONTAINER_PROPERTY = "commandContainer";
    public static final String BIB_DIR = "bibDir";
    public static final String TEMP_FILE_EXTS = "tempFileExts";
    public static final String DERIVED_FILES = "derivedFiles";
    public static final String FILE_LOCATION_PORT = "fileLocPort";
    public static final String BUILD_ENV_SETTINGS = "buildEnvSet";
    public static final String VIEWER_ENV_SETTINGS = "viewerEnvSet";
    public static final String TEX_COMPLETION = "texCompletion";
    public static final String TEX_COMPLETION_DELAY = "texDelay";
    public static final String TEX_ITEM_COMPLETION = "texItemCompletion";
    public static final String AUTO_PARSING = "autoParsing";
    public static final String AUTO_PARSING_DELAY = "autoParsingDelay";
    public static final String SECTION_CHECK = "sectionCheck";
    public static final String BIB_COMPLETION = "bibCompletion";
    public static final String BIB_COMPLETION_DELAY = "bibDelay";
    public static final String BIB_FREQSORT = "bibFreqSort";
    public static final String BIB_CODE_FOLDING = "bibCodeFolding";
    public static final String BIB_FOLD_INITIAL = "bibFoldInitial";
    public static final String BIB_STRING = "bibString";
    public static final String INDENTATION = "indent";
    public static final String INDENTATION_LEVEL = "indentLevel";
    public static final String INDENTATION_TABS = "indentTabs";
    public static final String INDENTATION_ENVS = "indentEnvs";
    public static final String WORDWRAP_TYPE = "wrapType";
    public static final String WORDWRAP_LENGTH = "lineLength";
    public static final String WORDWRAP_TYPE_NONE = "none";
    public static final String WORDWRAP_TYPE_SOFT = "soft";
    public static final String WORDWRAP_TYPE_HARD = "hard";
    public static final String WORDWRAP_DEFAULT = "wrapDefault";
    public static final String SMART_KEY_ENABLE = "ske";
    public static final String STYLE_COMPLETION_SETTINGS = "styleCompletionSet";
    public static final String SMART_BACKSPACE = "smartBackspace";
    public static final String SMART_LDOTS = "smartLdots";
    public static final String SMART_PARENS = "texBracketCompletion";
    public static final String TEX_BRACKET_COMLETION_VALUE = "true";
    public static final String SMART_QUOTES = "texReplaceQuotes";
    public static final String TEX_REPLACE_QUOTES_VALUE = "true";
    public static final String TEX_EDITOR_ANNOTATATIONS = "textEditorAnnotations";
    public static final String CODE_FOLDING = "codeFolding";
    public static final String CODE_FOLDING_PREAMBLE = "codeFoldingPreamble";
    public static final String CODE_FOLDING_PART = "codeFoldingPart";
    public static final String CODE_FOLDING_CHAPTER = "codeFoldingChapter";
    public static final String CODE_FOLDING_SECTION = "codeFoldingSection";
    public static final String CODE_FOLDING_SUBSECTION = "codeFoldingSubSection";
    public static final String CODE_FOLDING_SUBSUBSECTION = "codeFoldingSubSubSection";
    public static final String CODE_FOLDING_PARAGRAPH = "codeFoldingParagraph";
    public static final String CODE_FOLDING_ENVS = "codeFoldingEnvs";
    public static final String OUTLINE_PREAMBLE = "outlinePreamble";
    public static final String OUTLINE_PART = "outlinePart";
    public static final String OUTLINE_CHAPTER = "outlineChapter";
    public static final String OUTLINE_SECTION = "outlineSection";
    public static final String OUTLINE_SUBSECTION = "outlineSubSection";
    public static final String OUTLINE_SUBSUBSECTION = "outlineSubSubSection";
    public static final String OUTLINE_PARAGRAPH = "outlineParagraph";
    public static final String OUTLINE_ENVS = "outlineEnvs";
    public static final String BUILDER_NUMBER = "builderNum";
    public static final String BUILDER_CONSOLE_OUTPUT = "builderConsole";
    public static final String BUILD_BEFORE_VIEW = "buildBeforeView";
    public static final String BUILDER_RETURN_FOCUS = "returnFocusOnPreivew";
    public static final String BUILDER_PARSE_AUX_FILES = "builderParseAuxFiles";
    public static final String BUILDER_FORCE_RETURN_FOCUS = "forceReturnFocusOnInverseSearch";
    public static final String OUTPUT_FORMAT = "outputFormat";
    public static final String OUTPUT_FORMAT_AUX = "aux";
    public static final String INPUT_FORMAT_BIB = "bib";
    public static final String INPUT_FORMAT_IDX = "idx";
    public static final String OUTPUT_FORMAT_IDX = "ind";
    public static final String INPUT_FORMAT_BCF = "bcf";
    public static final String OUTPUT_FORMAT_BBL = "bbl";
    public static final String INPUT_FORMAT_NOMENCL = "nlo";
    public static final String OUTPUT_FORMAT_NOMENCL = "nls";
    public static final String INPUT_FORMAT_TEX = "tex";
    public static final String OUTPUT_FORMAT_DVI = "dvi";
    public static final String OUTPUT_FORMAT_PS = "ps";
    public static final String OUTPUT_FORMAT_PDF = "pdf";
    public static final String SESSION_BIBTEX_RERUN = "rerunBibtex";
    public static final String SESSION_LATEX_RERUN = "rerunLatex";
    public static final String SESSION_MAKEINDEX_RERUN = "rerunMakeindex";
    public static final String SESSION_PROPERTIES_LOAD = "propsLoaded";
    public static final String SESSION_ATTRIBUTE_VIEWER = "active.viewer";
    public static final String SESSION_PROJECT_FULLOUTLINE = "project.fullTexParser";
    public static final String ECLIPSE_BUILDIN_SPELLCHECKER = "eclipseBuildInSpellChecker";
    public static final String SPELLCHECKER_DICT_DIR = "spellcheckerDictDir";
    public static final String SPELLCHECKER_CUSTOM_DICT_DIR = "spellcheckerCustomDictDir";
    public static final String SPELLCHECKER_IGNORE_COMMENTS = "spellcheckerIgnoreComments";
    public static final String SPELLCHECKER_IGNORE_MATH = "spellcheckerIgnoreMath";
    public static final String SPELLCHECKER_IGNORE_MIXED_CASE = "spellcheckerIgnoreMixedCase";
    public static final String MATCHING_BRACKETS = "matchingBrackets";
    public static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";

    public static String getFileContents(IResource resource) throws IOException {
        if (resource.getType() != 1) {
            return null;
        }
        File f = resource.getLocation().toFile();
        FileInputStream in = new FileInputStream(f);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int len = 0;
        while ((len = in.read(buff)) == buff.length) {
            out.write(buff);
        }
        if (len > 0) {
            out.write(buff, 0, len);
        }
        in.close();
        String contents = null;
        try {
            contents = out.toString(((IFile)resource).getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            contents = out.toString();
        }
        catch (CoreException coreException) {}
        out.close();
        return contents;
    }

    public static IResource[] getAllProjectFiles(IProject project) {
        IContainer sourceDir = TexlipseProperties.getProjectSourceDir(project);
        return TexlipseProperties.getAllMemberFiles(sourceDir, new String[]{INPUT_FORMAT_TEX, "ltx", INPUT_FORMAT_BIB, INPUT_FORMAT_IDX}).toArray(new IResource[0]);
    }

    public static List<IResource> getAllMemberFiles(IContainer dir, String[] exts) {
        ArrayList<IResource> list = new ArrayList<IResource>();
        IResource[] arr = null;
        try {
            arr = dir.members();
        }
        catch (CoreException coreException) {}
        int i = 0;
        while (arr != null && i < arr.length) {
            if (arr[i].getType() == 2) {
                list.addAll(TexlipseProperties.getAllMemberFiles((IContainer)((IFolder)arr[i]), exts));
            } else {
                int j = 0;
                while (j < exts.length) {
                    if (exts[j].equals(arr[i].getFileExtension())) {
                        list.add(arr[i]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list;
    }

    public static String getOutputFileName(IProject project) {
        IFile tmpFile;
        String outputFileName = TexlipseProperties.getProjectProperty((IResource)project, OUTPUTFILE_PROPERTY);
        String s = TexlipseProperties.getProjectProperty((IResource)project, PARTIAL_BUILD_PROPERTY);
        if (s != null && (tmpFile = (IFile)TexlipseProperties.getSessionProperty((IResource)project, PARTIAL_BUILD_FILE)) != null) {
            String fmtProp = TexlipseProperties.getProjectProperty((IResource)project, OUTPUT_FORMAT);
            String name = tmpFile.getName();
            outputFileName = name = String.valueOf(name.substring(0, name.lastIndexOf(46))) + "." + fmtProp;
        }
        return outputFileName;
    }

    public static IFile getProjectSourceFile(IProject project) {
        String dir = TexlipseProperties.getProjectProperty((IResource)project, SOURCE_DIR_PROPERTY);
        String mainFile = TexlipseProperties.getProjectProperty((IResource)project, MAINFILE_PROPERTY);
        if (mainFile != null) {
            if (dir != null && dir.length() > 0) {
                return project.getFolder(dir).getFile(mainFile);
            }
            return project.getFile(mainFile);
        }
        return null;
    }

    public static IContainer getProjectSourceDir(IProject project) {
        String dir = TexlipseProperties.getProjectProperty((IResource)project, SOURCE_DIR_PROPERTY);
        if (dir != null && dir.length() > 0) {
            return project.getFolder(dir);
        }
        return project;
    }

    public static IFile getProjectOutputFile(IProject project) {
        IFolder folder = TexlipseProperties.getProjectOutputDir(project);
        if (folder == null) {
            return project.getFile(TexlipseProperties.getProjectProperty((IResource)project, OUTPUTFILE_PROPERTY));
        }
        return folder.getFile(TexlipseProperties.getProjectProperty((IResource)project, OUTPUTFILE_PROPERTY));
    }

    public static IFolder getProjectOutputDir(IProject project) {
        String dir = TexlipseProperties.getProjectProperty((IResource)project, OUTPUT_DIR_PROPERTY);
        if (dir != null && dir.length() > 0) {
            return project.getFolder(dir);
        }
        return null;
    }

    public static IFolder getProjectTempDir(IProject project) {
        String dir = TexlipseProperties.getProjectProperty((IResource)project, TEMP_DIR_PROPERTY);
        if (dir != null && dir.length() > 0) {
            return project.getFolder(dir);
        }
        return null;
    }

    public static void loadProjectProperties(IProject project) {
        IFile settingsFile = project.getFile(LATEX_PROJECT_SETTINGS_FILE);
        if (!settingsFile.exists()) {
            return;
        }
        Properties prop = new Properties();
        try {
            prop.load(settingsFile.getContents());
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Loading project property file", e);
            return;
        }
        catch (IOException e) {
            TexlipsePlugin.log("Loading project property file", e);
            return;
        }
        TexlipseProperties.setSessionProperty((IResource)project, SESSION_PROPERTIES_LOAD, System.currentTimeMillis());
        TexlipseProperties.setProjectProperty((IResource)project, MAINFILE_PROPERTY, prop.getProperty(MAINFILE_PROPERTY, ""));
        TexlipseProperties.setProjectProperty((IResource)project, OUTPUTFILE_PROPERTY, prop.getProperty(OUTPUTFILE_PROPERTY, ""));
        TexlipseProperties.setProjectProperty((IResource)project, SOURCE_DIR_PROPERTY, prop.getProperty(SOURCE_DIR_PROPERTY, ""));
        TexlipseProperties.setProjectProperty((IResource)project, OUTPUT_DIR_PROPERTY, prop.getProperty(OUTPUT_DIR_PROPERTY, ""));
        TexlipseProperties.setProjectProperty((IResource)project, TEMP_DIR_PROPERTY, prop.getProperty(TEMP_DIR_PROPERTY, ""));
        TexlipseProperties.setProjectProperty((IResource)project, BIBREF_DIR_PROPERTY, prop.getProperty(BIBREF_DIR_PROPERTY, ""));
        TexlipseProperties.setProjectProperty((IResource)project, BUILDER_NUMBER, prop.getProperty(BUILDER_NUMBER, ""));
        TexlipseProperties.setProjectProperty((IResource)project, OUTPUT_FORMAT, prop.getProperty(OUTPUT_FORMAT, ""));
        TexlipseProperties.setProjectProperty((IResource)project, MARK_TEMP_DERIVED_PROPERTY, prop.getProperty(MARK_TEMP_DERIVED_PROPERTY, "true"));
        TexlipseProperties.setProjectProperty((IResource)project, MARK_OUTPUT_DERIVED_PROPERTY, prop.getProperty(MARK_OUTPUT_DERIVED_PROPERTY, "true"));
        TexlipseProperties.setProjectProperty((IResource)project, LANGUAGE_PROPERTY, prop.getProperty(LANGUAGE_PROPERTY, ""));
        TexlipseProperties.setProjectProperty((IResource)project, MAKEINDEX_STYLEFILE_PROPERTY, prop.getProperty(MAKEINDEX_STYLEFILE_PROPERTY, ""));
    }

    public static void saveProjectProperties(IProject project) {
        IFile settingsFile = project.getFile(LATEX_PROJECT_SETTINGS_FILE);
        if (settingsFile.isReadOnly()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    MessageDialog dialog = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), TexlipsePlugin.getResourceString("projectSettingsReadOnlyTitle"), null, TexlipsePlugin.getResourceString("projectSettingsReadOnly"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dialog.open();
                }
            });
            return;
        }
        Properties prop = new Properties();
        prop.setProperty(MAINFILE_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, MAINFILE_PROPERTY));
        prop.setProperty(OUTPUTFILE_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, OUTPUTFILE_PROPERTY));
        prop.setProperty(SOURCE_DIR_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, SOURCE_DIR_PROPERTY));
        prop.setProperty(OUTPUT_DIR_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, OUTPUT_DIR_PROPERTY));
        prop.setProperty(TEMP_DIR_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, TEMP_DIR_PROPERTY));
        prop.setProperty(BIBREF_DIR_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, BIBREF_DIR_PROPERTY));
        prop.setProperty(BUILDER_NUMBER, TexlipseProperties.getProjectProperty((IResource)project, BUILDER_NUMBER));
        prop.setProperty(OUTPUT_FORMAT, TexlipseProperties.getProjectProperty((IResource)project, OUTPUT_FORMAT));
        prop.setProperty(MARK_TEMP_DERIVED_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, MARK_TEMP_DERIVED_PROPERTY));
        prop.setProperty(MARK_OUTPUT_DERIVED_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, MARK_OUTPUT_DERIVED_PROPERTY));
        prop.setProperty(LANGUAGE_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, LANGUAGE_PROPERTY));
        prop.setProperty(MAKEINDEX_STYLEFILE_PROPERTY, TexlipseProperties.getProjectProperty((IResource)project, MAKEINDEX_STYLEFILE_PROPERTY));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            prop.store(baos, "TeXlipse project settings");
        }
        catch (IOException iOException) {}
        NullProgressMonitor mon = new NullProgressMonitor();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            if (settingsFile.exists()) {
                settingsFile.setContents((InputStream)bais, true, false, (IProgressMonitor)mon);
            } else {
                settingsFile.create((InputStream)bais, true, (IProgressMonitor)mon);
            }
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Saving project property file", e);
        }
    }

    public static boolean isProjectPropertiesFileChanged(IProject project) {
        IResource settingsFile = project.findMember(LATEX_PROJECT_SETTINGS_FILE);
        if (settingsFile == null) {
            return false;
        }
        Long lastLoadTime = (Long)TexlipseProperties.getSessionProperty((IResource)project, SESSION_PROPERTIES_LOAD);
        if (lastLoadTime == null) {
            return true;
        }
        long timeStamp = settingsFile.getLocalTimeStamp();
        return timeStamp > lastLoadTime;
    }

    public static String getProjectProperty(IResource project, String property) {
        String value = null;
        try {
            value = project.getPersistentProperty(new QualifiedName(PACKAGE_NAME, property));
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static void setProjectProperty(IResource project, String property, String value) {
        try {
            project.setPersistentProperty(new QualifiedName(PACKAGE_NAME, property), value);
        }
        catch (CoreException coreException) {}
    }

    public static Object getSessionProperty(IResource project, String property) {
        Object value = null;
        try {
            value = project.getSessionProperty(new QualifiedName(PACKAGE_NAME, property));
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static void setSessionProperty(IResource project, String property, Object value) {
        try {
            project.setSessionProperty(new QualifiedName(PACKAGE_NAME, property), value);
        }
        catch (CoreException coreException) {}
    }
}

