/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.viewer.ViewerAttributeRegistry;
import net.sourceforge.texlipse.viewer.ViewerConfigDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public class ViewerListFieldEditor
extends ListEditor {
    public static final String SEPARATOR = ",";
    private ViewerAttributeRegistry registry;
    private ArrayList nameList = new ArrayList();
    private Button editButton;
    private Composite parent;

    public ViewerListFieldEditor(String labelText, Composite parent) {
        super("viewerNames.TEMP", labelText, parent);
        this.registry = new ViewerAttributeRegistry();
    }

    protected void doLoad() {
        super.doLoad();
        this.registry.load(this.getPreferenceStore());
        List list = this.getListControl(this.parent);
        list.setItems(this.addPaths(TexlipsePlugin.getPreferenceArray("viewerNames")));
    }

    protected void doLoadDefault() {
        super.doLoadDefault();
        this.registry = new ViewerAttributeRegistry();
        List list = this.getListControl(this.parent);
        list.setItems(this.addPaths(TexlipsePlugin.getPreferenceArray("viewerNames")));
    }

    private String[] addPaths(String[] items) {
        String oldViewer = this.registry.getActiveViewer();
        String[] array = new String[items.length];
        int i = 0;
        while (i < items.length) {
            this.registry.setActiveViewer(items[i]);
            array[i] = String.valueOf(items[i]) + " (" + this.registry.getCommand() + ")";
            ++i;
        }
        this.registry.setActiveViewer(oldViewer);
        return array;
    }

    protected void doStore() {
        super.doStore();
        List list = this.getListControl(this.parent);
        String[] trueNames = this.removePaths(list.getItems());
        this.registry.setActiveViewer(trueNames[0]);
        this.registry.save(this.getPreferenceStore(), trueNames);
    }

    private String[] removePaths(String[] items) {
        String[] array = new String[items.length];
        int i = 0;
        while (i < items.length) {
            array[i] = items[i].substring(0, items[i].indexOf(40) - 1);
            ++i;
        }
        return array;
    }

    protected Button createEditButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(TexlipsePlugin.getResourceString("openEdit"));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        data.heightHint = this.convertVerticalDLUsToPixels((Control)button, 14);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ViewerListFieldEditor.this.openEditorDialog();
            }
        });
        return button;
    }

    private void openEditorDialog() {
        List list = this.getListControl(this.parent);
        int index = list.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String name = list.getItem(index);
        if (name == null || name.length() == 0) {
            return;
        }
        this.registry.setActiveViewer(name.substring(0, name.indexOf(40) - 1));
        ViewerConfigDialog dialog = new ViewerConfigDialog(this.editButton.getShell(), (ViewerAttributeRegistry)this.registry.clone());
        int code = dialog.open();
        if (code == 0) {
            this.registry.mergeWith(dialog.getRegistry());
            list.setItem(index, String.valueOf(this.registry.getActiveViewer()) + " (" + this.registry.getCommand() + ")");
        }
    }

    public Composite getButtonBoxControl(Composite parent) {
        Composite box = super.getButtonBoxControl(parent);
        if (this.editButton == null) {
            this.parent = parent;
            this.editButton = this.createEditButton(box);
        }
        return box;
    }

    public List getListControl(Composite parent) {
        List list = super.getListControl(parent);
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                List listWidget = (List)event.widget;
                ViewerListFieldEditor.this.editButton.setEnabled(listWidget.getSelectionIndex() >= 0);
            }
        });
        return list;
    }

    protected String createList(String[] items) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < items.length - 1) {
            sb.append(items[i]);
            sb.append(SEPARATOR);
            ++i;
        }
        sb.append(items[items.length - 1]);
        this.nameList.clear();
        this.nameList.addAll(Arrays.asList(items));
        return sb.toString();
    }

    protected String getNewInputObject() {
        ViewerConfigDialog dialog = new ViewerConfigDialog(this.getLabelControl().getShell(), this.nameList);
        int code = dialog.open();
        if (code == 0) {
            ViewerAttributeRegistry reg = dialog.getRegistry();
            String name = reg.getActiveViewer();
            this.nameList.add(name);
            this.registry.mergeWith(reg);
            return String.valueOf(name) + " (" + reg.getCommand() + ")";
        }
        return null;
    }

    protected String[] parseString(String stringList) {
        String[] arr = stringList.split(SEPARATOR);
        this.nameList.clear();
        this.nameList.addAll(Arrays.asList(arr));
        return arr;
    }
}

