#include "main.h"

extern struct VideoBase *VideoBase;

static struct Gadget *gadhandler( struct Gadget *, struct Gadget *,
    unsigned, unsigned, unsigned long );
static void _setdefpalette( struct Gadget *, struct Request * );
static void _drawcolors( struct Gadget *, struct Request *, unsigned int, unsigned int );
static void _changecolors( struct Gadget *, struct Request * );

static char *CODEBASED colornames[] = {
    "Text",                 "Mark",                 "TextHilite",
    "HelpText",             "HelpButton",           "HelpBoldface",
    "HelpItalic",           "Menu",                 "MenuBar",
    "MenuHotKey",           "MenuBarHot",           "MenuDisable",
    "Window",               "Border",               "WindowText",
    "Shadow",               "BoolGadget",           "BoolGadgetSelect",
    "TextGadget",           "TextGadgetActivated",  "GadgetHotKey",
    "GadgetSelectedHot",    "List",                 "ListBar",
    "ListHilite",           "ListItalic",           "ListKnob",
    "ListKnobSelect",       "GadgetDisable",        "ErrorWindow",
    "ErrorGadget",          "ErrorGadgetSelect",    "ErrorGadgetHot",
    "ErrorGadgetSelectHot", "Status",               "StatusHilite",
    "StatusError",          "Flag",                 "FlagDisable",
    "FlagHilite",           "DOS"
  };

static char *CODEBASED palette_name[] = {
    "Standard", "Monochrome", "Ocean", "Dja vu", "Neon" };

static unsigned char CODEBASED default_palette[][CR_MAXVAL] = {
  {

  /* Old Fashion */

    0x70    /*  BLACK       WHITE           */ ,
    0x4f    /*  BRIGHTWHITE RED             */ ,
    0x74    /*  RED         WHITE           */ ,
    0x3f    /*  BRIGHTWHITE CYAN            */ ,
    0x3e    /*  YELLOW      CYAN            */ ,
    0x30    /*  BLACK       CYAN            */ ,
    0x38    /*  GRAY        CYAN            */ ,
    0x3f    /*  BRIGHTWHITE CYAN            */ ,
    0x4f    /*  BRIGHTWHITE RED             */ ,
    0x34    /*  RED         CYAN            */ ,
    0x4c    /*  LIGHTRED    RED             */ ,
    0x38    /*  GRAY        CYAN            */ ,
    0x3f    /*  BRIGHTWHITE CYAN            */ ,
    0x3f    /*  BRIGHTWHITE CYAN            */ ,
    0x3f    /*  BRIGHTWHITE CYAN            */ ,
    0x80    /*  BLACK       GRAY            */ ,
    0x3f    /*  BRIGHTWHITE CYAN            */ ,
    0x43    /*  CYAN        RED             */ ,
    0x0f    /*  BRIGHTWHITE BLACK           */ ,
    0x70    /*  BLACK       WHITE           */ ,
    0x34    /*  RED         CYAN            */ ,
    0x4c    /*  LIGHTRED    RED             */ ,
    0x07    /*  WHITE       BLACK           */ ,
    0x70    /*  BLACK       WHITE           */ ,
    0x0f    /*  BRIGHTWHITE BLACK           */ ,
    0x0e    /*  YELLOW      BLACK           */ ,
    0x70    /*  BLACK       WHITE           */ ,
    0x40    /*  BLACK       RED             */ ,
    0x38    /*  GRAY        CYAN            */ ,
    0x4f    /*  BRIGHTWHITE RED             */ ,
    0x4f    /*  BRIGHTWHITE RED             */ ,
    0xf4    /*  RED         BRIGHTWHITE     */ ,
    0x84    /*  CYAN        RED             */ ,
    0xfc    /*  RED         LIGHTRED        */ ,
    0x78    /*  GRAY        WHITE           */ ,
    0x3f    /*  BRIGHTWHITE CYAN            */ ,
    0x74    /*  RED         WHITE           */ ,
    0x3f    /*  BRIGHTWHITE CYAN            */ ,
    0x38    /*  GRAY        CYAN            */ ,
    0x34    /*  RED         CYAN            */ ,
    0x0f    /*  BRIGHTWHITE BLACK           */
  },{

    /* Monochrome Setup */

/*                 Text */ 0x07,
/*                 Mark */ 0x70,
/*           TextHilite */ 0x0f,
/*             HelpText */ 0x78,
/*           HelpButton */ 0x7f,
/*         HelpBoldface */ 0x70,
/*           HelpItalic */ 0x7e,
/*                 Menu */ 0x70,
/*              MenuBar */ 0x07,
/*           MenuHotKey */ 0x7f,
/*           MenuBarHot */ 0x0f,
/*          MenuDisable */ 0x78,
/*               Window */ 0x7f,
/*               Border */ 0x78,
/*           WindowText */ 0x7f,
/*               Shadow */ 0x08,
/*           BoolGadget */ 0x7f,
/*     BoolGadgetSelect */ 0x07,
/*           TextGadget */ 0x0f,
/*  TextGadgetActivated */ 0x70,
/*         GadgetHotKey */ 0x70,
/*    GadgetSelectedHot */ 0x0f,
/*                 List */ 0x07,
/*              ListBar */ 0x70,
/*           ListHilite */ 0x0f,
/*           ListItalic */ 0x0e,
/*             ListKnob */ 0x70,
/*       ListKnobSelect */ 0x40,
/*        GadgetDisable */ 0x78,
/*          ErrorWindow */ 0x4f,
/*          ErrorGadget */ 0x4f,
/*    ErrorGadgetSelect */ 0xf4,
/*       ErrorGadgetHot */ 0x40,
/* ErrorGadgetSelectHot */ 0xfc,
/*               Status */ 0x0f,
/*         Statushilite */ 0x70,
/*          StatusError */ 0x04,
/*                 Flag */ 0x7f,
/*          FlagDisable */ 0x78,
/*           FlagHilite */ 0x74,
/*                  DOS */ 0x0f,
    },{

    /* Ocean */

/*                 Text */ 0x17,
/*                 Mark */ 0x21,
/*           TextHilite */ 0x1c,
/*             HelpText */ 0x7f,
/*           HelpButton */ 0x7e,
/*         HelpBoldface */ 0x70,
/*           HelpItalic */ 0x79,
/*                 Menu */ 0xb0,
/*              MenuBar */ 0xa0,
/*           MenuHotKey */ 0xbc,
/*           MenuBarHot */ 0xac,
/*          MenuDisable */ 0xb8,
/*               Window */ 0x90,
/*               Border */ 0x90,
/*           WindowText */ 0x90,
/*               Shadow */ 0x80,
/*           BoolGadget */ 0x9f,
/*     BoolGadgetSelect */ 0x49,
/*           TextGadget */ 0x1f,
/*  TextGadgetActivated */ 0x70,
/*         GadgetHotKey */ 0x96,
/*    GadgetSelectedHot */ 0x4c,
/*                 List */ 0x17,
/*              ListBar */ 0x70,
/*           ListHilite */ 0x1f,
/*           ListItalic */ 0x1e,
/*             ListKnob */ 0x62,
/*       ListKnobSelect */ 0x40,
/*        GadgetDisable */ 0x98,
/*          ErrorWindow */ 0x4f,
/*          ErrorGadget */ 0x4f,
/*    ErrorGadgetSelect */ 0xf4,
/*       ErrorGadgetHot */ 0x40,
/* ErrorGadgetSelectHot */ 0xfc,
/*               Status */ 0xb0,
/*         StatusHilite */ 0x20,
/*          StatusError */ 0xb4,
/*                 Flag */ 0xbf,
/*          FlagDisable */ 0xb8,
/*           FlagHilite */ 0xb4,
/*                  DOS */ 0x0f,

    },{

    /* Deja vu */

/*                 Text */ 0x17,
/*                 Mark */ 0x71,
/*           TextHilite */ 0x1f,
/*             HelpText */ 0x7f,
/*           HelpButton */ 0x7e,
/*         HelpBoldface */ 0x70,
/*           HelpItalic */ 0x79,
/*                 Menu */ 0x70,
/*              MenuBar */ 0x07,
/*           MenuHotKey */ 0x7f,
/*           MenuBarHot */ 0x0f,
/*          MenuDisable */ 0x78,
/*               Window */ 0x70,
/*               Border */ 0x70,
/*           WindowText */ 0x70,
/*               Shadow */ 0x80,
/*           BoolGadget */ 0x70,
/*     BoolGadgetSelect */ 0x07,
/*           TextGadget */ 0x87,
/*  TextGadgetActivated */ 0x70,
/*         GadgetHotKey */ 0x7f,
/*    GadgetSelectedHot */ 0x0f,
/*                 List */ 0x70,
/*              ListBar */ 0x07,
/*           ListHilite */ 0x7f,
/*           ListItalic */ 0x7e,
/*             ListKnob */ 0x70,
/*       ListKnobSelect */ 0x40,
/*        GadgetDisable */ 0x78,
/*          ErrorWindow */ 0x40,
/*          ErrorGadget */ 0x40,
/*    ErrorGadgetSelect */ 0xf4,
/*       ErrorGadgetHot */ 0x40,
/* ErrorGadgetSelectHot */ 0xfc,
/*               Status */ 0x70,
/*         StatusHilite */ 0x3f,
/*          StatusError */ 0x74,
/*                 Flag */ 0x7f,
/*          FlagDisable */ 0x78,
/*           FlagHilite */ 0x74,
/*                  DOS */ 0x0f,

    },{

/* Neon */

/*                 Text */ 0x30,
/*                 Mark */ 0xc0,
/*           TextHilite */ 0x3c,
/*             HelpText */ 0xdf,
/*           HelpButton */ 0xde,
/*         HelpBoldface */ 0xd0,
/*           HelpItalic */ 0xd7,
/*                 Menu */ 0xa0,
/*              MenuBar */ 0x57,
/*           MenuHotKey */ 0xac,
/*           MenuBarHot */ 0x5f,
/*          MenuDisable */ 0xa8,
/*               Window */ 0xde,
/*               Border */ 0xdd,
/*           WindowText */ 0xde,
/*               Shadow */ 0x07,
/*           BoolGadget */ 0xdf,
/*     BoolGadgetSelect */ 0x3d,
/*           TextGadget */ 0x57,
/*  TextGadgetActivated */ 0x20,
/*         GadgetHotKey */ 0xd4,
/*    GadgetSelectedHot */ 0x3f,
/*                 List */ 0x50,
/*              ListBar */ 0x3f,
/*           ListHilite */ 0x5f,
/*           ListItalic */ 0x5e,
/*             ListKnob */ 0xee,
/*       ListKnobSelect */ 0x40,
/*        GadgetDisable */ 0xd7,
/*          ErrorWindow */ 0xcf,
/*          ErrorGadget */ 0xc0,
/*    ErrorGadgetSelect */ 0x4c,
/*       ErrorGadgetHot */ 0xce,
/* ErrorGadgetSelectHot */ 0x4e,
/*               Status */ 0xdf,
/*         StatusHilite */ 0xd0,
/*          StatusError */ 0xd4,
/*                 Flag */ 0xaf,
/*          FlagDisable */ 0xa8,
/*           FlagHilite */ 0xa4,
/*                  DOS */ 0x0f,

    }
};

static struct Gadget *reqgad;

#define WIN_WIDTH 52
#define WIN_HEIGHT 22
void color_setup( void ) {

    static struct Window CODEBASED win = {
        -1, -1, WIN_WIDTH, WIN_HEIGHT, 0, 0,
        "Color Setup", 0L
    };

    static struct Gadget CODEBASED g_help = {
        NULL, NULL, WIN_WIDTH-10, WIN_HEIGHT-4,
        8, 3, BOOLGADGET | ENDGADGET | DEFHELPGADGET,
    };
    static struct Gadget CODEBASED g_cancel = {
        &g_help, NULL, WIN_WIDTH-22, WIN_HEIGHT-4,
        10, 3, BOOLGADGET | ENDGADGET | DEFCANCELGADGET,
    };
#ifdef DEBUG
    static struct Gadget CODEBASED g_ok2 = {
        &g_cancel, NULL, 10, WIN_HEIGHT-4,
        8, 3, BOOLGADGET | ENDGADGET | DEFOKGADGET,
    };
#endif
    static struct Gadget CODEBASED g_ok = {
#ifdef DEBUG
        &g_ok2,
#else
        &g_cancel,
#endif
        NULL, 2, WIN_HEIGHT-4,
        8, 3, BOOLGADGET | ENDGADGET | DEFOKGADGET,
    };

    /* 36 Gadgets for colors */
    struct Gadget colorgad[36];

    struct IntuiText *ita_defpal[CR_MAXVAL];
    struct IntuiText it_defpal[CR_MAXVAL];
    static struct Request CODEBASED req_defpal = {
        NULL, NULL, 0L };
    static struct IntuiText CODEBASED it_predef = {
        NULL, NULL, "&Predefined Palettes:", -1, -1 };

    static struct Gadget CODEBASED gad_defpal = {
        NULL, &it_predef, 4, 16, 25, 1, POPGADGET,
        (APTR)&req_defpal,
    };

    struct IntuiText *ita[CR_MAXVAL];
    struct IntuiText it[CR_MAXVAL];
    static struct Request CODEBASED req = {
        NULL, NULL, 0L };

    static struct Gadget CODEBASED gad_reg = {
        &gad_defpal, NULL, 4, 2, 25, 12, REQGADGET | ACTIVATED,
        (APTR)&req,
    };

    static struct IntuiText CODEBASED it_pen = {
        NULL, NULL, "oreground/Pen", 32, 3, 0, IT_VERTICAL };
    static struct IntuiText CODEBASED it_paper = {
        &it_pen, NULL, "ackground/Paper", 48, 2, 0, IT_VERTICAL };
    static struct IntuiText CODEBASED it_penhot = {
        NULL, NULL, "&F", -2, 1 };
    static struct IntuiText CODEBASED it_paperhot = {
        NULL, NULL, "&B", 4, 0 };


    int x, y, i, j;
    struct Gadget *g;
    unsigned char *palette;
#ifdef DEBUG
    char buffer[EDIT_WIDTH];
#endif

    if( OpenWindow(&win, HLP_COLORSETUP) ) {
        /* Setup Register Names */
        for( i = 0; i < CR_MAXVAL-1; ++i ) {
            ita[i] = &it[i];
            it[i].Flags = 0;
            it[i].Next = NULL;
            it[i].TextBorder = NULL;
            it[i].Text = colornames[i];
            /* Store RGB info in 'Left' */
            it[i].Left = VideoBase->Palette[i];
            it[i].Top = 0;
        }
        ita[i] = NULL;
        req.Items = ita;

        /* Draw color bars */
        i = VideoBase->Palette[CR_WINDOW] >> 4;
        HideMouse();
        for( x = 37, y = 0; y <= 0x0f ; ++y ) {
            VideoBase->Palette[CR_SPECIAL] = y<<4 | i;
            VideoStr( CR_SPECIAL, "      ", x+win.Left, y+win.Top+1 );
        }
        PrintIText( &it_paper, win.Left, win.Top );
        ShowMouse();
        /* Setup 36 Gadgets */
        for( i = 0, j = 16; i < 16; ++i, ++j ) {
            colorgad[i].Next = &colorgad[i+1];
            colorgad[j].Next = &colorgad[j+1];
            colorgad[i].IText = colorgad[j].IText = NULL;
            colorgad[i].Left = 34;
            colorgad[j].Left = 44;
            colorgad[i].Top = colorgad[j].Top = i+1;
            colorgad[i].Width = colorgad[j].Width = 3;
            colorgad[i].Height = colorgad[j].Height = 1;
            colorgad[i].Flags = colorgad[j].Flags =
                OPTIONGADGET|BORDERLESS|NODESELECT|HOTKEYNOSELECT;
            colorgad[i].MutalExclude = 1L;
            colorgad[j].MutalExclude = 2L;
        }
        colorgad[j-1].Next = &g_ok;
        gad_defpal.Next = colorgad;
        colorgad[0].IText = &it_penhot;
        colorgad[16].IText = &it_paperhot;

        /* setup popgadget */
        for( i = 0; i < sizeof(palette_name)/sizeof(char *); ++i ) {
            ita_defpal[i] = &it_defpal[i];
            it_defpal[i].Flags = 0L;
            it_defpal[i].Next = NULL;
            it_defpal[i].TextBorder = NULL;
            it_defpal[i].Text = palette_name[i];
            it_defpal[i].Left = it_defpal[i].Top = it_defpal[i].Width = 0;
        }
        ita_defpal[i] = NULL;
        req_defpal.Items = ita_defpal;

        reqgad = &gad_reg;

        do {
            g = OpenGadget( &gad_reg, win.Left, win.Top, gadhandler );
            if( g == &g_help ) help( -1 );
        } while( g == &g_help );
        CloseWindow( &win );

        if( g && g != &g_cancel ) {
            /* save color palette */
            palette = AllocHeap( CR_MAXVAL );
            if( palette == NULL ) return;

            for( i = 0; i < CR_MAXVAL-1; ++i ) {
                palette[i] = it[i].Left;
            }
            PutProfileData( PR_PALETTE, palette, CR_MAXVAL );
            VideoBase->Palette = GetProfileData( PR_PALETTE, default_palette[0] );

#ifdef DEBUG
            if( g == &g_ok2 ) {
                for( i = 0; i < CR_MAXVAL-1; ++i ) {
                    sprintf( buffer, "/* %20s */ %#04x,", colornames[i],
                            palette[i] );
                    if( e_strins( buffer ) )
                        e_return( 0, 1 );
                }
            }
#endif
            free( palette );
        }
    }
}
#undef WIN_WIDTH
#undef WIN_HEIGHT

static struct Gadget *gadhandler( struct Gadget *first, struct Gadget *g,
        unsigned left_off, unsigned top_off, unsigned long flags ) {

    struct StringInfo *si;
    struct Request *req;

    req = (struct Request *)reqgad->SpecialInfo;

    if( g == reqgad && (flags & (CG_CHANGE|CG_INITIALIZE) ) )
        _drawcolors( first, req, left_off, top_off );
    else if( (g->Flags & OPTIONGADGET) && (flags & CG_CHANGE) )
        _changecolors( first, req );
    else if( g == reqgad->Next && (flags & CG_CHANGE) ) {
        _setdefpalette( first, req );
        _drawcolors( first, req, left_off, top_off );
    }
}

static void _setdefpalette( g, req )
struct Gadget *g;
struct Request *req;
{
    int num, i;

    num = ((struct Request *)(g->Next->SpecialInfo))->CurrIt;
    for( i = 0; i < CR_MAXVAL-1; ++i )
        req->Items[i]->Left = default_palette[num][i];
}

static void _drawcolors( g, req, left_off, top_off )
struct Gadget *g;
struct Request *req;
unsigned int left_off, top_off;
{
    int i;
    int pen, paper;

    g = g->Next->Next;

    /* activate pen gadget */
    pen = req->Items[req->CurrIt]->Left & 0x0f;
    for( i = 0; i < 16; ++i ) {
        if( i == pen )
            SETBIT( g->Flags, SELECTED );
        else
            CLEARBIT( g->Flags, SELECTED );

        DrawGadget( g, left_off, top_off );
        g = g->Next;
    }
    /* activate paper gadget */
    paper = req->Items[req->CurrIt]->Left >> 4;
    for( i = 0; i < 16; ++i ) {
        if( i == paper )
            SETBIT( g->Flags, SELECTED );
        else
            CLEARBIT( g->Flags, SELECTED );

        DrawGadget( g, left_off, top_off );
        g = g->Next;
    }
}

static void _changecolors( struct Gadget *g, struct Request *req ){

    unsigned char rgb = 0;
    unsigned char i;

    g = g->Next->Next;
    for( i = 0; i < 16; ++i, g = g->Next ) {
        if( g->Flags & SELECTED )
            rgb |= i;
    }
    for( i = 0; i < 16; ++i, g = g->Next ) {
        if( g->Flags & SELECTED )
            rgb |= i << 4;
    }

    req->Items[req->CurrIt]->Left = rgb;
}

/* copies the default palette to VideoBase->Palette */
void getdefpalette( void ) {

    unsigned char *palette;
    int i;

    palette = AllocHeap( CR_MAXVAL );
    if( palette == NULL ) return;

    for( i = 0; i < CR_MAXVAL-1; ++i ) {
        palette[i] = default_palette[0][i];
    }
    PutProfileData( PR_PALETTE, palette, CR_MAXVAL );
    VideoBase->Palette = GetProfileData( PR_PALETTE, default_palette[0] );

    free( palette );
}

/* end of file color.c */

