/*
 * SOURCE:  numl.c
 * PROJECT: numl
 *
 * PURPOSE: counts number of lines in specified files
 *          wildcards are ok.
 *
 */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "dos.h"

    // function prototypes
int main( int, char ** );
int numl( int, char ** );

int main( int argc, char **argv ) {

    return numl( argc-1, argv+1 );
}


int numl( int argc, char **argv ) {

    struct DiskTransferArea _far *dta;
    int i;
    unsigned long numlines = 0L, l;
    FILE *fptr;
    int c;

    /* read directory */
    dta = GetDTAAddress();

    for( i = 0; i <= argc; ++i ) {
        if( FindFirstFile( argv[i], 0 ) )
        {
            do {
                if( dta->Attributes & DTA_DIRECTORY )
                    printf( "'%s': directories not supported\n", dta->Name );
                else {
                    fptr = fopen( dta->Name, "r" );
                    if( fptr == NULL )
                        printf("'%s': could not open file\n", dta->Name );
                    else {
                        printf( "%-12s: ", dta->Name );
                        l = 0L;
                        do {
                            c = fgetc( fptr );
                            if( c == 10 )
                                ++l;
                        } while( !feof( fptr ) );
                        printf( "%ld\n", l );
                        numlines += l;
                        fclose( fptr );
                    }
                }
            } while( FindNextFile() );
        }
    }
    printf( "%ld lines.\n", numlines );
    return 0;
}


/* end of file numl.c */
