/* 
   Project: FisicaLab

   Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015 Free Software Foundation

   Author: German A. Arias <germanandre@gmx.es>

   Created: 2008-09-10 18:56:00 -0600 by german
   
   Application Controller

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import "ChalkboardView.h"
#import "AppController.h"
#import <math.h>
#import <Renaissance/Renaissance.h>

@implementation AppController

- (id) init
{
  if ((self = [super init]))
    {
      preferencesPanel = nil;
      propertiesWindow = nil;
    }
  return self;
}

- (void) applicationWillFinishLaunching: (NSNotification *)aNotification
{
  [NSBundle loadGSMarkupNamed: @"fisica" owner: self];

  // Hide the label use only for thermodynamics.
  [system setHidden: YES];
  // Select the SI system.
  [unitsSelector selectCellWithTag: 0];

  // Se the user frames for windows.
  [[elements window] setDelegate: self];
  [[elements window] setFrameUsingName: @"Palette"];
  [[chalkboard window] setDelegate: self];
  [[chalkboard window] setFrameUsingName: @"Chalkboard"];
}

- (void) applicationDidFinishLaunching: (NSNotification*)aNotification
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

  if (![defaults boolForKey: @"HasStartedBefore"])
    {
      NSTextField *url = [NSTextField new];
      NSButton *button = [NSButton new];
      [NSBundle loadGSMarkupNamed: @"firstLaunchPanel" owner: self];

      [url setBordered: NO];
      [url setBezeled: NO];
      [url setEditable: NO];
      [url setSelectable: YES];
      [url setStringValue: @"http://www.gnu.org/software/fisicalab/"];
      [url setFrame: NSMakeRect(235, 40, 250, 35)];

      [button setTitle: _(@"Don't show it again")];
      [button setButtonType: NSSwitchButton];
      [button setFrame: NSMakeRect(490, 5, 140, 30)];
      [button setImagePosition: NSImageRight];
      [button setTarget: self];
      [button setAction: @selector(notShowAgain:)];

      [[firstLaunchPanel contentView] addSubview: url];
      [[firstLaunchPanel contentView] addSubview: button];
      [firstLaunchPanel center];
      [firstLaunchPanel makeKeyAndOrderFront: self];

      [url release];
      [button release];
    }
}

- (void) showPrefPanel: (id)sender
{
  if (preferencesPanel == nil)
    {
      int width = 0, height = 0, size = 0;
      NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
      [NSBundle loadGSMarkupNamed: @"preferences" owner: self];

      [preferencesPanel center];
      [preferencesPanel makeKeyAndOrderFront: self];
      
      width = [defaults integerForKey: @"ChalkboardWidth"];
      height = [defaults integerForKey: @"ChalkboardHeight"];
      size = [defaults integerForKey: @"NSToolTipsFontSize"];
      
      if ((width < 26) || (width > 100))
	{
	  width = 26;
	}
      
      if ( (height < 18) || (height > 100))
	{
	  height = 18;
	}

      if ( (size < 10) || (size > 20))
	{
	  size = 10;
	}

      [widthLabel setIntValue: width];
      [heightLabel setIntValue: height];
      [fontsizeLabel setIntValue: size];
      [widthStepper setIntValue: width];
      [heightStepper setIntValue: height];
      [fontsizeStepper setIntValue: size];
    }
  else
    {
      [preferencesPanel makeKeyAndOrderFront: self];
    }
}

- (void) showHelpPanel: (id)sender
{
  if (helpPanel == nil)
    {
      [NSBundle loadGSMarkupNamed: @"help" owner: self];
      [helpPanel makeKeyAndOrderFront: self];
    }
  else
    {
      [helpPanel makeKeyAndOrderFront: self];
    }
}

- (void) showPropertiesWindow: (id)sender
{
  if (propertiesWindow == nil)
    {
      [NSBundle loadGSMarkupNamed: @"properties" owner: self];
      [propertiesWindow makeKeyAndOrderFront: self];
    }
  else
    {
      [propertiesWindow makeKeyAndOrderFront: self];
    }
}

- (void) selectModule: (id)sender
{
  // Cancel any operation add/move element.
  [chalkboard controlCursor: self];
  
  /* If selected group is thermodynamics, show the label and hide units
     selector. If any other, hide the label and show the units selector.
     This because we only allow system SI in thermodynamics group. */
  if ([sender tag] == 3)
    {
      if ([system isHidden] == YES)
        {
          [system setHidden: NO];
          [unitsSelector setHidden: YES];
        }
    }
  else
    {
      if ([system isHidden] ==  NO)
        {
          [system setHidden: YES];
          [unitsSelector setHidden: NO];
        }
    }
  
  // Select the corresponding group of modules.
  [elements selectTabViewItemAtIndex: [sender tag]];
}

- (void) addToChalkboard: (id)sender
{
  CGFloat x, y, width, height, xRatio, yRatio;
  NSPoint loc;
  NSButton *button = [NSButton new];;
  NSEvent *e = [NSApp currentEvent];

  loc = [sender convertPoint: [e locationInWindow] fromView: nil];

  x = loc.x;
  y = loc.y;
  width = [sender frame].size.width;
  height = [sender frame].size.height;

  switch ([sender tag])
    {
      // Statics Points: Forces.
    case 56:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_no.tif"]];
		[button setTag: 58];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"f_izquierda.tif"]];
		[button setTag: 61];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_so.tif"]];
		[button setTag: 57];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_arriba.tif"]];
		[button setTag: 62];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_abajo.tif"]];
		[button setTag: 63];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_ne.tif"]];
		[button setTag: 56];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"f_derecha.tif"]];
		[button setTag: 60];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_se.tif"]];
		[button setTag: 59];
	      }
	  }
      }
      break;
      // Statics Points: Frictions.
    case 64:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_no.tif"]];
		[button setTag: 66];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_i.tif"]];
		[button setTag: 69];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_so.tif"]];
		[button setTag: 65];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ar.tif"]];
		[button setTag: 70];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ab.tif"]];
		[button setTag: 71];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ne.tif"]];
		[button setTag: 64];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_d.tif"]];
		[button setTag: 68];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_se.tif"]];
		[button setTag: 67];
	      }
	  }
      }
      break;
      // Statics Points: Resultants.
    case 72:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    [button setImage: [NSImage imageNamed: @"resultante.tif"]];
	    [button setTag: 72];
	  }
	else if (xRatio == 1)
	  {
	    [button setImage: [NSImage imageNamed: @"resultante_h.tif"]];
	    [button setTag: 73];
	  }
	else
	  {
	    [button setImage: [NSImage imageNamed: @"resultante_v.tif"]];
	    [button setTag: 74];
	  }
      }
      break;
      // Statics Points: Springs.
    case 75:
      {
	xRatio = floor(x/(width/4));
	yRatio = floor(y/(height/4));

	if (xRatio == 0)
	  {
	    [button setImage: [NSImage imageNamed: @"r_ii.tif"]];
	    [button setTag: 75];
	  }
	else if (xRatio == 1)
	  {
	    [button setImage: [NSImage imageNamed: @"r_id.tif"]];
	    [button setTag: 76];
	  }
	else if (xRatio == 2)
	  {
	    [button setImage: [NSImage imageNamed: @"r_v.tif"]];
	    [button setTag: 77];
	  }
	else
	  {
	    [button setImage: [NSImage imageNamed: @"r_h.tif"]];
	    [button setTag: 78];
	  }
      }
      break;
      // Dynamics Points: Mobile.
    case 101:
      {
	xRatio = floor(x/(width/2));
	yRatio = floor(y/(height/2));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"movil_y.tif"]];
		[button setTag: 103];
	      }
	    else
	      {
		return;
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"movil.tif"]];
		[button setTag: 101];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"movil_x.tif"]];
		[button setTag: 102];
	      }
	  }
      }
      break;
      // Dynamics Points: Block.
    case 104:
      {
	xRatio = floor(x/(width/2));
	yRatio = floor(y/(height/2));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"bloque_i.tif"]];
		[button setTag: 106];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"bloque_v.tif"]];
		[button setTag: 104];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"bloque_d.tif"]];
		[button setTag: 107];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"bloque_h.tif"]];
		[button setTag: 105];
	      }
	  }
      }
      break;
      // Dynamics Points: Principle.
    case 139:
      {
	xRatio = floor(x/(width/2));
	yRatio = floor(y/(height/2));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"energia.tif"]];
		[button setTag: 139];
	      }
	    else
	      {
		return;
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"momento.tif"]];
		[button setTag: 140];
	      }
	  }
      }
      break;
      // Dynamics Points: Force.
    case 109:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_no.tif"]];
		[button setTag: 111];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"f_izquierda.tif"]];
		[button setTag: 114];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_so.tif"]];
		[button setTag: 110];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_arriba.tif"]];
		[button setTag: 115];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_abajo.tif"]];
		[button setTag: 116];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_ne.tif"]];
		[button setTag: 109];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"f_derecha.tif"]];
		[button setTag: 113];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_se.tif"]];
		[button setTag: 112];
	      }
	  }
      }
      break;
      // Dynamics Points: Frictions.
    case 117:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_no.tif"]];
		[button setTag: 119];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_i.tif"]];
		[button setTag: 122];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_so.tif"]];
		[button setTag: 118];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ar.tif"]];
		[button setTag: 123];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ab.tif"]];
		[button setTag: 124];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ne.tif"]];
		[button setTag: 117];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_d.tif"]];
		[button setTag: 121];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_se.tif"]];
		[button setTag: 120];
	      }
	  }
      }
      break;
      // Dynamics Points: Contacts.
    case 125:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"contacto_no.tif"]];
		[button setTag: 127];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"contacto_i.tif"]];
		[button setTag: 130];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"contacto_so.tif"]];
		[button setTag: 126];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"contacto_ar.tif"]];
		[button setTag: 131];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"contacto_ab.tif"]];
		[button setTag: 132];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"contacto_ne.tif"]];
		[button setTag: 125];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"contacto_d.tif"]];
		[button setTag: 129];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"contacto_se.tif"]];
		[button setTag: 128];
	      }
	  }
      }
      break;
      // Dynamics Points: Springs.
    case 133:
      {
	xRatio = floor(x/(width/4));
	yRatio = floor(y/(height/4));

	if (xRatio == 0)
	  {
	    [button setImage: [NSImage imageNamed: @"r_ii.tif"]];
	    [button setTag: 133];
	  }
	else if (xRatio == 1)
	  {
	    [button setImage: [NSImage imageNamed: @"r_id.tif"]];
	    [button setTag: 134];
	  }
	else if (xRatio == 2)
	  {
	    [button setImage: [NSImage imageNamed: @"r_v.tif"]];
	    [button setTag: 135];
	  }
	else
	  {
	    [button setImage: [NSImage imageNamed: @"r_h.tif"]];
	    [button setTag: 136];
	  }
      }
      break;
      // Calorimetry: Expansion.
    case 157:
      {
	xRatio = floor(x/(width/2));
	yRatio = floor(y/(height/2));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"dil_l.tif"]];
		[button setTag: 157];
	      }
	    else
	      {
		return;
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"dil_s.tif"]];
		[button setTag: 158];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"dil_v.tif"]];
		[button setTag: 159];
	      }
	  }
      }
      break;
      // Calorimetry: Change state.
    case 161:
      {
	xRatio = floor(x/(width/2));
	yRatio = floor(y/(height/2));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"cfase_sl.tif"]];
		[button setTag: 160];
	      }
	    else
	      {
		return;
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"cfase_gen.tif"]];
		[button setTag: 162];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"cfase_lg.tif"]];
		[button setTag: 161];
	      }
	  }
      }
      break;
      // Statics Rigid: Bodies.
    case 252:
      {
	xRatio = floor(x/(width/2));
	yRatio = floor(y/(height/2));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"puntos.tif"]];
		[button setTag: 276];
	      }
	    else
	      {
		return;
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"vigaInfo.tif"]];
		[button setTag: 252];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"solidoInfo.tif"]];
		[button setTag: 253];
	      }
	  }
      }
      break;
      // Statics Rigid: Beam elements.
    case 255:
      {
	xRatio = floor(x/(width/3));
	yRatio = 100*(y/height);

	[button setTag: 255];

	if (xRatio == 0)
	  {
	    if (yRatio <= 17)
	      {
		[button setImage: [NSImage imageNamed: @"vigaH_uno.tif"]];
	      }
	    else if (yRatio <= 46)
	      {
		[button setImage: [NSImage imageNamed: @"vigaV_uno.tif"]];
	      }
	    else if (yRatio <= 72)
	      {
		[button setImage: [NSImage imageNamed: @"vigaID_uno.tif"]];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"vigaII_tres.tif"]];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio <= 17)
	      {
		[button setImage: [NSImage imageNamed: @"vigaH_dos.tif"]];
	      }
	    else if (yRatio <= 46)
	      {
		[button setImage: [NSImage imageNamed: @"vigaV_dos.tif"]];
	      }
	    else if (yRatio <= 72)
	      {
		[button setImage: [NSImage imageNamed: @"vigaID_dos.tif"]];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"vigaII_dos.tif"]];
	      }
	  }
	else
	  {
	    if (yRatio <= 17)
	      {
		[button setImage: [NSImage imageNamed: @"vigaH_tres.tif"]];
	      }
	    else if (yRatio <= 46)
	      {
		[button setImage: [NSImage imageNamed: @"vigaV_tres.tif"]];
	      }
	    else if (yRatio <= 72)
	      {
		[button setImage: [NSImage imageNamed: @"vigaID_tres.tif"]];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"vigaII_uno.tif"]];
	      }
	  }
      }
      break;
      // Statics Rigid: Solid elements.
    case 256:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	[button setTag: 256];

	if ([[[sender image] name] hasPrefix: @"solidos1"])
	  {
	    if (xRatio == 0)
	      {
		if (yRatio == 0)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoESI.tif"]];
		  }
		else if (yRatio == 1)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoIZ.tif"]];
		  }
		else
		  {
		    [button setImage: [NSImage imageNamed: @"solidoEII.tif"]];
		  }
	      }
	    else if (xRatio == 1)
	      {
		if (yRatio == 0)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoIS.tif"]];
		  }
		else if (yRatio == 1)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoC.tif"]];
		  }
		else
		  {
		    [button setImage: [NSImage imageNamed: @"solidoII.tif"]];
		  }
	      }
	    else
	      {
		if (yRatio == 0)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoESD.tif"]];
		  }
		else if (yRatio == 1)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoID.tif"]];
		  }
		else
		  {
		    [button setImage: [NSImage imageNamed: @"solidoEID.tif"]];
		  }
	      }
	  }
	else if ([[[sender image] name] hasPrefix: @"solidos2"])
	  {
	    if (xRatio == 0)
	      {
		if (yRatio == 0)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoINSI.tif"]];
		  }
		else if (yRatio == 1)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoINEI.tif"]];
		  }
		else
		  {
		    [button setImage: [NSImage imageNamed: @"solidoINII.tif"]];
		  }
	      }
	    else if (xRatio == 1)
	      {
		if (yRatio == 0)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoINES.tif"]];
		  }
		else if (yRatio == 1)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoC.tif"]];
		  }
		else
		  {
		    [button setImage: [NSImage imageNamed: @"solidoINEB.tif"]];
		  }
	      }
	    else
	      {
		if (yRatio == 0)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoINSD.tif"]];
		  }
		else if (yRatio == 1)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoINED.tif"]];
		  }
		else
		  {
		    [button setImage: [NSImage imageNamed: @"solidoINID.tif"]];
		  }
	      }
	  }
	else
	  {
	    if (xRatio == 0)
	      {
		if (yRatio == 0)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoESIC.tif"]];
		  }
		else if (yRatio == 1)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoIZC.tif"]];
		  }
		else
		  {
		    [button setImage: [NSImage imageNamed: @"solidoEIIC.tif"]];
		  }
	      }
	    else if (xRatio == 1)
	      {
		if (yRatio == 0)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoISC.tif"]];
		  }
		else if (yRatio == 1)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoC.tif"]];
		  }
		else
		  {
		    [button setImage: [NSImage imageNamed: @"solidoIIC.tif"]];
		  }
	      }
	    else
	      {
		if (yRatio == 0)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoESDC.tif"]];
		  }
		else if (yRatio == 1)
		  {
		    [button setImage: [NSImage imageNamed: @"solidoIDC.tif"]];
		  }
		else
		  {
		    [button setImage: [NSImage imageNamed: @"solidoEIDC.tif"]];
		  }
	      }
	  }
      }
      break;
      // Statics Rigid: Forces.
    case 257:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_no.tif"]];
		[button setTag: 259];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"f_izquierda.tif"]];
		[button setTag: 262];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_so.tif"]];
		[button setTag: 258];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_arriba.tif"]];
		[button setTag: 263];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_abajo.tif"]];
		[button setTag: 264];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_ne.tif"]];
		[button setTag: 257];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"f_derecha.tif"]];
		[button setTag: 261];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_se.tif"]];
		[button setTag: 260];
	      }
	  }
      }
      break;
      // Statics Rigid: Frictions.
    case 265:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_no.tif"]];
		[button setTag: 267];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_i.tif"]];
		[button setTag: 270];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_so.tif"]];
		[button setTag: 266];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ar.tif"]];
		[button setTag: 271];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ab.tif"]];
		[button setTag: 272];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ne.tif"]];
		[button setTag: 265];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_d.tif"]];
		[button setTag: 269];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_se.tif"]];
		[button setTag: 268];
	      }
	  }
      }
      break;
      // Statics Rigid: Resultants.
    case 273:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    [button setImage: [NSImage imageNamed: @"resultanteR.tif"]];
	    [button setTag: 273];
	  }
	else if (xRatio == 1)
	  {
	    [button setImage: [NSImage imageNamed: @"resultante_hR.tif"]];
	    [button setTag: 274];
	  }
	else
	  {
	    [button setImage: [NSImage imageNamed: @"resultante_vR.tif"]];
	    [button setTag: 275];
	  }
      }
      break;
      // Statics Rigid: Beam 2F.
    case 277:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"viga2FNO.tif"]];
		[button setTag: 279];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"viga2FIz.tif"]];
		[button setTag: 282];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"viga2FSO.tif"]];
		[button setTag: 278];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"viga2FAr.tif"]];
		[button setTag: 283];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"viga2FAb.tif"]];
		[button setTag: 284];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"viga2FNE.tif"]];
		[button setTag: 277];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"viga2FDer.tif"]];
		[button setTag: 281];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"viga2FSE.tif"]];
		[button setTag: 280];
	      }
	  }
      }
      break;
      // Statics Rigid: Beams of truss.
    case 285:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"vigaNO.tif"]];
		[button setTag: 287];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"vigaIz.tif"]];
		[button setTag: 290];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"vigaSO.tif"]];
		[button setTag: 286];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"vigaAr.tif"]];
		[button setTag: 291];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"vigaAb.tif"]];
		[button setTag: 292];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"vigaNE.tif"]];
		[button setTag: 285];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"vigaDer.tif"]];
		[button setTag: 289];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"vigaSE.tif"]];
		[button setTag: 288];
	      }
	  }
      }
      break;
      // Dynamics circular: Springs.
    case 317:
      {
	xRatio = floor(x/(width/4));
	yRatio = floor(y/(height/4));

	if (xRatio == 0)
	  {
	    [button setImage: [NSImage imageNamed: @"r_ii.tif"]];
	    [button setTag: 317];
	  }
	else if (xRatio == 1)
	  {
	    [button setImage: [NSImage imageNamed: @"r_id.tif"]];
	    [button setTag: 318];
	  }
	else if (xRatio == 2)
	  {
	    [button setImage: [NSImage imageNamed: @"r_v.tif"]];
	    [button setTag: 319];
	  }
	else
	  {
	    [button setImage: [NSImage imageNamed: @"r_h.tif"]];
	    [button setTag: 320];
	  }
      }
      break;
      // Dynamics circular: Forces.
    case 321:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_no.tif"]];
		[button setTag: 321];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"f_izquierda.tif"]];
		[button setTag: 328];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_so.tif"]];
		[button setTag: 324];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_arriba.tif"]];
		[button setTag: 325];
	      }
	    else if (yRatio == 1)
	      {
		return;
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_abajo.tif"]];
		[button setTag: 326];
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"f_ne.tif"]];
		[button setTag: 323];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"f_derecha.tif"]];
		[button setTag: 327];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"f_se.tif"]];
		[button setTag: 322];
	      }
	  }
      }
      break;
      // Dynamics circular: Frictions.
    case 330:
      {
	xRatio = floor(x/(width/3));
	yRatio = floor(y/(height/3));

	if (xRatio == 0)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_no.tif"]];
		[button setTag: 330];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_i.tif"]];
		[button setTag: 329];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_so.tif"]];
		[button setTag: 341];
	      }
	  }
	else if (xRatio == 1)
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ar.tif"]];
		[button setTag: 331];
	      }
	    else
	      {
		return;
	      }
	  }
	else
	  {
	    if (yRatio == 0)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_ne.tif"]];
		[button setTag: 332];
	      }
	    else if (yRatio == 1)
	      {
		[button setImage: [NSImage imageNamed: @"friccion_d.tif"]];
		[button setTag: 333];
	      }
	    else
	      {
		[button setImage: [NSImage imageNamed: @"friccion_se.tif"]];
		[button setTag: 342];
	      }
	  }
      }
      break;
    }

  [chalkboard addObject: button];
}

- (void) windowWillClose: (NSNotification *)aNotification
{
  id window = [aNotification object];
  
  if (window == [chalkboard window])
    {
      [window saveFrameUsingName: @"Chalkboard"];
    }
  
  if (window == [elements window])
    {
      [window saveFrameUsingName: @"Palette"];
    }
}

// Preferences
- (void) changeChalkboardWidth: (id)sender
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
  [defaults setInteger: [sender intValue] forKey: @"ChalkboardWidth"];
  [widthLabel setIntValue: [sender intValue]];
}

- (void) changeChalkboardHeight: (id)sender
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
  [defaults setInteger: [sender intValue] forKey: @"ChalkboardHeight"];
  [heightLabel setIntValue: [sender intValue]];
}

- (void) changeFontsizeTooltips: (id)sender
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
  [defaults setInteger: [sender intValue] forKey: @"NSToolTipsFontSize"];
  [fontsizeLabel setIntValue: [sender intValue]];
}

- (void) restoreDefaults: (id)sender
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
  [defaults removeObjectForKey: @"ChalkboardWidth"];
  [defaults removeObjectForKey: @"ChalkboardHeight"];
  [defaults removeObjectForKey: @"NSToolTipsFontSize"];

  [widthLabel setIntValue: 26];
  [heightLabel setIntValue: 18];
  [fontsizeLabel setIntValue: 10];
  [widthStepper setIntValue: 26];
  [heightStepper setIntValue: 18];
  [fontsizeStepper setIntValue: 10];
}

// First launch panel
- (void) notShowAgain: (id)sender
{
  NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
  [defaults setBool: YES forKey: @"HasStartedBefore"];
}

@end
