/*
  Bug Id: 
  PRMS Id: p0000710
  Bug is : overloading operator delete in class def not allowed
*/

/*
  In addition to this bug, the compiler permits overloading operator
  delete in the class definition.  This is verboten, and should be
  caught by a regression suite.  In other words, the following is also a
  bug that's not caught:
*/


#include <stdlib.h>

extern "C" 
{
   int printf(const char*, ...);
};

typedef int size_t;

class B
{
 public:
   int x;
   virtual ~B() {}
   void operator delete(void*,size_t s)
   {
      printf("B::delete() %d\n",s);
   }
   void operator delete(void*){} // ERROR - overloading operator delete in class def not allowed
};

main()
{
   B* p = new B;
   delete p;
   exit(0);
}
