// -*- mode: c++ -*-
#ifndef _CQUERYTREEBUILDER
#define _CQUERYTREEBUILDER

class CAlgorithm;
class CAccessorCollection;


#include "CMagic.h" // checking CQueryTreeNode
#include "CQueryTreeNode.h"
#include "CSelfDestroyPointer.h"
/** 
    A type helping in the translation from CAlgorithmID
    to CQuery*
    
    Members are to be destroyed with this
*/
class CQueryContainer:public map<string,CSelfDestroyPointer<CQueryTreeNode> >,public CMagic{
public:
  CQueryTreeNode* getQueryByID(const string& inID)const;
};


/** 
    This class builds and maintains a query tree.
 */
class CQueryTreeBuilder{
public:
  /** */
  CQueryTreeBuilder();
  /** 
      Building a query tree out of the information we have gathered.
      true indicates success...
      
      
      We do a post-order traversal of the tree of algorithms:
      At each level we construct the query of the children
      taking them as an argument for constructing the query of
      this.
  */
  pair<CQueryContainer*,CQueryTreeNode*> buildQueryTree(CAlgorithm& inAlgorithm,
							CAccessorCollection& inBaseConfiguration,
							CQueryContainer* inContainer=0)const;
  /** Getting a node of the tree by its
      ID */
  CQueryTreeNode* getQueryByID(const string& inID)const;

};

#endif
