/* Copyright (C) 1999 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <stddef.h>


/* This is a list of all known `errno' codes.  */


const int _sys_nerr = 152;

const char *const _sys_errlist[] =
{
  N_("Error 0"),
  N_("Not owner"),
  N_("No such file or directory"),
  N_("No such process"),
  N_("Interrupted system call"),
  N_("I/O error"),
  N_("No such device or address"),
  N_("Arg list too long"),
  N_("Exec format error"),
  N_("Bad file number"),
  N_("No child processes"),
  N_("Resource temporarily unavailable"),
  N_("Not enough space"),
  N_("Permission denied"),
  N_("Bad address"),
  N_("Block device required"),
  N_("Device busy"),
  N_("File exists"),
  N_("Cross-device link"),
  N_("No such device"),
  N_("Not a directory"),
  N_("Is a directory"),
  N_("Invalid argument"),
  N_("File table overflow"),
  N_("Too many open files"),
  N_("Inappropriate ioctl for device"),
  N_("Text file busy"),
  N_("File too large"),
  N_("No space left on device"),
  N_("Illegal seek"),
  N_("Read-only file system"),
  N_("Too many links"),
  N_("Broken pipe"),
  N_("Argument out of domain"),
  N_("Result too large"),
  N_("No message of desired type"),
  N_("Identifier removed"),
  N_("Channel number out of range"),
  N_("Level 2 not synchronized"),
  N_("Level 3 halted"),
  N_("Level 3 reset"),
  N_("Link number out of range"),
  N_("Protocol driver not attached"),
  N_("No CSI structure available"),
  N_("Level 2 halted"),
  N_("Deadlock situation detected/avoided"),
  N_("No record locks available"),
  N_("Operation canceled"),
  N_("Operation not supported"),
  N_("Disc quota exceeded"),
  N_("Bad exchange descriptor"),
  N_("Bad request descriptor"),
  N_("Message tables full"),
  N_("Anode table overflow"),
  N_("Bad request code"),
  N_("Invalid slot"),
  N_("File locking deadlock"),
  N_("Bad font file format"),
  N_("Error 58"),
  N_("Error 59"),
  N_("Not a stream device"),
  N_("No data available"),
  N_("Timer expired"),
  N_("Out of stream resources"),
  N_("Machine is not on the network"),
  N_("Package not installed"),
  N_("Object is remote"),
  N_("Link has been severed"),
  N_("Advertise error"),
  N_("Srmount error"),
  N_("Communication error on send"),
  N_("Protocol error"),
  N_("Error 72"),
  N_("Error 73"),
  N_("Multihop attempted"),
  N_("Error 75"),
  N_("Error 76"),
  N_("Not a data message"),
  N_("File name too long"),
  N_("Value too large for defined data type"),
  N_("Name not unique on network"),
  N_("File descriptor in bad state"),
  N_("Remote address changed"),
  N_("Can not access a needed shared library"),
  N_("Accessing a corrupted shared library"),
  N_(".lib section in a.out corrupted"),
  N_("Attempting to link in more shared libraries than system limit"),
  N_("Can not exec a shared library directly"),
  N_("Illegal byte sequence"),
  N_("Operation not applicable"),
  N_("Number of symbolic links encountered during path name traversal exceeds MAXSYMLINKS"),
  N_("Error 91"),
  N_("Error 92"),
  N_("Directory not empty"),
  N_("Too many users"),
  N_("Socket operation on non-socket"),
  N_("Destination address required"),
  N_("Message too long"),
  N_("Protocol wrong type for socket"),
  N_("Option not supported by protocol"),
  N_("Error 100"),
  N_("Error 101"),
  N_("Error 102"),
  N_("Error 103"),
  N_("Error 104"),
  N_("Error 105"),
  N_("Error 106"),
  N_("Error 107"),
  N_("Error 108"),
  N_("Error 109"),
  N_("Error 110"),
  N_("Error 111"),
  N_("Error 112"),
  N_("Error 113"),
  N_("Error 114"),
  N_("Error 115"),
  N_("Error 116"),
  N_("Error 117"),
  N_("Error 118"),
  N_("Error 119"),
  N_("Protocol not supported"),
  N_("Socket type not supported"),
  N_("Operation not supported on transport endpoint"),
  N_("Protocol family not supported"),
  N_("Address family not supported by protocol family"),
  N_("Address already in use"),
  N_("Cannot assign requested address"),
  N_("Network is down"),
  N_("Network is unreachable"),
  N_("Network dropped connection because of reset"),
  N_("Software caused connection abort"),
  N_("Connection reset by peer"),
  N_("No buffer space available"),
  N_("Transport endpoint is already connected"),
  N_("Transport endpoint is not connected"),
  N_("Structure needs cleaning"),
  N_("Error 136"),
  N_("Not a name file"),
  N_("Not available"),
  N_("Is a name file"),
  N_("Remote I/O error"),
  N_("Reserved for future use"),
  N_("Error 142"),
  N_("Cannot send after socket shutdown"),
  N_("Too many references: cannot splice"),
  N_("Connection timed out"),
  N_("Connection refused"),
  N_("Host is down"),
  N_("No route to host"),
  N_("Operation already in progress"),
  N_("Operation now in progress"),
  N_("Stale NFS file handle")
};

weak_alias (_sys_errlist, sys_errlist)
weak_alias (_sys_nerr, sys_nerr)
