/* Copyright (C) 1999, 2000 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Andreas Jaeger <aj@suse.de>, 1999.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static struct
{
  const char *path;
  const char *file;
} tests [] =
{
  { "/dir/file", "file" },
  { "file", "file"},
  { "/dir/file///", "file" },
  { "../file", "file" },
  { "/", "/" },
  { NULL, "."},
  { "", "."}
};


int
main (void)
{
  int i = 0;
  int errors = 0;
  char path[1024];
  char *file;

  for (i = 0; i < sizeof (tests) / sizeof (tests [0]); ++i)
    {
      if (tests [i].path == NULL)
	file = __xpg_basename (NULL);
      else
	{
	  strcpy (path, tests [i].path);
	  file = __xpg_basename (path);
	}
      if (strcmp (file, tests [i].file))
	{
	  printf ("Test with `%s' failed: Result is: `%s'.\n",
		  (tests [i].path == NULL ? "NULL" : tests [i].path), file);
	  errors = 1;
	}
    }

  return errors;
}
