/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */



var licenses = require('js_checker/license_definitions');
var simpleStorage = require("simple-storage");
const LAZY = licenses.types.LAZY;
var licenseRegex = [];

const types = require("js_checker/constant_types");

const token = types.token;

var patternUtils = require('js_checker/pattern_utils').patternUtils;

var licStartLicEndRe = /@licstartThefollowingistheentirelicensenoticefortheJavaScriptcodeinthis(?:page|file)(.*)?@licendTheaboveistheentirelicensenoticefortheJavaScriptcodeinthis(?:page|file)/mi;
exports.freeCheck = {
    initLicenses: function (licenses) {

	for (item in licenses) {
	    this.stripLicenseToRegexp(licenses[item]);
	}
    },

    /**
     * stripLicenseToRegexp
     *
     * Removes all non-alphanumeric characters except for the 
     * special tokens, and replace the text values that are 
     * hardcoded in license_definitions.js
     *
     */
    stripLicenseToRegexp: function (license) {
	var i = 0, 
	max = license.licenseFragments.length, 
	item;
	for (; i < max; i++) {
	    item = license.licenseFragments[i];
	    item.regex = patternUtils.removeNonalpha(item.text);

	    if (license.licenseFragments[i].type === LAZY) {

		// do not permit words before. Since "Not" could be added
		// and make it nonfree. e.g.: Not licensed under the GPLv3.
		item.regex = '^(?!.*not).*' + item.regex;

	    }

	    item.regex = new RegExp(patternUtils.replaceTokens(item.regex), 'i'); 
	}

	return license;
    },

    /**
     * checkNodeFreeLicense
     *
     * Check if the node mentions a free license
     * in one of its comments.
     * 
     */
    checkNodeFreeLicense: function (n) {
	var strippedComment,
	comment = this.getComment(n),
	list = licenses.licenses,
	i,
	max,
	regex,
	frag, 
	blah, 
	match;

	if (n.counter === 1 &&
	    n.parent != undefined &&
	    n.parent.type === token.SCRIPT &&
	    comment != undefined && 
	    comment != " ") {
	    strippedComment = patternUtils.removeNonalpha(comment);
	    match = strippedComment.match(licStartLicEndRe);

	    if (match) {
		strippedComment = match[1];
	    } else {
		return;
	    }

	    for (license in list) {	    
		frag = list[license].licenseFragments;
		max = list[license].licenseFragments.length;
		for (i = 0;i < max; i++) {

		    if (frag[i].type !== LAZY ||
			simpleStorage.storage['nolazy'] === 'false' ||
			simpleStorage.storage['nolazy'] == undefined) {

			if (frag[i].regex.test(strippedComment)) {

			    return list[license].licenseName;

			}

		    }

		}
	    }
	}

    },

    /**
     * getComment
     *
     * Grab the comment(s) from the node. Concatenates
     * multiple comments.
     * 
     */
    getComment: function (n) {

	var i = 0, length, comment = "";

	if (n.blockComments == undefined || n.blockComments == " ") {
	    return;
	}

	length = n.blockComments.length;
	if (length > 0) {
	    for (; i < length; i++) {
		comment += n.blockComments[i];
	    }
	}
	if (comment == "") {
	    return;
	}
	return comment;

    }
    
};

exports.freeCheck.initLicenses(licenses.licenses);