/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var crypto = require('script_entries/crypto');



// cachedResults contains objects with result/relationChecker for
// scripts entries indexed by SHA1sum
var cachedResults = {};

exports.scriptsCached = {

    getHash: function (scriptText) {

	return crypto.sha1Encrypt(scriptText);
		
    },

    /**
     * 
     * addEntry
     * 
     * Adds a script entry to the cache by providing the results
     * and the actual script text.
     * 
     */
    addEntry: function (scriptText, 
			result, 
			relationChecker,
		        allowTrivial) {

	cachedResults[this.getHash(scriptText)] = {
	    'result': result,
	    'relationChecker': relationChecker,
	    'allowTrivial': allowTrivial
	};

    },
    /**
     * 
     * addObjectEntry
     * 
     * Adds a script entry by providing an object.
     * Used to provide free library hashes from free_libraries.js
     * 
     */
    addObjectEntry: function (hash, script) {
	cachedResults[hash] = script;
    },

    isCached: function (scriptText, hash) {
	var scriptHash;

	if (hash) {
	    scriptHash = hash;
	} else {
	    scriptHash = this.getHash(scriptText);
	}

	var cachedResult = cachedResults[scriptHash];

	if (scriptHash && cachedResult) {
	    // exact copy of file has already been cached.
	    //console.log('scriptHash is', cachedResult);
	    return cachedResult;
	}
	else {
	    return false;
	}
    }
};

// import free_libraries to populate the cache hash map.
var free_libraries = require("script_entries/free_libraries");