/*
 A JavaScript implementation of the SHA family of hashes, as
 defined in FIPS PUB 180-4 and FIPS PUB 202, as well as the corresponding
 HMAC implementation as defined in FIPS PUB 198a

 Copyright 2008-2020 Brian Turek, 1998-2009 Paul Johnston & Contributors
 Distributed under the BSD License
 See http://caligatio.github.com/jsSHA/ for more information
*/
'use strict';(function(J){function r(d,b,c){var g=0,a=[],f=0,h,l,k,e,m,p,q,t,w=!1,n=[],u=[],v,r=!1;c=c||{};h=c.encoding||"UTF8";v=c.numRounds||1;if(v!==parseInt(v,10)||1>v)throw Error("numRounds must a integer >= 1");if("SHA-1"===d)m=512,p=A,q=K,e=160,t=function(a){return a.slice()};else throw Error("Chosen SHA variant is not supported");k=B(b,h);l=x(d);this.setHMACKey=function(a,b,f){var c;if(!0===w)throw Error("HMAC key already set");if(!0===r)throw Error("Cannot set HMAC key after calling update");
h=(f||{}).encoding||"UTF8";b=B(b,h)(a);a=b.binLen;b=b.value;c=m>>>3;f=c/4-1;if(c<a/8){for(b=q(b,a,0,x(d),e);b.length<=f;)b.push(0);b[f]&=4294967040}else if(c>a/8){for(;b.length<=f;)b.push(0);b[f]&=4294967040}for(a=0;a<=f;a+=1)n[a]=b[a]^909522486,u[a]=b[a]^1549556828;l=p(n,l);g=m;w=!0};this.update=function(b){var e,h,c,d=0,q=m>>>5;e=k(b,a,f);b=e.binLen;h=e.value;e=b>>>5;for(c=0;c<e;c+=q)d+m<=b&&(l=p(h.slice(c,c+q),l),d+=m);g+=d;a=h.slice(d>>>5);f=b%m;r=!0};this.getHash=function(b,h){var c,k,m,p;if(!0===
w)throw Error("Cannot call getHash after setting HMAC key");m=C(h);switch(b){case "HEX":c=function(a){return D(a,e,m)};break;case "B64":c=function(a){return E(a,e,m)};break;case "BYTES":c=function(a){return F(a,e)};break;case "ARRAYBUFFER":try{k=new ArrayBuffer(0)}catch(z){throw Error("ARRAYBUFFER not supported by this environment");}c=function(a){return G(a,e)};break;case "UINT8ARRAY":try{k=new Uint8Array(0)}catch(z){throw Error("UINT8ARRAY not supported by this environment");}c=function(a){return H(a,
e)};break;default:throw Error("format must be HEX, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY");}p=q(a.slice(),f,g,t(l),e);for(k=1;k<v;k+=1)p=q(p,e,0,x(d),e);return c(p)};this.getHMAC=function(b,c){var h,k,n,r;if(!1===w)throw Error("Cannot call getHMAC without first setting HMAC key");n=C(c);switch(b){case "HEX":h=function(a){return D(a,e,n)};break;case "B64":h=function(a){return E(a,e,n)};break;case "BYTES":h=function(a){return F(a,e)};break;case "ARRAYBUFFER":try{h=new ArrayBuffer(0)}catch(z){throw Error("ARRAYBUFFER not supported by this environment");
}h=function(a){return G(a,e)};break;case "UINT8ARRAY":try{h=new Uint8Array(0)}catch(z){throw Error("UINT8ARRAY not supported by this environment");}h=function(a){return H(a,e)};break;default:throw Error("outputFormat must be HEX, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY");}k=q(a.slice(),f,g,t(l),e);r=p(u,x(d));r=q(k,e,m,r,e);return h(r)}}function I(d,b,c){var g,a,f,h;b=b||[0];c=c||0;a=c>>>3;for(g=0;g<d.length;g+=1)h=g+a,f=h>>>2,b.length<=f&&b.push(0),b[f]|=d[g]<<8*(3+h%4*-1);return{value:b,binLen:8*
d.length+c}}function D(d,b,c){var g="";b/=8;var a,f;for(a=0;a<b;a+=1)f=d[a>>>2]>>>8*(3+a%4*-1),g+="0123456789abcdef".charAt(f>>>4&15)+"0123456789abcdef".charAt(f&15);return c.outputUpper?g.toUpperCase():g}function E(d,b,c){var g="",a=b/8,f,h,l;for(f=0;f<a;f+=3)for(h=f+1<a?d[f+1>>>2]:0,l=f+2<a?d[f+2>>>2]:0,l=(d[f>>>2]>>>8*(3+f%4*-1)&255)<<16|(h>>>8*(3+(f+1)%4*-1)&255)<<8|l>>>8*(3+(f+2)%4*-1)&255,h=0;4>h;h+=1)8*f+6*h<=b?g+="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(l>>>
6*(3-h)&63):g+=c.b64Pad;return g}function F(d,b){var c="",g=b/8,a,f;for(a=0;a<g;a+=1)f=d[a>>>2]>>>8*(3+a%4*-1)&255,c+=String.fromCharCode(f);return c}function G(d,b){var c=b/8,g,a=new ArrayBuffer(c),f;f=new Uint8Array(a);for(g=0;g<c;g+=1)f[g]=d[g>>>2]>>>8*(3+g%4*-1)&255;return a}function H(d,b){var c=b/8,g,a=new Uint8Array(c);for(g=0;g<c;g+=1)a[g]=d[g>>>2]>>>8*(3+g%4*-1)&255;return a}function C(d){var b={outputUpper:!1,b64Pad:"=",shakeLen:-1};d=d||{};b.outputUpper=d.outputUpper||!1;!0===d.hasOwnProperty("b64Pad")&&
(b.b64Pad=d.b64Pad);if("boolean"!==typeof b.outputUpper)throw Error("Invalid outputUpper formatting option");if("string"!==typeof b.b64Pad)throw Error("Invalid b64Pad formatting option");return b}function B(d,b){var c;switch(b){case "UTF8":case "UTF16BE":case "UTF16LE":break;default:throw Error("encoding must be UTF8, UTF16BE, or UTF16LE");}switch(d){case "HEX":c=function(b,a,f){var h=b.length,c,d,e,m,p;if(0!==h%2)throw Error("String of HEX type must be in byte increments");a=a||[0];f=f||0;p=f>>>
3;for(c=0;c<h;c+=2){d=parseInt(b.substr(c,2),16);if(isNaN(d))throw Error("String of HEX type contains invalid characters");m=(c>>>1)+p;for(e=m>>>2;a.length<=e;)a.push(0);a[e]|=d<<8*(3+m%4*-1)}return{value:a,binLen:4*h+f}};break;case "TEXT":c=function(g,a,f){var c,d,k=0,e,m,p,q,t,n;a=a||[0];f=f||0;p=f>>>3;if("UTF8"===b)for(n=3,e=0;e<g.length;e+=1)for(c=g.charCodeAt(e),d=[],128>c?d.push(c):2048>c?(d.push(192|c>>>6),d.push(128|c&63)):55296>c||57344<=c?d.push(224|c>>>12,128|c>>>6&63,128|c&63):(e+=1,c=
65536+((c&1023)<<10|g.charCodeAt(e)&1023),d.push(240|c>>>18,128|c>>>12&63,128|c>>>6&63,128|c&63)),m=0;m<d.length;m+=1){t=k+p;for(q=t>>>2;a.length<=q;)a.push(0);a[q]|=d[m]<<8*(n+t%4*-1);k+=1}else if("UTF16BE"===b||"UTF16LE"===b)for(n=2,d="UTF16LE"===b&&!0||"UTF16LE"!==b&&!1,e=0;e<g.length;e+=1){c=g.charCodeAt(e);!0===d&&(m=c&255,c=m<<8|c>>>8);t=k+p;for(q=t>>>2;a.length<=q;)a.push(0);a[q]|=c<<8*(n+t%4*-1);k+=2}return{value:a,binLen:8*k+f}};break;case "B64":c=function(b,a,c){var d=0,l,k,e,m,p,q,n;if(-1===
b.search(/^[a-zA-Z0-9=+\/]+$/))throw Error("Invalid character in base-64 string");k=b.indexOf("=");b=b.replace(/\=/g,"");if(-1!==k&&k<b.length)throw Error("Invalid '=' found in base-64 string");a=a||[0];c=c||0;q=c>>>3;for(k=0;k<b.length;k+=4){p=b.substr(k,4);for(e=m=0;e<p.length;e+=1)l="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(p.charAt(e)),m|=l<<18-6*e;for(e=0;e<p.length-1;e+=1){n=d+q;for(l=n>>>2;a.length<=l;)a.push(0);a[l]|=(m>>>16-8*e&255)<<8*(3+n%4*-1);d+=1}}return{value:a,
binLen:8*d+c}};break;case "BYTES":c=function(b,a,c){var d,l,k,e,m;a=a||[0];c=c||0;k=c>>>3;for(l=0;l<b.length;l+=1)d=b.charCodeAt(l),m=l+k,e=m>>>2,a.length<=e&&a.push(0),a[e]|=d<<8*(3+m%4*-1);return{value:a,binLen:8*b.length+c}};break;case "ARRAYBUFFER":try{c=new ArrayBuffer(0)}catch(g){throw Error("ARRAYBUFFER not supported by this environment");}c=function(b,a,c){return I(new Uint8Array(b),a,c)};break;case "UINT8ARRAY":try{c=new Uint8Array(0)}catch(g){throw Error("UINT8ARRAY not supported by this environment");
}c=function(b,a,c){return I(b,a,c)};break;default:throw Error("format must be HEX, TEXT, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY");}return c}function n(d,b){return d<<b|d>>>32-b}function u(d,b){var c=(d&65535)+(b&65535);return((d>>>16)+(b>>>16)+(c>>>16)&65535)<<16|c&65535}function y(d,b,c,g,a){var f=(d&65535)+(b&65535)+(c&65535)+(g&65535)+(a&65535);return((d>>>16)+(b>>>16)+(c>>>16)+(g>>>16)+(a>>>16)+(f>>>16)&65535)<<16|f&65535}function x(d){var b=[];if("SHA-1"===d)b=[1732584193,4023233417,2562383102,
271733878,3285377520];else throw Error("No SHA variants supported");return b}function A(d,b){var c=[],g,a,f,h,l,k,e;g=b[0];a=b[1];f=b[2];h=b[3];l=b[4];for(e=0;80>e;e+=1)c[e]=16>e?d[e]:n(c[e-3]^c[e-8]^c[e-14]^c[e-16],1),k=20>e?y(n(g,5),a&f^~a&h,l,1518500249,c[e]):40>e?y(n(g,5),a^f^h,l,1859775393,c[e]):60>e?y(n(g,5),a&f^a&h^f&h,l,2400959708,c[e]):y(n(g,5),a^f^h,l,3395469782,c[e]),l=h,h=f,f=n(a,30),a=g,g=k;b[0]=u(g,b[0]);b[1]=u(a,b[1]);b[2]=u(f,b[2]);b[3]=u(h,b[3]);b[4]=u(l,b[4]);return b}function K(d,
b,c,g){var a;for(a=(b+65>>>9<<4)+15;d.length<=a;)d.push(0);d[b>>>5]|=128<<24-b%32;b+=c;d[a]=b&4294967295;d[a-1]=b/4294967296|0;b=d.length;for(a=0;a<b;a+=16)g=A(d.slice(a,a+16),g);return g}"function"===typeof define&&define.amd?define(function(){return r}):"undefined"!==typeof exports?("undefined"!==typeof module&&module.exports&&(module.exports=r),exports=r):J.jsSHA=r})(this);
