;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: CLUEI; Base: 10; -*-

;;; 04/29/1991 (Hubertus) 
;;;
;;; Bug Report: Pressing the EXPOSURE (L5) key on the keyboard while
;;; the pointer is inside the XIT toplevel erraneously changes the focus
;;; to the XIT toplevel-window.
  
(in-package :cluei)

(defmethod wm-take-focus ((shell wm-shell))
  (with-event (kind key mode)
    (when (or (not (eq key :focus-in))
	      (and (member kind '(:ancestor :nonlinear))
		   ;; prevent focus-change while keyboard is grabbed temporarily
		   (not (member mode '(:while-grabbed)))))
      (with-slots (children) shell
	(when children
	  (wm-take-focus (first children)))))))