;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;

#|
==================================================================
Change log:
   05/25/93 Dave Kosbie - Removed references to "kr-extra" (placed
                          #'kr::i-depend-on inside actual KR package)
   07/30/92 Dario Giuse - added loading of gg:scrolling-labeled-box
   06/15/92 Dario Giuse - added loading of opal:multifont
   06/12/92 Dario Giuse - added loading of gg:error-gadget
   05/21/92 Dario Giuse - Converted to Garnet version 2.0
   ??/??/90 Brad Myers  - created
==================================================================
|#

(in-package "USER" :use '("LISP"))

(format t "Loading C32...~%")

;; check first to see if pathname variable is set
(unless (boundp 'Garnet-C32-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-C32-PathName before loading this file."))

(dolist (gadget '("labeled-box-loader"
		  "x-buttons-loader"
		  "arrow-line-loader"
		  "text-buttons-loader"
		  "scrolling-window-loader"
		  "scrolling-input-string-loader"
		  "scrolling-menu-loader" 		; for pop-up-functions
		  "error-gadget-loader"	  		; for C32error
		  "scrolling-labeled-box-loader"	; for package name
		  "motif-scrolling-window-loader"
		  ))
  (load (merge-pathnames gadget
			 #+cmu "gadgets:"
			 #+(not cmu) user::Garnet-Gadgets-PathName)))

(load (merge-pathnames "gilt-functions-loader" user::Garnet-Gilt-PathName))
(load (merge-pathnames "path-functions-loader" user::Garnet-Gilt-PathName))
(load (merge-pathnames "multifont-loader" user::Garnet-Opal-PathName))


(defvar C32-files '("c32"
		    "c32formula"
		    "c32ref"
		    "pop-up-generalize"
		    "pop-up-copy-formula"
		    "pop-up-ask-object"
		    "pop-up-functions"
		    "c32dialog"
		    "c32-lapidary"))

(dolist (file C32-files)
  (load (merge-pathnames file
			 #+cmu "c32:"
			 #+(not cmu) user::Garnet-C32-PathName)
	:verbose T))


(setf (get :garnet-modules :c32) T)

(format T "Type (c32:do-go) to start~%")
