/**
 * Various sprite functions mainly aimed at performing sp_* commands

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/spriteinfo.c,v 1.3 2004/01/16 19:55:45 Beuc Exp $
 */

#include "dink.h"

void
get_last_sprite (void)
{
  int i;
  for (i = MAX_SPRITES_AT_ONCE - 1; i > 2; i--)
    {
      if (spr[i].active)

	{
	  last_sprite_created = i;

	  /* Msg("last sprite created is %d.", i); */

	  return;
	}
    }
}

/*bool*/int
not_in_this_base (int seq, int base)
{
  int realbase = (seq / 10) * 10;
  if (realbase != base)
    {
      return (1);
    }
  else
    {
      return (0);
    }
}


/*bool*/int
in_this_base (int seq, int base)
{
  int realbase = (seq / 10) * 10;
  if (realbase == base)
    {
      /* Msg("TRUE - Ok, realbase is %d, compared to the base, which is %d.", realbase, base); */
      return (1);
    }
  else
    {
      /* Msg("FALSE - Ok, realbase is %d, compared to the base, which is %d.", realbase, base); */
      return (0);
    }
}


void
automove (int j)
{
  char kindx, kindy;
  int speed;
  int speedx = 0;
  int speedy = 0;

  if (spr[j].mx != 0)
    {
      if (spr[j].mx < 0)
	kindx = '-';
      else
	kindx = '+';
      if (kindx == '-')
	speedx = (spr[j].mx - (spr[j].mx * 2));
      else
	speedx = spr[j].mx;
    }
  else
    kindx = '0';

  if (spr[j].my != 0)
    {
      if (spr[j].my < 0)
	kindy = '-';
      else
	kindy = '+';
      if (kindy == '-')
	speedy = (spr[j].my - (spr[j].my * 2));
      else
	speedy = spr[j].my;
    }
  else
    kindy = '0';

  speed = speedx;
  if (speedy > speedx)
    speed = speedy;
  if (speed > 0)
    move (j, speed, kindx, kindy);
  /* move(j, 1, '+','+'); */
}





int
autoreverse (int j)
{

  /* Msg("reversing die %d",spr[j].dir); */

  int r = ((rand () % 2) + 1);

  if ((spr[j].dir == 1) || (spr[j].dir == 2))

    {

      if (r == 1)

	return (8);

      if (r == 2)

	return (6);



    }



  if ((spr[j].dir == 3) || (spr[j].dir == 6))

    {

      if (r == 1)

	return (2);

      if (r == 2)



	return (4);



    }



  if ((spr[j].dir == 9) || (spr[j].dir == 8))

    {

      if (r == 1)

	return (2);

      if (r == 2)



	return (6);





    }



  if ((spr[j].dir == 7) || (spr[j].dir == 4))

    {

      if (r == 1)

	return (8);

      if (r == 2)

	return (6);



    }



  return (0);

}





int
autoreverse_diag (int j)
{
  int r;

  if (spr[j].dir == 0)
    spr[j].dir = 7;

  r = ((rand () % 2) + 1);

  if ((spr[j].dir == 1) || (spr[j].dir == 3))
    {
      if (r == 1)
	return (9);
      if (r == 2)
	return (7);
    }
  if ((spr[j].dir == 3) || (spr[j].dir == 6))
    {
      if (r == 1)
	return (7);
      if (r == 2)
	return (1);
    }
  if ((spr[j].dir == 9) || (spr[j].dir == 8))
    {
      if (r == 1)
	return (1);
      if (r == 2)
	return (7);
    }

  if ((spr[j].dir == 7) || (spr[j].dir == 4))
    {
      if (r == 1)
	return (3);
      if (r == 2)
	return (9);
    }

  Msg (("Auto Reverse Diag was sent a dir %d sprite, base %d walk.",
	spr[j].dir, spr[j].base_walk));

  return (0);
}


void
add_kill_sprite (int h)
{
  int dir, base;
  int crap2;

  if ((spr[h].dir > 9) || (spr[h].dir < 1))
    {
      Msg (("Error:  Changing sprites dir from %d (!?) to 3.", spr[h].dir));
      spr[h].dir = 3;
    }

  dir = spr[h].dir;
  base = spr[h].base_die;

  /* Msg(("Base die is %d", base)); */
  if (base == -1)
    {
      if (seq[spr[h].base_walk + 5].active == 1)
	{
	  int crap2;
	  add_exp (spr[h].exp, h);
	  crap2 =
	    add_sprite (spr[h].x, spr[h].y, 5, spr[h].base_walk + 5, 1);
	  spr[crap2].speed = 0;
	  spr[crap2].seq = spr[h].base_walk + 5;
	  return;
	}
      else
	{
	  dir = 0;
	  base = 164;
	}
    }

  if (seq[base + dir].active == 0)
    {
      if (dir == 1)
	dir = 9;
      else if (dir == 3)
	dir = 7;
      else if (dir == 7)
	dir = 3;
      else if (dir == 9)
	dir = 1;
      else if (dir == 4)
	dir = 6;
      else if (dir == 6)
	dir = 4;
      else if (dir == 8)
	dir = 2;
      else if (dir == 2)
	dir = 8;
    }

  if (seq[base + dir].active == 0)
    {
      Msg (("Can't make a death sprite for dir %d!", base + dir));
    }

  crap2 = add_sprite (spr[h].x, spr[h].y, 5, base + dir, 1);
  spr[crap2].speed = 0;
  spr[crap2].base_walk = 0;
  spr[crap2].seq = base + dir;

  if (base == 164)
    spr[crap2].brain = 7;

  spr[crap2].size = spr[h].size;
  add_exp (spr[h].exp, h);
}


void
done_moving (int h)
{
  spr[h].move_active = 0;
  spr[h].move_nohard = 0;
  if (spr[h].move_script > 0)
    {
      /* Msg(("mover running script %d..", spr[h].move_script)); */
      run_script (spr[h].move_script);
    }
}


int
get_distance_and_dir (int h, int h1, int *dir)
{
  int distancex = 5000;
  int distancey = 5000;
  int dirx/* ; */ = 0;
  int diry/* ; */ = 0;
  if (spr[h].x > spr[h1].x)
    if ((spr[h].x - spr[h1].x) < distancex)
      {
	distancex = (spr[h].x - spr[h1].x);
	dirx = 4;
      }

  if (spr[h].x < spr[h1].x)
    if ((spr[h1].x - spr[h].x) < distancex)
      {
	distancex = (spr[h1].x - spr[h].x);
	dirx = 6;
      }
  if (spr[h].y > spr[h1].y)
    if ((spr[h].y - spr[h1].y) < distancey)
      {
	distancey = (spr[h].y - spr[h1].y);
	diry = 8;
      }

  if (spr[h].y < spr[h1].y)
    if ((spr[h1].y - spr[h].y) < distancey)
      {
	distancey = (spr[h1].y - spr[h].y);
	diry = 2;
      }

  if (distancex > distancey)
    {
      *dir = dirx;
      return (distancex);
    }
  else
    {
      *dir = diry;
      return (distancey);
    }
}


void
process_follow (int h)
{
  int hx, hy;
  int dir;
  int distance;

  if (spr[h].follow > 299)
    {
      Msg (("ERROR:  Sprite %d cannot 'follow' sprite %d??", h,
	    spr[h].follow));
      return;
    }


  if (spr[spr[h].follow].active == 0)
    {
      Msg (("Killing follow"));
      spr[h].follow = 0;
      return;
    }

  hx = spr[spr[h].follow].x;
  hy = spr[spr[h].follow].y;

  distance = get_distance_and_dir (h, spr[h].follow, &dir);

  if (distance < 40)
    return;

  changedir (dir, h, spr[h].base_walk);
  automove (h);
}


void
process_target (int h)
{
  int dir;
  int distance;
  int hx, hy;



  if (spr[h].target > 299)

    {

      Msg (("ERROR:  Sprite %d cannot 'target' sprite %d??", h,
	    spr[h].follow));

      return;

    }



  if (spr[spr[h].target].active == 0)

    {

      Msg (("Killing target"));

      spr[h].target = 0;

      return;

    }



  hx = spr[spr[h].target].x;

  hy = spr[spr[h].target].y;



  distance = get_distance_and_dir (h, spr[h].target, &dir);



  if (distance < spr[h].distance)
    return;



  changedir (dir, h, spr[h].base_walk);



  automove (h);





}













void
process_move (int h)
{



  /* Msg(("Proccesing sprite %d, dir %d (script is %d)", h, spr[h].dir, spr[h].move_script)); */







  if ((spr[h].move_dir == 4) | (spr[h].move_dir == 1) | (spr[h].move_dir ==
							 7))

    {

      if (spr[h].x <= spr[h].move_num)

	{

	  /* done moving */

	  done_moving (h);

	  return;

	}

      changedir (spr[h].move_dir, h, spr[h].base_walk);

      automove (h);

    }



  if ((spr[h].move_dir == 6) | (spr[h].move_dir == 9) | (spr[h].move_dir ==
							 3))

    {

      if (spr[h].x >= spr[h].move_num)

	{

	  /* done moving */

	  done_moving (h);

	  return;

	}

      changedir (spr[h].move_dir, h, spr[h].base_walk);

      automove (h);

    }





  if (spr[h].move_dir == 2)

    {

      if (spr[h].y >= spr[h].move_num)

	{

	  /* done moving */

	  done_moving (h);

	  return;

	}

      changedir (spr[h].move_dir, h, spr[h].base_walk);

      automove (h);

    }





  if (spr[h].move_dir == 8)

    {

      if (spr[h].y <= spr[h].move_num)

	{

	  /* done moving */

	  done_moving (h);

	  return;

	}

      changedir (spr[h].move_dir, h, spr[h].base_walk);

      automove (h);

    }





}







void
change_dir_to_diag (int *dir)
{



  if (*dir == 8)
    *dir = 7;

  if (*dir == 4)
    *dir = 1;

  if (*dir == 2)
    *dir = 3;

  if (*dir == 6)
    *dir = 9;



}



void
find_action (int h)
{
  spr[h].action = (rand () % 2) + 1;
  if (spr[h].action == 1)
    {
      /* sit and think */
      spr[h].move_wait = thisTickCount + ((rand () % 3000) + 400);
      if (spr[h].base_walk != -1)
	{
	  int dir = (rand () % 4) + 1;
	  spr[h].pframe = 1;
	  if (dir == 1)
	    spr[h].pseq = spr[h].base_walk + 1;
	  if (dir == 2)
	    spr[h].pseq = spr[h].base_walk + 3;
	  if (dir == 3)
	    spr[h].pseq = spr[h].base_walk + 7;
	  if (dir == 4)
	    spr[h].pseq = spr[h].base_walk + 9;
	}
      return;
    }

  if (spr[h].action == 2)
    {
      /* move */
      int dir = (rand () % 4) + 1;

      spr[h].move_wait = thisTickCount + ((rand () % 3000) + 500);
      spr[h].pframe = 1;
      if (dir == 1)
	changedir (1, h, spr[h].base_walk);
      if (dir == 2)
	changedir (3, h, spr[h].base_walk);
      if (dir == 3)
	changedir (7, h, spr[h].base_walk);
      if (dir == 4)
	changedir (9, h, spr[h].base_walk);
      return;
    }
  Msg (("Internal error:  Brain 16, unknown action."));
}


int
check_if_move_is_legal (int u)
{
  int hardness;

  if (spr[u].move_active)
    if (spr[u].move_nohard == 1)
      return (0);

  if (u == 1)
    if (in_this_base (spr[u].seq, 310))
      return (0);



  if (u == 1)
    if (!no_cheat)
      if (debug_mode)
	return (0);

  hardness = 0;
  if (spr[u].moveman > 0)
    {
      int i;
      for (i = 1; i <= spr[u].moveman; i++)
	{
	  hardness = get_hard (u, spr[u].lpx[i] - 20, spr[u].lpy[i]);
	  if (hardness == 2)
	    if (spr[u].flying)
	      {
		spr[u].moveman = 0;
		return (2);
	      }
	  if (hardness > 0)
	    {
	      spr[u].x = spr[u].lpx[i - 1];
	      spr[u].y = spr[u].lpy[i - 1];
	      spr[u].moveman = 0;
	      if (push_active)
		if (u == 1)
		  if (hardness != 2) {
		    if (play.push_active == 0)
		      {
/* UNREFERENCED 		      push: */
			if ((spr[u].dir == 2) | (spr[u].dir ==
						 4) | (spr[u].dir ==
						       6) | (spr[u].dir == 8))
			  {
			    /* he  (dink)  is definatly pushing on something */
			    play.push_active = 1;
			    play.push_dir = spr[u].dir;
			    play.push_timer = thisTickCount;
			  }
		      }
		    else
		      {
			if (play.push_dir != spr[1].dir)
			  play.push_active = 0;
		      }
		  }
	      return (hardness);
	    }
	}
    }

  if (u == 1)
    play.push_active = 0;

  return (0);
}


void
grab_trick (int trick)
{
  struct rect rcRect;
  /* Msg(("making trick.")); */

  if (no_transition)
    {
      move_screen = trick;
      trig_man = 1;
      move_counter = 0;
      return;
    }

  rcRect.left = playl;
  rcRect.top = 0;
  rcRect.right = 619;
  rcRect.bottom = 399;
  BltFast (lpDDSTrick, 0, 0, lpDDSBack, &rcRect);
  move_screen = trick;
  trig_man = 1;

  move_counter = 0;
}

void
did_player_cross_screen (/*bool*/int real, int h)
{
  if (walk_off_screen == 1)
    return;
  /* UNREFERENCED   int middlex, middley; */
  /* DO MATH TO SEE IF THEY HAVE CROSSED THE SCREEN, IF SO LOAD NEW ONE */

  if ((spr[h].x) < playl)
    {
      if ((map.loc[*pmap - 1] > 0) && (screenlock == 0))
	{
	  /* move one map to the left */
	  if (real)
	    {
	      move_gonna = 1;
	      return;
	    }
	  update_screen_time ();
	  grab_trick (4);
	  *pmap -= 1;
	  load_map (map.loc[*pmap]);
	  if (map.indoor[*pmap] == 0)
	    play.last_map = *pmap;
	  draw_map_game ();
	  spr[h].x = 619;
	  spr[h].y = spr[h].lpy[0];
	  goto b1end;
	}
      else
	{
	  spr[h].x = playl;
	}
    }

  if ((spr[h].x) > 619)
    {
      if ((map.loc[*pmap + 1] > 0) && (screenlock == 0))
	{
	  /* move one map to the right */
	  if (real)
	    {
	      move_gonna = 1;
	      return;
	    }
	  update_screen_time ();
	  grab_trick (6);
	  *pmap += 1;
	  load_map (map.loc[*pmap]);
	  if (map.indoor[*pmap] == 0)
	    play.last_map = *pmap;
	  draw_map_game ();
	  spr[h].x = playl;
	  spr[h].y = spr[h].lpy[0];
	  goto b1end;
	}
      else
	{
	  spr[h].x = 619;
	}
    }

  if (spr[h].y < 0)
    {
      if ((map.loc[*pmap - 32] > 0) && (screenlock == 0))
	{
	  /* move one map up */
	  if (real)
	    {
	      move_gonna = 1;
	      return;
	    }
	  update_screen_time ();
	  grab_trick (8);
	  *pmap -= 32;
	  load_map (map.loc[*pmap]);
	  if (map.indoor[*pmap] == 0)
	    play.last_map = *pmap;
	  spr[h].x = spr[h].lpx[0];
	  draw_map_game ();
	  spr[h].y = 399;
	  goto b1end;
	}
      else
	{
	  spr[h].y = 0;
	}
    }
  if ((spr[h].y > 399))
    {
      if ((map.loc[*pmap + 32] > 0) && (screenlock == 0))
	{
	  /* move one map down */
	  if (real)
	    {
	      move_gonna = 1;
	      return;
	    }
	  update_screen_time ();
	  grab_trick (2);
	  *pmap += 32;
	  load_map (map.loc[*pmap]);
	  if (map.indoor[*pmap] == 0)
	    play.last_map = *pmap;
	  draw_map_game ();
	  spr[h].y = 0;
	  spr[h].x = spr[h].lpx[0];
	  goto b1end;
	}
      else
	{
	  spr[h].y = 399;
	}
    }
b1end:;
}




/*bool*/int
run_through_tag_list_talk (int h)
{
  struct rect box;
  int amount, amounty;
  int i;

  for (i = 1; i <= last_sprite_created; i++)
    {
      if (spr[i].active)
	if (i != h)
	  if (spr[i].brain != 8)
	    {
	      CopyRect (&box, &k[getpic (i)].hardbox);
	      OffsetRect (&box, spr[i].x, spr[i].y);
	      InflateRect (&box, 10, 10);
	      amount = 50;
	      amounty = 35;
	      if (spr[h].dir == 6)
		{
		  box.left -= amount;
		}
	      if (spr[h].dir == 4)
		{
		  box.right += amount;
		}
	      if (spr[h].dir == 2)
		{
		  box.top -= amounty;
		}
	      if (spr[h].dir == 8)
		{
		  box.bottom += amounty;
		}
	      /* draw_box(box, 33); */

	      if (inside_box (spr[h].x, spr[h].y, box))
		{
		  /* Msg(("Talking to sprite %d", i)); */
		  if (spr[i].script > 0)
		    {
		      /* if (  (spr[i].brain == 0) | (spr[i].brain == 5) | (spr[i].brain == 6) | (spr[i].brain == 7)) */
		      /* Msg(("trying to find TALK in script %d", spr[i].script)); */
		      if (locate (spr[i].script, "TALK"))
			{
			  kill_returning_stuff (spr[i].script);
			  run_script (spr[i].script);
			  return (1);
			}
		    }
		}
	    }
    }
  return (0);
}


int
find_sprite (int block)
{
  int k;
  for (k = 1; k <= last_sprite_created; k++)

    {

      if (spr[k].sp_index == block)

	{

	  return (k);

	}

    }

  return (0);

}



void
UpdateCursorPosition (int dx, int dy)
{
  spr[1].x = dx;
  spr[1].y = dy;
}


byte
get_hard (int h, int x1, int y1)
{
  int value;

  if ((x1 < 0) || (y1 < 0))
    return (0);
  if ((x1 > 599))
    return (0);
  if (y1 > 399)
    return (0);

  value = hm.x[x1].y[y1];


  return (value);
}

byte
get_hard_play (int h, int x1, int y1)
{
  int value;

  x1 -= 20;
  if ((x1 < 0) || (y1 < 0))
    return (0);
  if ((x1 > 599))
    return (0);
  if (y1 > 399)
    return (0);

  value = hm.x[x1].y[y1];

  if (value > 100)
    {

      if (pam.sprite[value - 100].prop != 0)
	{
	  flub_mode = value;
	  value = 0;
	}
    }

  return (value);
}


byte
get_hard_map (int h, int x1, int y1)
{
  int til, offx, offy;

  if ((x1 < 0) || (y1 < 0))
    return (0);
  if ((x1 > 599))
    return (0);
  if (y1 > 399)
    return (0);

  til = (x1 / 50) + (((y1 / 50)) * 12);
  /* til++; */
  offx = x1 - ((x1 / 50) * 50);
  offy = y1 - ((y1 / 50) * 50);
  /* Msg(("tile %d ",til)); */
  return (hmap.tile[realhard (til)].x[offx].y[offy]);
}


void
fill_hardxy (struct rect box)
{
  /* Msg(("filling hard of %d %d %d %d", box.top, box.left, box.right, box.bottom)); */

  int x1;

  if (box.right > 599)
    box.right = 599;
  if (box.top < 0)
    box.top = 0;
  if (box.bottom > 399)
    box.bottom = 399;
  if (box.left < 0)
    box.left = 0;


  for (x1 = box.left; x1 < box.right; x1++)
    {
      int y1;
      for (y1 = box.top; y1 < box.bottom; y1++)
	{
	  hm.x[x1].y[y1] = get_hard_map (0, x1, y1);
	}
    }
}


void
add_exp (int num, int h)
{
  if (spr[h].last_hit != 1)
    return;

  if (num > 0)
    {
      /* add experience */
      int crap2;

      *pexper += num;


      crap2 = add_sprite (spr[h].x, spr[h].y, 8, 0, 0);

      spr[crap2].y -= k[seq[spr[h].pseq].frame[spr[h].pframe]].yoffset;
      spr[crap2].x -= k[seq[spr[h].pseq].frame[spr[h].pframe]].xoffset;
      spr[crap2].y -= k[seq[spr[h].pseq].frame[spr[h].pframe]].box.bottom / 3;
      spr[crap2].x += k[seq[spr[h].pseq].frame[spr[h].pframe]].box.right / 5;
      spr[crap2].y -= 30;
      spr[crap2].speed = 1;
      spr[crap2].hard = 1;
      spr[crap2].brain_parm = 5000;
      spr[crap2].my = -1;
      spr[crap2].kill = 1000;
      spr[crap2].dir = 8;
      spr[crap2].damage = num;


      if (*pexper > 99999)
	*pexper = 99999;


    }

}

int
realhard (int tile)
{

  /* if (pam.t[tile].num > 3000) Msg(("Hard is %d", pam.t[tile].num )); */
  if (pam.t[tile].althard > 0)
    return (pam.t[tile].althard);
  else
    return (hmap.index[pam.t[tile].num]);

}


void
fill_whole_hard (void)
{
  int til;
  for (til = 0; til < 96; til++)
    {
      int offx = (til * 50 - ((til / 12) * 600));
      int offy = (til / 12) * 50;

      int x;
      for (x = 0; x < 50; x++)
	{
	  int y;
	  for (y = 0; y < 50; y++)
	    {


	      hm.x[offx + x].y[offy + y] =
		hmap.tile[realhard (til)].x[x].y[y];


	    }
	}


    }




}


void
fix_dead_sprites (void)
{
  int i;

  if (dinkedit)
    return;

  for (i = 1; i < 100; i++)
    {
      if (play.spmap[*pmap].type[i] == 6)
	{

	  if ((thisTickCount > (play.spmap[*pmap].last_time + 300000))
	      || (thisTickCount + 400000 <
		  play.spmap[*pmap].last_time + 300000))

	    {
	      /* this sprite can come back online now */
	      play.spmap[*pmap].type[i] = 0;
	    }
	}

      if (play.spmap[*pmap].type[i] == 7)
	{

	  if (thisTickCount > (play.spmap[*pmap].last_time + 180000))
	    {
	      /* this sprite can come back online now */
	      play.spmap[*pmap].type[i] = 0;
	    }
	}

      if (play.spmap[*pmap].type[i] == 8)
	{

	  if (thisTickCount > (play.spmap[*pmap].last_time + 60000))
	    {
	      /* this sprite can come back online now */
	      play.spmap[*pmap].type[i] = 0;
	    }
	}


    }

}


void
kill_all_vars (void)
{

/* FillMemory (&play, sizeof (play), 0); */
  memset (&play, 0, sizeof (play));

}

void
attach (void)
{
  int i;
  for (i = 1; i < MAX_VARS; i++)
    {
      if (compare ("&life", play.var[i].name))
	{
	  plife = &play.var[i].var;

	}
      if (compare ("&vision", play.var[i].name))
	{
	  pvision = &play.var[i].var;

	}
      if (compare ("&result", play.var[i].name))
	{
	  presult = &play.var[i].var;

	}
      if (compare ("&speed", play.var[i].name))
	{
	  pspeed = &play.var[i].var;

	}
      if (compare ("&timing", play.var[i].name))
	{
	  ptiming = &play.var[i].var;

	}


      if (compare ("&lifemax", play.var[i].name))
	{
	  plifemax = &play.var[i].var;

	}

      if (compare ("&exp", play.var[i].name))
	pexper = &play.var[i].var;
      if (compare ("&strength", play.var[i].name))
	pstrength = &play.var[i].var;
      if (compare ("&defense", play.var[i].name))
	pdefense = &play.var[i].var;
      if (compare ("&gold", play.var[i].name))
	pgold = &play.var[i].var;
      if (compare ("&magic", play.var[i].name))
	pmagic = &play.var[i].var;
      if (compare ("&level", play.var[i].name))
	plevel = &play.var[i].var;
      if (compare ("&player_map", play.var[i].name))
	pmap = &play.var[i].var;
      if (compare ("&cur_weapon", play.var[i].name))
	pcur_weapon = &play.var[i].var;
      if (compare ("&cur_magic", play.var[i].name))
	pcur_magic = &play.var[i].var;
      if (compare ("&last_text", play.var[i].name))
	plast_text = &play.var[i].var;
      if (compare ("&magic_level", play.var[i].name))
	pmagic_level = &play.var[i].var;
      if (compare ("&update_status", play.var[i].name))
	pupdate_status = &play.var[i].var;
      if (compare ("&missile_target", play.var[i].name))
	pmissile_target = &play.var[i].var;
      if (compare ("&enemy_sprite", play.var[i].name))
	penemy_sprite = &play.var[i].var;
      if (compare ("&magic_cost", play.var[i].name))
	pmagic_cost = &play.var[i].var;
      if (compare ("&missle_source", play.var[i].name))
	pmissle_source = &play.var[i].var;


    }

}


void
kill_cur_item (void)
{

  if (*pcur_weapon != 0)
    {
      if (play.item[*pcur_weapon].active == 1)
	{

	  if (weapon_script != 0)
	    if (locate (weapon_script, "DISARM"))
	      run_script (weapon_script);
	  weapon_script =
	    load_script (play.item[*pcur_weapon].name, 0, 0);
	  play.item[*pcur_weapon].active = 0;
	  *pcur_weapon = 0;
	  if (weapon_script != 0)
	    if (locate (weapon_script, "HOLDINGDROP"))
	      run_script (weapon_script);

	  if (weapon_script != 0)
	    if (locate (weapon_script, "DROP"))
	      run_script (weapon_script);
	  weapon_script = 0;
	}
      else
	{
	  Msg (("Error:  Can't kill cur item, none armed."));
	}
    }
}



void
kill_cur_item_script (char name[20])
{
  int select = 0;
  int i, script;

  for (i = 1; i < 17; i++)
    {
      if (play.item[i].active)
	if (compare (play.item[i].name, name))
	  {
	    select = i;
	    goto found;

	  }

    }


  return;

found:

  if (*pcur_weapon == select)
    {
      /* holding it right now */
      if (locate (weapon_script, "HOLDINGDROP"))
	run_script (weapon_script);
      if (locate (weapon_script, "DISARM"))
	run_script (weapon_script);


      *pcur_weapon = 0;
      weapon_script = 0;
    }

  script = load_script (play.item[select].name, 0, 0);

  play.item[select].active = 0;



  if (locate (script, "DROP"))
    run_script (script);

  draw_status_all ();

}


void
kill_cur_magic_script (char name[20])
{
  int select = 0;
  int i, script;

  for (i = 1; i < 9; i++)
    {
      if (play.mitem[i].active)
	if (compare (play.mitem[i].name, name))
	  {
	    select = i;
	    goto found;

	  }
    }


  return;

found:

  if (*pcur_magic == select)
    {
      /* holding it right now */
      if (locate (magic_script, "HOLDINGDROP"))
	run_script (magic_script);
      if (locate (magic_script, "DISARM"))
	run_script (magic_script);


      *pcur_weapon = 0;
      magic_script = 0;
    }

  script = load_script (play.mitem[select].name, 0, 0);

  play.mitem[select].active = 0;


  if (locate (script, "DROP"))
    run_script (script);

  draw_status_all ();

}




void
kill_cur_magic (void)
{

  if (*pcur_magic != 0)
    {
      if (play.mitem[*pcur_magic].active == 1)
	{

	  if (magic_script != 0)
	    if (locate (magic_script, "DISARM"))
	      run_script (magic_script);
	  magic_script = load_script (play.mitem[*pcur_magic].name, 0, 0);
	  play.mitem[*pcur_magic].active = 0;
	  *pcur_magic = 0;

	  if (magic_script != 0)
	    if (locate (magic_script, "HOLDINGDROP"))
	      run_script (magic_script);
	  if (magic_script != 0)
	    if (locate (magic_script, "DROP"))
	      run_script (magic_script);
	  magic_script = 0;
	}
      else
	{
	  Msg (("Error:  Can't kill cur magic, none armed."));
	}
    }
}


void
figure_out (char line[255], int load_seq)
{
  char ev[15][100];
  struct rect hardbox;

  int myseq = 0, myframe = 0;
  int special = 0;
  int special2 = 0;
  int i;

  /* ZeroMemory (&ev, sizeof (ev)); */
  memset (&ev, 0, sizeof (ev));

  for (i = 1; i <= 14; i++)
    {
      seperate_string (line, i, ' ', ev[i]);
      /* Msg(("Word %d is \"%s\"",i,ev[i])); */
    }

  if ((compare (ev[1], "LOAD_SEQUENCE_NOW")) |
      (compare (ev[1], "LOAD_SEQUENCE")))
    /* if (     (load_seq == -1) | (load_seq == atol(ev[3]))  ) */
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy */

/* ZeroMemory (&hardbox, sizeof (rect)); */
      memset (&hardbox, 0, sizeof (struct rect));
      seq[atol (ev[3])].active = 1;
      strcpy (seq[atol (ev[3])].data, line);
      if (compare (ev[4], "BLACK"))
	{
	  load_sprites (ev[2], atol (ev[3]), atol (ev[4]), atol (ev[5]),
			atol (ev[6]), hardbox, 1, 1, 0);
	}
      else if (compare (ev[4], "LEFTALIGN"))
	{
	  load_sprites (ev[2], atol (ev[3]), atol (ev[4]), atol (ev[5]),
			atol (ev[6]), hardbox, 0, 0, 1);
	}
      else if (compare (ev[4], "NOTANIM"))
	{

	  /* not an animation! */
	  load_sprites (ev[2], atol (ev[3]), atol (ev[4]), atol (ev[5]), atol (ev[6]), hardbox, 0, 0, 0);	/* Crap */
	}
      else
	{
	  /* yes, an animation! */
	  hardbox.left = atol (ev[7]);
	  hardbox.top = atol (ev[8]);
	  hardbox.right = atol (ev[9]);
	  hardbox.bottom = atol (ev[10]);

	  load_sprites (ev[2], atol (ev[3]), atol (ev[4]), atol (ev[5]), atol (ev[6]), hardbox, 1, 0, 0);	/* Crap */
	}


      program_idata ();
      return;
    }
  if (compare (ev[1], "SET_SPRITE_INFO"))
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy */


      /* if (k[seq[myseq].frame[myframe]].frame = 0) Msg(("Changing sprite that doesn't exist...")); */

      myseq = atol (ev[2]);
      myframe = atol (ev[3]);
      k[seq[myseq].frame[myframe]].xoffset = atol (ev[4]);
      k[seq[myseq].frame[myframe]].yoffset = atol (ev[5]);
      k[seq[myseq].frame[myframe]].hardbox.left = atol (ev[6]);
      k[seq[myseq].frame[myframe]].hardbox.top = atol (ev[7]);
      k[seq[myseq].frame[myframe]].hardbox.right = atol (ev[8]);
      k[seq[myseq].frame[myframe]].hardbox.bottom = atol (ev[9]);
    }

  if (compare (ev[1], "SET_FRAME_SPECIAL"))
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy */


      /* if (k[seq[myseq].frame[myframe]].frame = 0) Msg(("Changing sprite that doesn't exist...")); */

      myseq = atol (ev[2]);
      myframe = atol (ev[3]);
      special = atol (ev[4]);

      seq[myseq].special[myframe] = special;
      Msg (("Set special.  %d %d %d", myseq, myframe, special));
    }

  if (compare (ev[1], "SET_FRAME_DELAY"))
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy */


      /* if (k[seq[myseq].frame[myframe]].frame = 0) Msg(("Changing sprite that doesn't exist...")); */

      myseq = atol (ev[2]);
      myframe = atol (ev[3]);
      special = atol (ev[4]);

      seq[myseq].delay[myframe] = special;
      Msg (("Set delay.  %d %d %d", myseq, myframe, special));
    }

  if (compare (ev[1], "STARTING_DINK_X"))
    {
      myseq = atol (ev[2]);
      play.x = myseq;
    }




  if (compare (ev[1], "STARTING_DINK_Y"))
    {
      myseq = atol (ev[2]);
      play.y = myseq;
    }



  if (compare (ev[1], "SET_FRAME_FRAME"))
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy */


      /* if (k[seq[myseq].frame[myframe]].frame = 0) Msg(("Changing sprite that doesn't exist...")); */

      myseq = atol (ev[2]);
      myframe = atol (ev[3]);
      special = atol (ev[4]);
      special2 = atol (ev[5]);

      if (special == -1)
	seq[myseq].frame[myframe] = special;
      else
	seq[myseq].frame[myframe] = seq[special].frame[special2];
      Msg (("Set frame.  %d %d %d", myseq, myframe, special));
    }

}


void
program_idata (void)
{
  int i;

  for (i = 1; i < MAX_IDATA; i++)
    {
      if (id[i].type == 0)
	return;

      if (id[i].type == 1)
	{
	  k[seq[id[i].seq].frame[id[i].frame]].xoffset = id[i].xoffset;
	  k[seq[id[i].seq].frame[id[i].frame]].yoffset = id[i].yoffset;
	  CopyRect (&k[seq[id[i].seq].frame[id[i].frame]].hardbox,
		    &id[i].hardbox);

	  /* Msg(("Programming idata type %d in %d...Seq %d Frame %d (Hardbox is %d %d %d %d)", id[i].type, i, */
	  /* id[i].seq, id[i].frame, id[i].hardbox.left,id[i].hardbox.right, id[i].hardbox.top, id[i].hardbox.bottom); */

	}

      if (id[i].type == 2)
	{
	  /* set special */
	  seq[id[i].seq].special[id[i].frame] = id[i].xoffset;
	}
      if (id[i].type == 3)
	{
	  /* set delay */

	  seq[id[i].seq].delay[id[i].frame] = id[i].xoffset;
	}

      if (id[i].type == 4)
	{


	  if (id[i].xoffset == -1)
	    seq[id[i].seq].frame[id[i].frame] = id[i].xoffset;
	  else
	    seq[id[i].seq].frame[id[i].frame] =
	      seq[id[i].xoffset].frame[id[i].yoffset];

	}

    }



}

void
make_idata (int type, int myseq, int myframe, int xoffset, int yoffset,
	    struct rect crect)
{
  int i;
  for (i = 1; i < MAX_IDATA; i++)
    {
      if (id[i].type == 0)
	{
	  /* Msg(("Loading idata type %d in %d...", type, i)); */
	  /* found empty one */
	  id[i].type = type;
	  id[i].seq = myseq;
	  id[i].frame = myframe;
	  id[i].xoffset = xoffset;
	  id[i].yoffset = yoffset;
	  CopyRect (&id[i].hardbox, &crect);

	  return;
	}

    }

  Msg (("Out of idata spots (max is %d), no more sprite corrections can be allowed.", MAX_IDATA));
}

void
pre_figure_out (char line[255], int load_seq)
{
  char ev[15][100];
  struct rect hardbox;

  int myseq = 0, myframe = 0;
  int special = 0;
  int special2 = 0;
  int i;

  /* ZeroMemory (&ev, sizeof (ev)); */
  memset (&ev, 0, sizeof (ev));

  for (i = 1; i <= 14; i++)
    {
      seperate_string (line, i, ' ', ev[i]);
      /* Msg(("Word %d is \"%s\"",i,ev[i])); */
    }


  if (compare (ev[1], "playmidi"))
    {
      if (!dinkedit)
	PlayMidi (ev[2]);
    }

  if (compare (ev[1], "LOAD_SEQUENCE_NOW"))
    /* if (     (load_seq == -1) | (load_seq == atol(ev[3]))  ) */
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy */

      /* ZeroMemory (&hardbox, sizeof (rect)); */
      memset (&hardbox, 0, sizeof (struct rect));
      seq[atol (ev[3])].active = 1;
      strcpy (seq[atol (ev[3])].data, line);
      if (compare (ev[4], "BLACK"))
	{
	  load_sprites (ev[2], atol (ev[3]), atol (ev[4]), atol (ev[5]),
			atol (ev[6]), hardbox, 1, 1, 0);
	}
      else if (compare (ev[4], "LEFTALIGN"))
	{
	  load_sprites (ev[2], atol (ev[3]), atol (ev[4]), atol (ev[5]),
			atol (ev[6]), hardbox, 0, 0, 1);
	}
      else if (compare (ev[4], "NOTANIM"))
	{

	  /* not an animation! */
	  load_sprites (ev[2], atol (ev[3]), atol (ev[4]), atol (ev[5]), atol (ev[6]), hardbox, 0, 0, 0);	/* Crap */
	}
      else
	{
	  /* yes, an animation! */
	  hardbox.left = atol (ev[7]);
	  hardbox.top = atol (ev[8]);
	  hardbox.right = atol (ev[9]);
	  hardbox.bottom = atol (ev[10]);

	  load_sprites (ev[2], atol (ev[3]), atol (ev[4]), atol (ev[5]), atol (ev[6]), hardbox, 1, 0, 0);	/* Crap */
	}


      myseq = atol (ev[2]);
      myframe = atol (ev[3]);
      SetRect (&hardbox, atol (ev[6]), atol (ev[7]), atol (ev[8]),
	       atol (ev[9]));
      make_idata (1, myseq, myframe, atol (ev[4]), atol (ev[5]), hardbox);

      /* program_idata(); */
      return;
    }

  if (compare (ev[1], "LOAD_SEQUENCE"))
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy */
      strcpy (seq[atol (ev[3])].data, line);
      seq[atol (ev[3])].active = 1;
      return;
    }

  if (compare (ev[1], "SET_SPRITE_INFO"))
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy */


      /* if (k[seq[myseq].frame[myframe]].frame = 0) Msg(("Changing sprite that doesn't exist...")); */

      myseq = atol (ev[2]);
      myframe = atol (ev[3]);
      SetRect (&hardbox, atol (ev[6]), atol (ev[7]), atol (ev[8]),
	       atol (ev[9]));
      make_idata (1, myseq, myframe, atol (ev[4]), atol (ev[5]), hardbox);
      return;
    }



  if (compare (ev[1], "SET_FRAME_SPECIAL"))
    {
      myseq = atol (ev[2]);
      myframe = atol (ev[3]);
      special = atol (ev[4]);
      make_idata (2, myseq, myframe, atol (ev[4]), 0, hardbox);
      return;
    }

  if (compare (ev[1], "SET_FRAME_DELAY"))
    {
      myseq = atol (ev[2]);
      myframe = atol (ev[3]);
      special = atol (ev[4]);
      make_idata (3, myseq, myframe, atol (ev[4]), 0, hardbox);
      return;
    }

  if (compare (ev[1], "STARTING_DINK_X"))
    {
      myseq = atol (ev[2]);
      play.x = myseq;

    }

  if (compare (ev[1], "STARTING_DINK_Y"))
    {
      myseq = atol (ev[2]);
      play.y = myseq;
    }



  if (compare (ev[1], "SET_FRAME_FRAME"))
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy */


      /* if (k[seq[myseq].frame[myframe]].frame = 0) Msg(("Changing sprite that doesn't exist...")); */

      myseq = atol (ev[2]);
      myframe = atol (ev[3]);
      special = atol (ev[4]);
      special2 = atol (ev[5]);


      make_idata (4, myseq, myframe, atol (ev[4]), atol (ev[5]), hardbox);

      /* Msg(("Set frame.  %d %d %d",myseq, myframe, special)); */

    }

}


int
next_raise (void)
{
  int crap = *plevel;
  int num = ((100 * crap) * crap);

  if (num > 99999)
    num = 99999;
  return (num);

}


/*bool*/int
inside_box (int x1, int y1, struct rect box)
{

  if (x1 > box.right)
    return (0);
  if (x1 < box.left)
    return (0);

  if (y1 > box.bottom)
    return (0);
  if (y1 < box.top)
    return (0);

  return (1);

}



int
add_sprite_dumb (int x1, int y, int brain, int pseq, int pframe, int size)
{
  int x;
  for (x = 1; x < MAX_SPRITES_AT_ONCE; x++)
    {
      if (spr[x].active == 0)
	{
	  memset (&spr[x], 0, sizeof (spr[x]));

	  /* Msg(("Making sprite %d.",x)); */
	  spr[x].active = 1;
	  spr[x].x = x1;
	  spr[x].y = y;
	  spr[x].my = 0;
	  spr[x].mx = 0;
	  spr[x].speed = 0;
	  spr[x].brain = brain;
	  spr[x].frame = 0;
	  spr[x].pseq = pseq;
	  spr[x].pframe = pframe;
	  spr[x].size = size;
	  spr[x].seq = 0;
	  if (x > last_sprite_created)
	    last_sprite_created = x;

	  spr[x].timer = 0;
	  spr[x].wait = 0;
	  spr[x].lpx[0] = 0;
	  spr[x].lpy[0] = 0;
	  spr[x].moveman = 0;
	  spr[x].seq_orig = 0;


	  spr[x].base_hit = -1;
	  spr[x].base_walk = -1;
	  spr[x].base_die = -1;
	  spr[x].base_idle = -1;
	  spr[x].base_attack = -1;
	  spr[x].last_sound = 0;
	  spr[x].hard = 1;

	  SetRect (&spr[x].alt, 0, 0, 0, 0);
	  spr[x].althard = 0;
	  spr[x].sp_index = 0;
	  spr[x].nocontrol = 0;
	  spr[x].idle = 0;
	  spr[x].strength = 0;
	  spr[x].damage = 0;
	  spr[x].defense = 0;

	  return (x);
	}

    }

  return (0);
}



/*bool*/int
get_box (int h, struct rect* box_crap, struct rect* box_real)
{
  struct rectmath;
  int sz, sy, x_offset, y_offset;


  int txoffset = k[getpic (h)].xoffset;
  int tyoffset = k[getpic (h)].yoffset;

  int mplayx = playx;
  int mplayl = playl;
  int mplayy = playy;
  struct rect krect;


  if (spr[h].noclip)
    {
      mplayx = 640;
      mplayl = 0;
      mplayy = 480;

    }


  if (getpic (h) < 1)
    {

      if (dinkedit)
	Msg (("Yo, sprite %d has a bad pic. (Map %d) Seq %d, Frame %d", h,
	      cur_map, spr[h].pseq, spr[h].pframe));
      else
	Msg (("Yo, sprite %d has a bad pic. (Map %d) Seq %d, Frame %d", h,
	      *pmap, spr[h].pseq, spr[h].pframe));
      /* spr[h].pic = 44; */
    }






  *box_real = k[getpic (h)].box;
  CopyRect (&krect, &k[getpic (h)].box);

  if (spr[h].size != 100)
    sz = ((krect.right * spr[h].size) / 100);
  else
    sz = 0;
  if (spr[h].size != 100)
    sy = ((krect.bottom * spr[h].size) / 100);
  else
    sy = 0;

  if (spr[h].size != 100)
    {
      sz = ((sz - krect.right) / 2);
      sy = ((sy - krect.bottom) / 2);
    }


  box_crap->left = spr[h].x - txoffset - sz;
  math.left = spr[h].x - txoffset;

  box_crap->top = spr[h].y - tyoffset - sy;
  math.top = spr[h].y - tyoffset;

  box_crap->right = (math.left + (krect.right - krect.left)) + sz;
  math.right = math.left + krect.right;

  box_crap->bottom = (math.top + (krect.bottom - krect.top)) + sy;
  math.bottom = math.top + krect.bottom;
  /* if (OffsetRect(&spr[h].alt2,44,33) == 0) Msg(("Error with set rect")); */


  if ((spr[h].alt.right != 0) | (spr[h].alt.left != 0) | (spr[h].alt.top !=
							  0) | (spr[h].alt.
								right != 0))
    {

      /* spr[h].alt.bottom = 10; */

      box_crap->left = box_crap->left + spr[h].alt.left;
      box_crap->top = box_crap->top + spr[h].alt.top;
      box_crap->right =
	box_crap->right - (k[getpic (h)].box.right - spr[h].alt.right);

      box_crap->bottom =
	box_crap->bottom - (k[getpic (h)].box.bottom - spr[h].alt.bottom);
      CopyRect (box_real, &spr[h].alt);
      /* Msg(("I should be changing box size... %d %d,%d,%d",spr[h].alt.right,spr[h].alt.left,spr[h].alt.top,spr[h].alt.bottom)); */

    }

  /* ********* Check to see if they need to be cut down and do clipping */






  if (spr[h].size == 0)
    spr[h].size = 100;

  if (dinkedit)
    if ((mode == 1) | (mode == 5))
      if (draw_map_tiny < 1)
	goto do_draw;

  if (box_crap->left < mplayl)
    {
      x_offset = box_crap->left * (-1) + mplayl;
      box_crap->left = mplayl;
      /* box_real->left += (math.left * (-1)) + mplayl; */

      if (spr[h].size != 100)
	box_real->left += (((x_offset * 100) / (spr[h].size)));
      else

	box_real->left += x_offset;
      if (box_crap->right - 1 < mplayl)
	goto nodraw;
    }

  if (box_crap->top < 0)
    {
      y_offset = box_crap->top * (-1);
      box_crap->top = 0;

      /* box_real->top += math.top * (-1) + 0; */
      if (spr[h].size != 100)
	box_real->top += (((y_offset * 100) / (spr[h].size)));

      else
	box_real->top += y_offset;
      if (box_crap->bottom - 1 < 0)
	goto nodraw;
    }


  if (box_crap->right > mplayx)
    {
      x_offset = (box_crap->right) - mplayx;
      box_crap->right = mplayx;
      /* x_real->right -= math.right - mplayx; */
      if (spr[h].size != 100)
	box_real->right -= ((x_offset * 100) / (spr[h].size));
      else
	box_real->right -= x_offset;
      if (box_crap->left + 1 > mplayx)
	goto nodraw;

      /* Msg(("ok, crap right is %d, real right is %d.",box_crap->right - box_crap->left,box_real->right)); */
    }

  if (box_crap->bottom > mplayy)
    {
      y_offset = (box_crap->bottom) - mplayy;
      box_crap->bottom = mplayy;
      if (spr[h].size != 100)
	box_real->bottom -= ((y_offset * 100) / (spr[h].size));
      else
	box_real->bottom -= y_offset;
      if (box_crap->top + 1 > mplayy)
	goto nodraw;
    }




do_draw:

 return (1);

nodraw:

  return (0);

}


void
kill_callbacks_owned_by_script (int script)
{
  int i;
  for (i = 1; i < MAX_CALLBACKS; i++)
    {
      if (callback[i].owner == script)
	{
	  if (debug_mode)
	    Msg (("Kill_all_callbacks just killed %d for script %d", i,
		  script));
	  /* killed callback */
	  callback[i].active = 0;
	}
    }


}
void
kill_script (int k)
{
/* UNREFERENCED   int i; */

  if (rinfo[k] != NULL)
    {
      int i;
      kill_callbacks_owned_by_script (k);

      /* now lets kill all local vars assocated with this script */

      for (i = 1; i < MAX_VARS; i++)
	{
	  if (play.var[i].active)
	    if (play.var[i].scope == k)
	      {
		play.var[i].active = 0;
	      }

	}
      if (debug_mode)
	Msg (("Killed script %s. (num %d)", rinfo[k]->name, k));


      free (rinfo[k]);
      rinfo[k] = NULL;
      free (rbuf[k]);
      rbuf[k] = NULL;
    }



}




void
kill_all_scripts (void)
{
  int j;

  for (j = 1; j < MAX_SCRIPTS; j++)
    {

      if (rinfo[j] != NULL)
	if (rinfo[j]->sprite != 1000)
	  kill_script (j);
    }

  for (j = 1; j <= MAX_CALLBACKS; j++)
    {
      if (callback[j].active)
	{
	  if ((rinfo[callback[j].owner] != NULL)
	      && (rinfo[callback[j].owner]->sprite == 1000))
	    {

	    }
	  else
	    {
	      if (debug_mode)
		Msg (("Killed callback %p.  (was attached to script %d.)",
		      (void *)k, callback[j].owner));
	      callback[j].active = 0;
	    }
	}
    }
}

void
kill_all_scripts_for_real (void)
{
  int j;

  for (j = 1; j < MAX_SCRIPTS; j++)
    {

      if (rinfo[j] != NULL)
	kill_script (j);
    }

  for (j = 1; j <= MAX_CALLBACKS; j++)
    {

      callback[j].active = 0;
    }
}

int
add_callback (char name[20], int n1, int n2, int script)
{
  int k;
  for (k = 1; k < MAX_CALLBACKS; k++)
    {
      if (callback[k].active == 0)
	{
	  memset (&callback[k], 0, sizeof (callback[k]));

	  callback[k].active = 1;
	  callback[k].min = n1;
	  callback[k].max = n2;
	  callback[k].owner = script;
	  strcpy (callback[k].name, name);

	  if (debug_mode)
	    Msg (("Callback added to %d.", k));
	  return (k);
	}

    }

  Msg (("Couldn't add callback, all out of space"));

  return (0);

}

int
add_sprite (int x1, int y, int brain, int pseq, int pframe)
{
  int x;
  for (x = 1; x < MAX_SPRITES_AT_ONCE; x++)
    {
      if (spr[x].active == 0)
	{
	  memset (&spr[x], 0, sizeof (spr[x]));

	  spr[x].active = 1;
	  spr[x].x = x1;
	  spr[x].y = y;
	  spr[x].my = 0;
	  spr[x].mx = 0;
	  spr[x].speed = 1;
	  spr[x].brain = brain;
	  spr[x].frame = 0;
	  spr[x].pseq = pseq;
	  spr[x].pframe = pframe;
	  spr[x].seq = 0;
	  if (x > last_sprite_created)
	    last_sprite_created = x;
	  spr[x].timer = 33;
	  spr[x].wait = 0;
	  spr[x].lpx[0] = 0;
	  spr[x].lpy[0] = 0;
	  spr[x].moveman = 0;
	  spr[x].size = 100;
	  spr[x].que = 0;
	  spr[x].strength = 0;
	  spr[x].damage = 0;
	  spr[x].defense = 0;
	  spr[x].hard = 1;


	  return (x);
	}

    }

  return (0);
}

void
check_sprite_status (int h)
{
/* HRESULT dderror; */
/* UNREFERENCED   char word1[80]; */

  /* is sprite in memory? */
  if (spr[h].pseq > 0)
    {
      /* Msg(("Smartload: Loading seq %d..", spr[h].seq)); */
      if (seq[spr[h].pseq].frame[1] == 0)
	{
	  figure_out (seq[spr[h].pseq].data, 0);
	}
      else
	{
	  /* it's been loaded before.. is it lost or still there? */
	  /* Msg(("Sprite %d's seq is %d",h,spr[h].seq)); */


	}
    }


}


void
check_frame_status (int h, int frame)
{
/* UNREFERENCED   char word1[80]; */

  if (seq[h].active == 0)
    return;

  if (h > 0)
    {
      /* Msg(("Smartload: Loading seq %d..", spr[h].seq)); */
      if (seq[h].frame[1] == 0)
	{
	  first_frame = 1;
	  figure_out (seq[h].data, 0);
	  first_frame = 0;
	}
      else
	{
	  /* it's been loaded before.. is it lost or still there? */
	  /* Msg(("Sprite %d's seq is %d",h,spr[h].seq)); */

	}
    }


}

void
check_seq_status (int h)
{
/* UNREFERENCED   char word1[80]; */

  if (seq[h].active == 0)
    return;
  if (h > 0)
    if (h < MAX_SEQUENCES)
      {
	/* Msg(("Smartload: Loading seq %d..", spr[h].seq)); */

	if (seq[h].frame[1] == 0)
	  {
	    figure_out (seq[h].data, 0);
	  }
	else
	  {
	    /* it's been loaded before.. is it lost or still there? */
	    /* Msg(("Sprite %d's seq is %d",h,spr[h].seq)); */

	  }
      }


}

void
check_base (int base)
{
  int i;
  for (i = 1; i < 10; i++)
    {
      if (seq[base + i].active == 1)
	check_seq_status (base + i);

    }


}

void
check_sprite_status_full (int h)
{
/* HRESULT dderror; */
/* UNREFERENCED   char word1[80]; */

  /* same as above but checks for all seq's used by the (base) commands */

  /* is sprite in memory? */

  check_seq_status (spr[h].pseq);

  if (spr[h].base_walk > -1)
    check_base (spr[h].base_walk);


}


int
does_sprite_have_text (int sprite)
{
  /* Msg(("getting callback # with %d..", sprite)); */
  int k;
  for (k = 1; k <= MAX_SPRITES_AT_ONCE; k++)
    {
      if (spr[k].active)
	if (spr[k].owner == sprite)
	  if (spr[k].brain == 8)
	    {
	      /* Msg(("Found it!  returning %d.", k)); */

	      return (k);
	    }

    }

  return (0);

}

int
var_exists (char name[20], int scope)
{
  int i;
  for (i = 1; i < MAX_VARS; i++)
    {
      if (play.var[i].active)
	{
	  if (compare (play.var[i].name, name))
	    {

	      if (scope == play.var[i].scope)
		{
		  /* Msg(("Found match for %s.", name)); */
		  return (i);
		}
	    }



	}
    }

  return (0);
}


void
place_sprites_game (void)
{
  int sprite;

  BOOL bs[MAX_SPRITES_AT_ONCE];
  int rank[MAX_SPRITES_AT_ONCE];
  int highest_sprite;
  int hs;
  int r1;
  int j, oo;

  update_play_changes ();

  memset (&bs, 0, sizeof (bs));

  for (r1 = 1; r1 < 100; r1++)
    {
      int h1;
      highest_sprite = 20000;	/* more than it could ever be */

      rank[r1] = 0;

      for (h1 = 1; h1 < 100; h1++)
	{
	  if (bs[h1] == 0)
	    {
	      if (pam.sprite[h1].active)
		{
		  if (pam.sprite[h1].que != 0)
		    hs = pam.sprite[h1].que;
		  else
		    hs = pam.sprite[h1].y;
		  if (hs < highest_sprite)
		    {
		      highest_sprite = hs;
		      rank[r1] = h1;
		    }
		}

	    }
	}
      if (rank[r1] != 0)
	bs[rank[r1]] = 1;
    }

  for (oo = 1; rank[oo] > 0; oo++)
    {
      /* Msg(("Ok, rank[%d] is %d.",oo,rank[oo])); */
      j = rank[oo];

      if (pam.sprite[j].active == 1)
	if ((pam.sprite[j].vision == 0) || (pam.sprite[j].vision == *pvision))
	  {
	    check_seq_status (pam.sprite[j].seq);

	    /* we have instructions to make a sprite */
	    if ((pam.sprite[j].type == 0) | (pam.sprite[j].type == 2))
	      {
		/* make it part of the background (much faster) */
		sprite =
		  add_sprite_dumb (pam.sprite[j].x, pam.sprite[j].y, 0,
				   pam.sprite[j].seq, pam.sprite[j].frame,
				   pam.sprite[j].size);
		/* Msg(("Background sprite %d has hard of %d..", j, pam.sprite[j].hard)); */
		spr[sprite].hard = pam.sprite[j].hard;
		spr[sprite].sp_index = j;
		CopyRect (&spr[sprite].alt, &pam.sprite[j].alt);

		check_sprite_status_full (sprite);
		if (pam.sprite[j].type == 0)
		  draw_sprite_game (lpDDSTwo, sprite);

		if (spr[sprite].hard == 0)
		  {
		    /*if (pam.sprite[j].prop == 0)
		       add_hardness(sprite, 1); else */
		    add_hardness (sprite, 100 + j);
		  }
		spr[sprite].active = 0;
	      }

	    if (pam.sprite[j].type == 1)
	      {
		/* make it a living sprite */
		sprite =
		  add_sprite_dumb (pam.sprite[j].x, pam.sprite[j].y, 0,
				   pam.sprite[j].seq, pam.sprite[j].frame,
				   pam.sprite[j].size);

		spr[sprite].hard = pam.sprite[j].hard;

		/* assign addition parms to the new sprite */
		spr[sprite].sp_index = j;

		spr[sprite].brain = pam.sprite[j].brain;
		spr[sprite].speed = pam.sprite[j].speed;
		spr[sprite].base_walk = pam.sprite[j].base_walk;
		spr[sprite].base_idle = pam.sprite[j].base_idle;
		spr[sprite].base_attack = pam.sprite[j].base_attack;
		spr[sprite].base_hit = pam.sprite[j].base_hit;
		spr[sprite].hard = pam.sprite[j].hard;
		spr[sprite].timer = pam.sprite[j].timer;
		spr[sprite].que = pam.sprite[j].que;

		spr[sprite].sp_index = j;

		CopyRect (&spr[sprite].alt, &pam.sprite[j].alt);

		spr[sprite].base_die = pam.sprite[j].base_die;
		spr[sprite].strength = pam.sprite[j].strength;
		spr[sprite].defense = pam.sprite[j].defense;
		spr[sprite].gold = pam.sprite[j].gold;
		spr[sprite].exp = pam.sprite[j].exp;
		spr[sprite].nohit = pam.sprite[j].nohit;
		spr[sprite].touch_damage = pam.sprite[j].touch_damage;
		spr[sprite].hitpoints = pam.sprite[j].hitpoints;
		spr[sprite].sound = pam.sprite[j].sound;
		check_sprite_status_full (sprite);
		if (pam.sprite[j].prop == 0)
		  if (spr[sprite].sound != 0)
		    {
		      /* make looping sound */
		      Msg (("making sound with sprite %d..", sprite));
		      SoundPlayEffect (spr[sprite].sound, 22050, 0, sprite,
				       1);
		    }
		if (spr[sprite].brain == 3)
		  {
		    check_seq_status (21);
		    check_seq_status (23);
		    check_seq_status (24);
		    check_seq_status (26);
		    check_seq_status (27);
		    check_seq_status (29);
		    check_seq_status (111);
		    check_seq_status (113);
		    check_seq_status (117);
		    check_seq_status (119);
		    check_seq_status (121);
		    check_seq_status (123);
		    check_seq_status (127);
		    check_seq_status (129);
		  }

		if (spr[sprite].hard == 0)
		  {
		    /*              if (pam.sprite[j].prop == 0)
		       add_hardness(sprite, 1); else */
		    add_hardness (sprite, 100 + j);
		  }
		/* does it need a script loaded? */

		if (strlen (pam.sprite[j].script) > 1)
		  {
		    spr[sprite].script =
		      load_script (pam.sprite[j].script, sprite, 1);
		  }
	      }
	    /* Msg(("I just made sprite %d because rank[%d] told me to..",sprite,j)); */
	  }
    }
}


/*bool*/int
kill_last_sprite (void)
{
  int found = 0;
  /*bool*/int nosetlast = 0;
  int k;

  for (k = 1; k < MAX_SPRITES_AT_ONCE; k++)

    if (spr[k].active)
      {
	if (spr[k].live)
	  {
	    nosetlast = 1;
	    goto crazy;
	  }
	found = k;
      crazy:;
      }
  if (found > 1)
    {
      spr[found].active = 0;
      if (nosetlast == 0)
	last_sprite_created = found - 1;
      return (1);
    }
  /* we didn't kill any sprites, only 1 remains */
  return (0);
}

int
hurt_thing (int h, int damage, int special)
{
  int num;
  /* lets hurt this sprite but good */
  if (damage < 1)
    return (0);
  num = damage - spr[h].defense;

  /* Msg(("num is %d.. defense was %d.of sprite %d", num, spr[h].defense, h)); */
  if (num < 1)
    num = 0;

  if (num == 0)
    {
      if ((rand () % 2) + 1 == 1)
	num = 1;
    }

  spr[h].damage += num;
  return (num);
  /* draw blood here */
}

void
random_blood (int mx, int my, int h)
{
  int myseq;
  int crap2;

  if ((rand () % 2) == 1)
    myseq = 188;
  else
    myseq = 187;

  crap2 = add_sprite (mx, my, 5, myseq, 1);

  spr[crap2].speed = 0;
  spr[crap2].base_walk = -1;
  spr[crap2].nohit = 1;
  spr[crap2].seq = myseq;
  if (h > 0)
    spr[crap2].que = spr[h].y + 1;

}

void
place_sprites_game_background (void)
{
  int sprite;

  BOOL bs[MAX_SPRITES_AT_ONCE];
  int rank[MAX_SPRITES_AT_ONCE];
  int highest_sprite;
  int hs;
  int r1;
  int j, oo;

  memset (&bs, 0, sizeof (bs));
  for (r1 = 1; r1 < 100; r1++)
    {
      int h1;

      highest_sprite = 20000;	/* more than it could ever be */
      rank[r1] = 0;

      for (h1 = 1; h1 < 100; h1++)
	{
	  if (bs[h1] == 0)
	    {
	      if (pam.sprite[h1].active)
		if (pam.sprite[h1].type == 0)
		  {
		    if (pam.sprite[h1].que != 0)
		      hs = pam.sprite[h1].que;
		    else
		      hs = pam.sprite[h1].y;
		    if (hs < highest_sprite)
		      {
			highest_sprite = hs;
			rank[r1] = h1;
		      }
		  }

	    }
	}
      if (rank[r1] != 0)
	bs[rank[r1]] = 1;
    }

  for (oo = 1; rank[oo] > 0; oo++)
    {
      /* Msg(("Ok, rank[%d] is %d.",oo,rank[oo])); */
      j = rank[oo];

      if (pam.sprite[j].active == 1)
	if ((pam.sprite[j].vision == 0) || (pam.sprite[j].vision == *pvision))
	  {

	    check_seq_status (pam.sprite[j].seq);

	    /* we have instructions to make a sprite */
	    if (pam.sprite[j].type == 0)
	      {
		/* make it part of the background (much faster) */

		sprite =
		  add_sprite_dumb (pam.sprite[j].x, pam.sprite[j].y, 0,
				   pam.sprite[j].seq, pam.sprite[j].frame,
				   pam.sprite[j].size);
		/* Msg(("Background sprite %d has hard of %d..", j, pam.sprite[j].hard)); */
		check_sprite_status_full (sprite);
		draw_sprite_game (lpDDSTwo, sprite);
		spr[sprite].active = 0;
	      }


	  }

    }


}

void
fill_back_sprites (void)
{
  int sprite;

  BOOL bs[MAX_SPRITES_AT_ONCE];
  int rank[MAX_SPRITES_AT_ONCE];
  int highest_sprite;
  int hs;
  int r1;
  int j, oo;

  memset (&bs, 0, sizeof (bs));

  for (r1 = 1; r1 < 100; r1++)
    {
      int h1;

      highest_sprite = 20000;	/* more than it could ever be */
      rank[r1] = 0;

      for (h1 = 1; h1 < 100; h1++)
	{
	  if (bs[h1] == 0)
	    {
	      if (pam.sprite[h1].active)
		if (pam.sprite[h1].type != 1)
		  if (pam.sprite[h1].hard == 0)
		    {
		      if (pam.sprite[h1].que != 0)
			hs = pam.sprite[h1].que;
		      else
			hs = pam.sprite[h1].y;
		      if (hs < highest_sprite)
			{
			  highest_sprite = hs;
			  rank[r1] = h1;
			}
		    }

	    }
	}
      if (rank[r1] != 0)
	bs[rank[r1]] = 1;
    }

  for (oo = 1; rank[oo] > 0; oo++)
    {
      /* Msg(("Ok, rank[%d] is %d.",oo,rank[oo])); */
      j = rank[oo];

      if (pam.sprite[j].active == 1)
	if ((pam.sprite[j].vision == 0) || (pam.sprite[j].vision == *pvision))
	  {
	    {
	      /* make it part of the background (much faster) */

	      sprite =
		add_sprite_dumb (pam.sprite[j].x, pam.sprite[j].y, 0,
				 pam.sprite[j].seq, pam.sprite[j].frame,
				 pam.sprite[j].size);
	      spr[sprite].hard = pam.sprite[j].hard;
	      spr[sprite].sp_index = j;
	      CopyRect (&spr[sprite].alt, &pam.sprite[j].alt);
	      check_sprite_status_full (sprite);
	      if (spr[sprite].hard == 0)
		{
		  /*if (pam.sprite[j].prop == 0)
		     add_hardness(sprite, 1); else */
		  add_hardness (sprite, 100 + j);

		}
	      spr[sprite].active = 0;
	    }


	  }

    }


}



void
add_item (char name[10], int mseq, int mframe, /*bool*/int magic)
{
  int i;
  if (magic == 0)
    {
      /* add reg item */
      for (i = 1; i < 17; i++)
	{
	  if (play.item[i].active == 0)
	    {
	      int crap1;

	      if (debug_mode)
		Msg (("Weapon/item %s added to inventory.", name));
	      play.item[i].seq = mseq;
	      play.item[i].frame = mframe;
	      strcpy (play.item[i].name, name);
	      play.item[i].active = 1;

	      crap1 = load_script (play.item[i].name, 1000,
				       0);

	      if (locate (crap1, "PICKUP"))
		run_script (crap1);

	      return;
	    }
	}

    }
  else
    {
      int i;
      /* add magic item */
      for (i = 1; i < 9; i++)
	{
	  if (play.mitem[i].active == 0)
	    {
	      int crap;
	      if (debug_mode)
		Msg (("Magic %s added to inventory.", name));
	      play.mitem[i].seq = mseq;
	      play.mitem[i].frame = mframe;
	      strcpy (play.mitem[i].name, name);

	      play.mitem[i].active = 1;

	      crap = load_script (play.mitem[i].name, 1000,
				      0);

	      if (locate (crap, "PICKUP"))
		run_script (crap);

	      return;
	    }
	}


    }
}
